#!/system/bin/sh


function correctpath(){
	case `echo "$1"` in
	/system_ext* )
		echo "/system"$1""
	;;
	/system* )
		echo "$1"
	;;
	/vendor* )
		echo "/system"$1""
	;;
	/product* )
		echo "/system"$1""
	;;
	esac
}

for file in `find /system /vendor /product /system_ext -iname "*.rc" 2> /dev/null ` ;do
	grep -l "cnss_diag" $file 2> /dev/null && {
		file=$(correctpath $file)
		mkdir -p $MODPATH${file%/*}
		cp -rf $file $MODPATH${file%/*}
		sed -i 's/.*cnss_diag.*/#&/g' $MODPATH$file
		sed -i 's/.*tcpdump.*/#&/g' $MODPATH$file
	}
done

for file in `find /system /vendor /product /system_ext -iname "cnss_diag" 2> /dev/null ` ;do
		file=$(correctpath $file)
		mkdir -p $MODPATH${file%/*}
		touch $MODPATH$file
done
