#!/system/bin/sh

# MagiskHide Props Config
# Copyright (c) 2018-2020 Didgeridoohan @ XDA Developers
# Licence: MIT

PRINTSV=113
PRINTSTRANSF=520

# Certified fingerprints
# Current fingerprints count=577
# Unique devices=404
PRINTSLIST="
Asus ZenFone 2 Laser ASUS_Z00LD (6.0.1):Asus:ASUS_Z00LD=asus/WW_Z00L/ASUS_Z00L_63:6.0.1/MMB29P/WW_user_21.40.1220.2196_20180308:user/release-keys
Asus ZenFone 3 Max ASUS_X00DD (7.1.1 & 8.1.0):Asus:ASUS_X00DD=asus/WW_Phone/ASUS_X00DD:7.1.1/NMF26F/14.0200.1712.347-20171214:user/release-keys;asus/WW_Phone/ASUS_X00DD:8.1.0/OPM1.171019.011/15.0200.1812.503-0:user/release-keys__2018-12-05
Asus ZenFone 3 Ultra ASUS_A001 (7.0):Asus:ASUS_A001=asus/WW_Phone/ASUS_A001:7.0/NRD90M/14.1010.1804.75-20180612:user/release-keys__2018-04-01
Asus ZenFone 4 ASUS_Z01KD (8.0.0 & 9):Asus:ASUS_Z01KD=asus/WW_Z01KD/ASUS_Z01KD_1:8.0.0/OPR1.170623.032/15.0610.1909.39-0:user/release-keys__2019-09-01;asus/WW_Z01KD/ASUS_Z01KD_1:9/PPR1.180610.009/16.0620.1912.23-0:user/release-keys__2019-12-01
Asus ZenFone 4 Max ASUS_X00HD (7.1.1):Asus:ASUS_X00HD=asus/WW_Phone/ASUS_X00HD_4:7.1.1/NMF26F/14.2016.1801.372-20180119:user/release-keys
Asus ZenFone 5 ASUS_X00QD (9):Asus:ASUS_X00QD=asus/WW_X00QD/ASUS_X00QD:9/PPR1.180610.009/16.0615.2006.131-0:user/release-keys__2020-06-01
Asus ZenFone 5Z ASUS_Z01RD (9):Asus:ASUS_Z01RD=asus/WW_Z01RD/ASUS_Z01R_1:9/PPR1.180610.009/WW_90.11.162.72_20190531:user/release-keys__2019-05-01
Asus ZenFone 6 ASUS_I01WD (9):Asus:ASUS_I01WD=asus/WW_I01WD/ASUS_I01WD:9/PPR2.181005.003/16.1220.1909.193-0:user/release-keys__2019-09-01
Asus ZenFone 7/7 Pro Europe ASUS_I002D (10):Asus:ASUS_I002D=asus/EU_I002D/ASUS_I002D:10/QKQ1.200127.002/29.14.53.5_20201111:user/release-keys__2020-10-05
Asus ZenFone 7/7 Pro Global ASUS_I002D (10):Asus:ASUS_I002D=asus/WW_I002D/ASUS_I002D:10/QKQ1.200127.002/29.12.18.14_20200902:user/release-keys__2020-07-05
Asus ZenFone Max M1 ASUS_X00PD (8.0.0 & 9 & 10):Asus:ASUS_X00PD=asus/WW_X00PD/ASUS_X00P_1:8.0.0/OPR1.170623.032/15.00.2007.122:user/release-keys__2020-07-05;asus/WW_X00PD/ASUS_X00P_1:9/PPR1.180610.009/16.00.1906.411:user/release-keys__2019-06-05;asus/WW_X00PD/ASUS_X00P_1:10/QKQ1.191002.002/17.00.2003.23-20200401:user/release-keys__2020-03-05
Asus ZenFone Max Pro M1 ASUS_X00TD (8.1.0 & 9):Asus:ASUS_X00TD=asus/RU_X00TD/ASUS_X00T_6:8.1.0/OPM1/15.2016.1902.340-20190216:user/release-keys__2019-02-01;asus/WW_X00TD/ASUS_X00T_3:9/PKQ1/16.2017.2009.087-20200826:user/release-keys__2020-09-05
Asus ZenFone Max Pro M2 ASUS_X01BD (9):asus:ASUS_X01BD=asus/WW_X01BD/ASUS_X01BD_1:9/PKQ1/16.2017.2007.094-20200705:user/release-keys__2020-07-05
Asus ZenPad S 8.0 P01MA (6.0.1):Asus:P01MA=asus/WW_P01M/P01M_3:6.0.1/MMB29P/WW_P01M-V5.6.0-20170608:user/release-keys
BLU S1 (7.0):Blu:BLU_S1=BLU/BLU_S1/S0320WW:7.0/NRD90M/1514191903:user/release-keys
Elephone U Pro (8.0.0):Elephone:U_Pro=Elephone/U_Pro/U_Pro:8.0.0/Elephone_U_Pro_20180917/09172123:user/release-keys__2018-09-05
Essential PH-1 (7.1.1 & 8.1.0 & 9 & 10):Essential:PH-1=essential/mata/mata:7.1.1/NMK24B/468:user/release-keys__2018-02-05;essential/mata/mata:8.1.0/OPM1.180104.267/399:user/release-keys__2018-07-05;essential/mata/mata:9/PQ1A.190105.112/550:user/release-keys__2019-08-05;essential/mata/mata:10/QQ1A.200105.032/540:user/release-keys__2020-02-05
Fairphone 2 (6.0.1):Fairphone:FP2=Fairphone/FP2/FP2:6.0.1/FP2-gms-17.09.3/FP2-gms-17.09.3:user/release-keys
Fairphone 3/3 Plus (10):Fairphone:FP3=Fairphone/FP3/FP3:10/8901.3.A.0054.20200929/09290922:user/release-keys__2020-10-05
Fxtec Pro 1 (9):Fxtec:QX1000=Fxtec/QX1000_EEA/QX1000:9/PKQ1.190723.001/05500.20Q202:user/release-keys__2020-04-05
Google Nexus 4 (5.1.1):LGE:Nexus 4=google/occam/mako:5.1.1/LMY48T/2237560:user/release-keys
Google Nexus 5 (6.0.1):LGE:Nexus 5=google/hammerhead/hammerhead:6.0.1/M4B30Z/3437181:user/release-keys
Google Nexus 5X (6.0 & 6.0.1 & 7.0 & 7.1.1 & 7.1.2 & 8.0.0 & 8.1.0):LGE:Nexus 5X=google/bullhead/bullhead:6.0/MDB08L/2343525:user/release-keys;google/bullhead/bullhead:6.0.1/MTC20K/3142008:user/release-keys;google/bullhead/bullhead:7.0/NRD91N/3318108:user/release-keys;google/bullhead/bullhead:7.1.1/N4F26U/3757780:user/release-keys;google/bullhead/bullhead:7.1.2/N2G48C/4104010:user/release-keys;google/bullhead/bullhead:8.0.0/OPR4.170623.020/4443074:user/release-keys;google/bullhead/bullhead:8.1.0/OPM7.181205.001/5080180:user/release-keys__2018-12-05
Google Nexus 6 (5.0 & 5.0.1 & 5.1 & 5.1.1 & 6.0 & 6.0.1 & 7.0 & 7.1.1):Motorola:Nexus 6=google/shamu/shamu:5.0/LRX21O/1570415:user/release-keys;google/shamu/shamu:5.0.1/LRX22C/1602158:user/release-keys;google/shamu/shamu:5.1/LMY47D/1743759:user/release-keys;google/shamu/shamu:5.1.1/LMY48Y/2364368:user/release-keys;google/shamu/shamu:6.0/MRA58N/2289998:user/release-keys;google/shamu/shamu:6.0.1/MOB31T/3671974:user/release-keys;google/shamu/shamu:7.0/NBD92F/3753956:user/release-keys;google/shamu/shamu:7.1.1/N6F27M/4299435:user/release-keys
Google Nexus 6P (6.0 & 6.0.1 & 7.0 & 7.1.1 & 7.1.2 & 8.0.0 & 8.1.0):Huawei:Nexus 6P=google/angler/angler:6.0/MDB08L/2343525:user/release-keys;google/angler/angler:6.0.1/MTC20L/3230295:user/release-keys;google/angler/angler:7.0/NBD91K/3318877:user/release-keys;google/angler/angler:7.1.1/N4F26U/3757780:user/release-keys;google/angler/angler:7.1.2/N2G48C/4104010:user/release-keys;google/angler/angler:8.0.0/OPR5.170623.014/4443154:user/release-keys;google/angler/angler:8.1.0/OPM7.181205.001/5080180:user/release-keys__2018-12-05
Google Nexus 7 2012 Mobile (5.1.1):Asus:Nexus 7=google/nakasig/tilapia:5.1.1/LMY47V/1836172:user/release-keys
Google Nexus 7 2012 WiFi (5.1.1):Asus:Nexus 7=google/nakasi/grouper:5.1.1/LMY47V/1836172:user/release-keys
Google Nexus 7 2013 Mobile (6.0.1):Asus:Nexus 7=google/razorg/deb:6.0.1/MOB30X/3036618:user/release-keys
Google Nexus 7 2013 WiFi (6.0.1):Asus:Nexus 7=google/razor/flo:6.0.1/MOB30X/3036618:user/release-keys
Google Nexus 9 LTE (5.0.1 & 5.0.2 & 5.1.1 & 6.0 & 6.0.1 & 7.0 & 7.1.1):HTC:Nexus 9=google/volantisg/flounder_lte:5.0.1/LRX22C/1602158:user/release-keys;google/volantisg/flounder_lte:5.0.2/LRX22L/1816899:user/release-keys;google/volantisg/flounder_lte:5.1.1/LMY49F/2495589:user/release-keys;google/volantisg/flounder_lte:6.0/MRA58N/2289998:user/release-keys;google/volantisg/flounder_lte:6.0.1/MOB31E/3142026:user/release-keys;google/volantisg/flounder_lte:7.0/NRD91N/3318108:user/release-keys;google/volantisg/flounder_lte:7.1.1/N4F27P/4333386:user/release-keys
Google Nexus 9 WiFi (5.0 & 5.0.1 & 5.0.2 & 5.1.1 & 6.0 & 6.0.1 & 7.0 & 7.1.1):HTC:Nexus 9=google/volantis/flounder:5.0/LRX21R/1573874:user/release-keys;google/volantis/flounder:5.0.1/LRX22C/1602158:user/release-keys;google/volantis/flounder:5.0.2/LRX22L/1816899:user/release-keys;google/volantis/flounder:5.1.1/LMY48T/2237560:user/release-keys;google/volantis/flounder:6.0/MRA58N/2289998:user/release-keys;google/volantis/flounder:6.0.1/MOB30W/3031100:user/release-keys;google/volantis/flounder:7.0/NRD91N/3318108:user/release-keys;google/volantis/flounder:7.1.1/N9F27M/4333998:user/release-keys
Google Nexus 10 (5.1.1):Samsung:Nexus 10=google/mantaray/manta:5.1.1/LMY49J/2640980:user/release-keys
Google Nexus Player (5.0 & 5.1 & 5.1.1 & 6.0.1 & 7.0 & 7.1.1 & 7.1.2 & 8.0.0):Asus:Nexus Player=google/fugu/fugu:5.0/LRX21V/1586762:user/release-keys;google/fugu/fugu:5.1/LMY47D/1743759:user/release-keys;google/fugu/fugu:5.1.1/LMY48N/2167335:user/release-keys;google/fugu/fugu:6.0.1/MOB30W/3031100:user/release-keys;google/fugu/fugu:7.0/NRD91N/3318108:user/release-keys;google/fugu/fugu:7.1.1/NMF27D/3783773:user/release-keys;google/fugu/fugu:7.1.2/N2G48C/4104010:user/release-keys;google/fugu/fugu:8.0.0/OPR2.170623.027/4397545:user/release-keys
Google Pixel (7.1 & 7.1.1 & 7.1.2 & 8.0.0 & 8.1.0 & 9 & 10):Google:Pixel=google/sailfish/sailfish:7.1/NDE63V/3389651:user/release-keys;google/sailfish/sailfish:7.1.1/NOF27D/3757586:user/release-keys;google/sailfish/sailfish:7.1.2/NJH47F/4146041:user/release-keys;google/sailfish/sailfish:8.0.0/OPR3.170623.013/4397526:user/release-keys;google/sailfish/sailfish:8.1.0/OPM4.171019.021.P1/4820305:user/release-keys__2018-07-05;google/sailfish/sailfish:9/PQ3A.190801.002/5670241:user/release-keys__2019-08-01;google/sailfish/sailfish:10/QP1A.191005.007.A3/5972272:user/release-keys__2019-10-06
Google Pixel XL (7.1 & 7.1.1 & 7.1.2 & 8.0.0 & 8.1.0 & 9 & 10):Google:Pixel XL=google/marlin/marlin:7.1/NDE63V/3389651:user/release-keys;google/marlin/marlin:7.1.1/NOF27D/3757586:user/release-keys;google/marlin/marlin:7.1.2/NJH47F/4146041:user/release-keys;google/marlin/marlin:8.0.0/OPR3.170623.013/4397526:user/release-keys;google/marlin/marlin:8.1.0/OPM4.171019.021.P1/4820305:user/release-keys__2018-07-05;google/marlin/marlin:9/PQ3A.190801.002/5670241:user/release-keys__2019-08-01;google/marlin/marlin:10/QP1A.191005.007.A3/5972272:user/release-keys__2019-10-06
Google Pixel 2 (8.0.0 & 8.1.0 & 9 & 10 & 11):Google:Pixel 2=google/walleye/walleye:8.0.0/OPD1.170816.025/4424668:user/release-keys;google/walleye/walleye:8.1.0/OPM2.171026.006.G1/4820017:user/release-keys__2018-07-05;google/walleye/walleye:9/PQ3A.190801.002/5670241:user/release-keys__2019-08-01;google/walleye/walleye:10/QQ3A.200805.001/6578210:user/release-keys__2020-08-05;google/walleye/walleye:11/RP1A.201005.004.A1/6934943:user/release-keys__2020-10-05
Google Pixel 2 XL (8.0.0 & 8.1.0 & 9 & 10 & 11):Google:Pixel 2 XL=google/taimen/taimen:8.0.0/OPD1.170816.025/4424668:user/release-keys;google/taimen/taimen:8.1.0/OPM2.171026.006.H1/4833802:user/release-keys__2018-07-05;google/taimen/taimen:9/PQ3A.190801.002/5670241:user/release-keys__2019-08-01;google/taimen/taimen:10/QQ3A.200805.001/6578210:user/release-keys__2020-08-05;google/taimen/taimen:11/RP1A.201005.004.A1/6934943:user/release-keys__2020-10-05 
Google Pixel 3 (9 & 10 & 11):Google:Pixel 3=google/blueline/blueline:9/PQ3A.190801.002/5670241:user/release-keys__2019-08-01;google/blueline/blueline:10/QQ3A.200805.001/6578210:user/release-keys__2020-08-05;google/blueline/blueline:11/RQ1A.210105.003/7005429:user/release-keys__2021-01-05
Google Pixel 3 XL (9 & 10 & 11):Google:Pixel 3 XL=google/crosshatch/crosshatch:9/PQ3A.190801.002/5670241:user/release-keys__2019-08-01;google/crosshatch/crosshatch:10/QQ3A.200805.001/6578210:user/release-keys__2020-08-05;google/crosshatch/crosshatch:11/RQ1A.210105.003/7005429:user/release-keys__2021-01-05
Google Pixel 3a (9 & 10 & 11):Google:Pixel 3a=google/sargo/sargo:9/PQ3B.190801.002/5674421:user/release-keys__2019-08-01;google/sargo/sargo:10/QQ3A.200805.001/6578210:user/release-keys__2020-08-05;google/sargo/sargo:11/RQ1A.210105.002/6985033:user/release-keys__2021-01-05
Google Pixel 3a XL (9 & 10 & 11):Google:Pixel 3a XL=google/bonito/bonito:9/PQ3B.190801.002/5674421:user/release-keys__2019-08-01;google/bonito/bonito:10/QQ3A.200805.001/6578210:user/release-keys__2020-08-05;google/bonito/bonito:11/RQ1A.210105.002/6985033:user/release-keys__2021-01-05
Google Pixel 4 (10 & 11):Google:Pixel 4=google/flame/flame:10/QQ3A.200805.001/6578210:user/release-keys__2020-08-05;google/flame/flame:11/RQ1A.210105.003/7005429:user/release-keys__2021-01-05
Google Pixel 4 XL (10 & 11):Google:Pixel 4 XL=google/coral/coral:10/QQ3A.200805.001/6578210:user/release-keys__2020-08-05;google/coral/coral:11/RQ1A.210105.003/7005429:user/release-keys__2021-01-05
Google Pixel 4a (10 & 11):Google:Pixel 4a=google/sunfish/sunfish:10/QD4A.200805.003/6598198:user/release-keys__2020-08-05;google/sunfish/sunfish:11/RQ1A.210105.002/6985033:user/release-keys__2021-01-05
Google Pixel 4a 5G (11):Google:Pixel 4a (5G)=google/bramble/bramble:11/RQ1A.210105.003/7005429:user/release-keys__2021-01-05
Google Pixel 5 (11):Google:Pixel 5=google/redfin/redfin:11/RQ1A.210105.003/7005429:user/release-keys__2021-01-05
Google Pixel C (6.0.1 & 7.0 & 7.1.1 & 7.1.2 & 8.0.0 & 8.1.0):Google:Pixel C=google/ryu/dragon:6.0.1/MXC89L/3084571:user/release-keys;google/ryu/dragon:7.0/NRD91N/3318108:user/release-keys;google/ryu/dragon:7.1.1/N4F26T/3687331:user/release-keys;google/ryu/dragon:7.1.2/N2G48C/4104010:user/release-keys;google/ryu/dragon:8.0.0/OPR1.170623.032/4397478:user/release-keys;google/ryu/dragon:8.1.0/OPM8.190605.005/5749003:user/release-keys__2019-06-05
HTC 10 (6.0.1):HTC:HTC 10=htc/HTCOneM10vzw/htc_pmewl:6.0.1/MMB29M/774095.8:user/release-keys
HTC U11 (8.0.0):HTC:HTC U-3w=htc/ocndtwl_01405/htc_ocndtwl:8.0.0/OPR6.170623.013/1017190.2:user/release-keys
HTC U12 Plus (8.0.0 & 9):HTC:HTC U12+=htc/imeuhl_00617/htc_imeuhl:8.0.0/OPR1.170623.032/1041457.3:user/release-keys__2018-06-01;htc/imeuhl_00617/htc_imeuhl:9/PQ2A.190205.003/1087121.1:user/release-keys__2019-07-01
HTC Exodus 1 (9):HTC:EXODUS 1=htc/exouhl_00617/htc_exouhl:9/PQ2A.190205.003/1109191.2:user/release-keys__2020-03-01
Huawei Honor 6X BLN-AL10 (8.0.0):Huawei:BLN-AL10=HONOR/BLN-AL10/HWBLN-H:8.0.0/HONORBLN-AL10/528(C00):user/release-keys
Huawei Honor 6X BLN-L22 (8.0.0):Huawei:BLN-L22=HONOR/BLN-L22/HWBLN-H:8.0.0/HONORBLN-L22/520(C675):user/release-keys__2018-11-05
Huawei Honor 8X JSN-L21 (8.1.0):Huawei:JSN-L21=HONOR/JSN-L21RU/HWJSN-H:8.1.0/HONORJSN-L21/101(C10):user/release-keys__2018-10-01
Huawei Honor 9 STF-L09 (8.0.0 & 9):Huawei:STF-L09=HONOR/STF-L09/HWSTF:8.0.0/HUAWEISTF-L09/364(C432):user/release-keys;HONOR/STF-L09/HWSTF:9/HUAWEISTF-L09/157C432R1:user/release-keys__2019-02-01
Huawei Mate 9 MHA-L29 (9):Huawei:MHA-L29=HUAWEI/MHA-L29/HWMHA:9/HUAWEIMHA-L29/9.1.0.275C432:user/release-keys__2020-05-01
Huawei Mate 10 ALP-L29 (8.0.0):Huawei:ALP-L29=HUAWEI/ALP-L29/HWALP:8.0.0/HUAWEIALP-L29S/143(C636):user/release-keys__2018-10-01
Huawei Mate 10 Pro BLA-L29 (8.0.0):Huawei:BLA-L29=HUAWEI/BLA-L29/HWBLA:8.0.0/HUAWEIBLA-L29S/137(C432):user/release-keys
Huawei Mate 20 Lite SNE-LX1 (9):Huawei:SNE-LX1=HUAWEI/SNE-LX1EEA/HWSNE:9/HUAWEISNE-L01/245EEAC782:user/release-keys__2019-09-01
Huawei Mate 20 Pro LYA-L29 (9):Huawei:LYA-L29=HUAWEI/LYA-L29/HWLYA:9/HUAWEILYA-L29/358C432:user/release-keys__2019-11-01
Huawei P8 Lite PRA-LX1 (8.0.0):Huawei:PRA-LX1=HUAWEI/PRA-LX1/HWPRA-H:8.0.0/HUAWEIPRA-LX1/401(C432):user/release-keys__2019-01-01
Huawei P9 EVA-AL10 (8.0.0):Huawei:EVA-AL10=HUAWEI/EVA-AL10/HWEVA:8.0.0/HUAWEIEVA-AL10/550(C00):user/release-keys__2020-07-01
Huawei P9 EVA-L09 (7.0):Huawei:EVA-L09=HUAWEI/EVA-L09/HWEVA:7.0/HUAWEIEVA-L09/C432B502:user/release-keys
Huawei P9 Lite VNS-L31 (7.0):Huawei:HUAWEI VNS-L31=HUAWEI/VNS-L31/HWVNS-H:7.0/HUAWEIVNS-L31/C432B414:user/release-keys__2018-06-01
Huawei P9 Plus VIE-AL10 (8.0.0):HUAWEI:VIE-AL10=HUAWEI/VIE-AL10/HWVIE:8.0.0/HUAWEIVIE-AL10/550(C00):user/release-keys__2020-07-01
Huawei P9 Plus VIE-L09 (7.0):Huawei:VIE-L09=HUAWEI/VIE-L09/HWVIE:7.0/HUAWEIVIE-L09/C432B387:user/release-keys__2018-07-01
Huawei P20 EML-L09 (9 & 10):Huawei:EML-L09=HUAWEI/EML-L09/HWEML:9/HUAWEIEML-L09/9.1.0.381C109:user/release-keys__2020-01-01;HUAWEI/EML-L09/HWEML:10/HUAWEIEML-L09/10.0.0.161C109:user/release-keys__2020-04-01
Huawei P20 Dual SIM EML-L29 (9):Huawei:EML-L29=HUAWEI/EML-L29/HWEML:9/HUAWEIEML-L29/197C432R1:user/release-keys__2019-01-01
Huawei P20 Lite ANE-LX1 (8.0.0 & 9):Huawei:ANE-LX1=HUAWEI/ANE-LX1/HWANE:8.0.0/HUAWEIANE-LX1/180(C432):user/release-keys__2019-04-05;HUAWEI/ANE-LX1/HWANE:9/HUAWEIANE-L21/132C432R1:user/release-keys__2019-05-05
Huawei P20 Pro CLT-L29 (8.1.0 & 9):Huawei:CLT-L29=HUAWEI/CLT-L29/HWCLT:8.1.0/HUAWEICLT-L29/128(C432):user/release-keys;HUAWEI/CLT-L09/HWCLT:9/HUAWEICLT-L09/203C432R1:user/release-keys__2019-02-01
Infinix Note 5 (9 & 10):Infinix:Infinix X604=Infinix/H633/Infinix-X604_sprout:9/PPR1.180610.011/H-190617V240:user/release-keys__2019-06-05;Infinix/H633/Infinix-X604_sprout:10/QP1A.190711.020/H-191227V306:user/release-keys__2020-01-05
Lenovo K6 Note (7.0):Lenovo:Lenovo K53a48=Lenovo/karatep/K53a48:7.0/NRD90N/K53_S228_171114_ROW:user/release-keys
Lenovo Tab 4 8 Plus TB-8704F (8.1.0):Lenovo:Lenovo TB-8704F=Lenovo/TB-8704F/TB-8704F:8.1.0/OPM1.171019.019/8704F_S001018_191009_ROW:user/release-keys__2019-08-05
Lenovo Tab 4 10 Plus TB-X704F (7.1.1):Lenovo:Lenovo TB-X704F=Lenovo/LenovoTB-X704F/X704F:7.1.1/NMF26F/TB-X704F_S000056_181015_ROW:user/release-keys__2018-10-01
Lenovo Tab 4 10 Plus TB-X704L (7.1.1):Lenovo:Lenovo TB-X704L=Lenovo/LenovoTB-X704L/X704L:7.1.1/NMF26F/TB-X704L_S000056_181015_ROW:user/release-keys__2018-10-01
LeEco Le Pro3 (6.0.1):Leeco:LEX725=LeEco/ZL1_NA/le_zl1:6.0.1/WEXNAOP5802101261S/letv01261206:user/release-keys
LG G2 VS980 (5.0.2):LGE:VS980 4G=lge/g2_vzw/g2:5.0.2/LRX22G/15046001715f9:user/release-keys
LG G4 H812 (6.0):LGE:LG-H812=lge/p1_rgs_ca/p1:6.0/MRA58K/1601215569825:user/release-keys
LG G5 H830 (8.0.0):LGE:LG-H830=lge/h1_tmo_us/h1:8.0.0/OPR1.170623.032/182251913485f:user/release-keys__2018-08-01
LG G5 H850 (8.0.0):LGE:LG-H850=lge/h1_global_com/h1:8.0.0/OPR1.170623.032/190380127377a:user/release-keys__2018-12-01
LG G5 RS988 (7.0):LGE:RS988=lge/h1_lra_us/h1:7.0/NRD90U/1707917149a1b:user/release-keys
LG G6 H870 (7.0 & 8.0.0):LGE:LG-H870=lge/lucye_global_com/lucye:7.0/NRD90U/171732341982c:user/release-keys;lge/lucye_global_com/lucye:8.0.0/OPR1.170623.032/183301757502c:user/release-keys__2018-11-01
LG G7 ThinQ LM-G710 (9):LGE:LM-G710=lge/judyln_lao_com/judyln:9/PKQ1.181105.001/200350248e04d.FGN:user/release-keys__2020-01-01
LG K20 Plus LG-TP260 (7.0):LGE:LG-TP260=lge/lv517_tmo_us/lv517:7.0/NRD90U/1809315248edb:user/release-keys
LG V20 H910 (8.0.0):LGE:LG-H910=lge/elsa_att_us/elsa:8.0.0/OPR1.170623.032/181871124f959:user/release-keys__2018-06-01
LG V20 H918 (8.0.0):LGE:LG-H918=lge/elsa_tmo_us/elsa:8.0.0/OPR1.170623.032/1831917495b33:user/release-keys__2018-11-01
LG V20 H990DS (7.0):LGE:LG-H990=lge/elsa_global_com/elsa:7.0/NRD90M/1801800193678:user/release-keys
LG V20 LS997 (8.0.0):LGE:LG-LS997=lge/elsa_spr_us/elsa:8.0.0/OPR1.170623.032/1819814314eb7:user/release-keys__2018-07-01
LG V20 US996 (8.0.0):LGE:LG-US996=lge/elsa_nao_us/elsa:8.0.0/OPR1.170623.032/183241436cd40:user/release-keys__2018-11-01
LG V20 VS995 (8.0.0):LGE:VS995=lge/elsa_vzw/elsa:8.0.0/OPR1.170623.032/183141449275f:user/release-keys__2018-10-01
LG V30 H930 (8.0.0):LGE:LG-H930=lge/joan_global_com/joan:8.0.0/OPR1.170623.026/181381736b4e9:user/release-keys__2018-11-05
LG V30 LS998 (8.0.0):LGE:LG-LS998=lge/joan_spr_us/joan:8.0.0/OPR1.170623.026/190181203d401:user/release-keys__2019-01-01
Mecool KM8 (8.0.0 & 9):Mecool:KM8=MECOOL/KM8/KM8:8.0.0/OPR6.170623.013/V0412.201806271453:user/release-keys__2018-05-05;MECOOL/KM8/KM8:9/PI/20190315:user/release-keys__2019-02-05
Meizu 16th (8.1.0):Meizu:M1882=Meizu/meizu_16th/16th:8.1.0/OPM1.171019.026/1554756792:user/release-keys__2019-03-01
Meizu 17 (10):meizu:meizu 17=meizu/meizu_17_N_CN/meizu17:10/QKQ1.200223.002/1599445800:user/release-keys__2020-07-01
Meizu X8 (8.1.0):Meizu:meizu X8=Meizu/meizu_X8/X8:8.1.0/OPM1.171019.026/1556996821:user/release-keys__2019-04-01
Motorola Moto C Plus (7.0):Motorola:Moto C Plus=motorola/panell_21_d/panell_d:7.0/NRD90M.03.040/040:user/release-keys
Motorola Moto E4 (7.1.1):Motorola:Moto E (4)=motorola/sperry_sprint/sperry:7.1.1/NCQ26.69-64/68:user/release-keys
Motorola Moto E4 Plus (7.1.1):Motorola:Moto E (4) Plus=motorola/nicklaus_fn/nicklaus_fn:7.1.1/NMA26.42-156/183:user/release-keys
Motorola Moto E5 Play (8.0.0):Motorola:moto e5 play=motorola/james_sprint/james:8.0.0/OCPS27.91-140-1/1:user/release-keys__2018-10-01
Motorola Moto E5 Plus (8.0.0):Motorola:moto e5 plus=motorola/hannah_sprint/hannah:8.0.0/OCPS27.91-32-4/4:user/release-keys__2018-10-01
Motorola Moto G4 (7.0 & 8.1.0):Motorola:Moto G (4)=motorola/athene/athene:7.0/NPJS25.93-14-13/3:user/release-keys;motorola/athene/athene:8.1.0/OPJ28.111-22/532da:user/release-keys__2018-12-01
Motorola Moto G5 (7.0):Motorola:Moto G (5)=motorola/cedric/cedric:7.0/NPPS25.137-15-11/11:user/release-keys
Motorola Moto G5 Plus (7.0):Motorola:Moto G (5) Plus=motorola/potter_n/potter_n:7.0/NPNS25.137-33-11/11:user/release-keys
Motorola Moto G5S (7.1.1 & 8.1.0):Motorola:Moto G (5S)=motorola/montana/montana:7.1.1/NPPS26.102-49-8/6:user/release-keys;motorola/montana/montana:8.1.0/OPPS28.65-37-7-11/7f8a6:user/release-keys__2019-08-01
Motorola Moto G5S Plus (8.1.0):Motorola:Moto G (5S) Plus=motorola/sanders_n/sanders_n:8.1.0/OPS28.65-36-14/63857:user/release-keys__2019-08-01
Motorola Moto G6 (9):Motorola:moto g(6)=motorola/ali/ali:9/PPS29.55-34/0c5d:user/release-keys__2019-02-01
Motorola Moto G6 Play (8.0.0 & 9):Motorola:moto g(6) play=motorola/jeter_sprint/jeter:8.0.0/OCP27.91-23/23:user/release-keys;motorola/aljeter/aljeter:9/PPP29.55-25/08c6:user/release-keys__2019-01-01
Motorola Moto G6 Plus (9):Motorola:moto g(6) plus=motorola/evert_amx_n/evert_n:9/PPWS29.116-16-6/5cbfe:user/release-keys__2019-05-01
Motorola Moto G7 XT1962-1 (9 & 10):Motorola:moto g(7)=motorola/river/river:9/PPOS29.114-134-10/ca814:user/release-keys__2020-02-01;motorola/river/river:10/QPU30.52-16-2/be43c:user/release-keys__2020-04-01
Motorola Moto G7 XT1962-5 (10):Motorola:moto g(7)=motorola/river_retru_n/river_n:10/QPUS30.52-16-2-5/58144:user/release-keys__2020-08-01
Motorola Moto G7 Power (9 & 10):Motorola:moto g(7) power=motorola/ocean/ocean:9/PPOS29.114-134-13/6abfe:user/release-keys__2020-04-01;motorola/ocean/ocean:10/QPO30.52-29/c0490:user/release-keys__2020-04-01
Motorola Moto G7 Play (9 & 10):Motorola:moto g(7) play=motorola/channel/channel:9/PPY29.105-160-4/56a11:user/release-keys__2019-12-01;motorola/channel/channel:10/QPY30.52-22/355d1:user/release-keys__2020-04-01
Motorola Moto G7 Play T-Mobile (10):Motorola:moto (g7) play=motorola/channel_t/channel:10/QPYS30.85-18-3/60cdb:user/release-keys__2020-08-01
Motorola Moto X Play (7.1.1):motorola:XT1562=motorola/lux_retasia_ds/lux_uds:7.1.1/NPD26.48-24-1/1:user/release-keys
Motorola Moto X4 (8.0.0 & 9):Motorola:moto x4=motorola/payton/payton:8.0.0/OPWS27.57-25-6-10/12:user/release-keys;motorola/payton_fi/payton_sprout:9/PPWS29.69-39-6-6/8c843:user/release-keys__2020-03-01
Motorola Moto Z2 Play (8.0.0):Motorola:Moto Z2 Play=motorola/albus/albus:8.0.0/OPS27.76-12-25/26:user/release-keys
Nextbook Ares 8A (6.0.1):Nextbook:NX16A8116K=NextBook/NX16A8116K/NX16A8116K:6.0.1/MMB29M/V4.0.3:user/release-keys
Nokia 6 TA-1021 (9):Nokia:TA-1021=Nokia/TA-1021_00WW/PLE:9/PKQ1.181105.001/00WW_6_19C:user/release-keys__2020-01-01
Nokia 6 TA-1025 (9):Nokia:TA-1025=Nokia/TA-1025_00WW/PLE:9/PKQ1.181105.001/00WW_6_19C:user/release-keys__2020-01-01
Nokia 6 TA-1033 (9):Nokia:TA-1033=Nokia/TA-1033_00WW/PLE:9/PKQ1.181105.001/00WW_6_19C:user/release-keys__2020-01-01
Nokia 6 TA-1039 (9):Nokia:TA-1039=Nokia/TA-1039_00WW/PLE:9/PKQ1.181105.001/00WW_6_19C:user/release-keys__2020-01-01
Nokia 6.1 (10):Nokia:Nokia 6.1=Nokia/Plate2_00WW/PL2_sprout:10/QKQ1.190828.002/00WW_4_15E:user/release-keys__2020-06-01
Nokia 6.1 Plus (9 & 10):Nokia:Nokia 6.1 Plus=Nokia/Dragon_00WW/DRG_sprout:9/PPR1.180610.011/00WW_3_54J:user/release-keys__2019-08-01;Nokia/Dragon_00WW/DRG_sprout:10/QKQ1.190828.002/00WW_4_15C:user/release-keys__2020-05-01
Nokia 6.2 (9):Nokia:Nokia 6.2=Nokia/Starlord_00WW/SLD_sprout:9/PKQ1.190118.001/00WW_1_170:user/release-keys__2020-01-05
Nokia 7 Plus (9 & 10):Nokia:Nokia 7 plus=Nokia/Onyx_00WW/B2N_sprout:9/PPR1.180610.011/00WW_3_53B:user/release-keys__2019-05-01;Nokia/Onyx_00WW/B2N_sprout:10/QKQ1.190828.002/00WW_4_15D:user/release-keys__2020-05-01
Nokia 7.1 TA-1095 (10):Nokia:Nokia 7.1=Nokia/Crystal_00WW/CTL_sprout:10/QKQ1.190828.002/00WW_4_08B:user/release-keys__2019-11-01
Nvidia Shield K1 (7.0):NVIDIA:SHIELD Tablet=nvidia/sb_na_wf/shieldtablet:7.0/NRD90M/1928188_1065.2559:user/release-keys
Nvidia Shield Tablet (7.0):NVIDIA:SHIELD Tablet=nvidia/wx_na_wf/shieldtablet:7.0/NRD90M/1928188_904.2811:user/release-keys
Nvidia Shield TV 2015 (8.0.0 & 9):NVIDIA:SHIELD Android TV=NVIDIA/foster_e/foster:8.0.0/OPR6.170623.010/3507953_1441.7411:user/release-keys__2018-12-05;NVIDIA/foster_e/foster:9/PPR1.180610.011/4079208_2235.1395:user/release-keys__2020-07-05
Nvidia Shield TV 2015 Pro (8.0.0 & 9):NVIDIA:SHIELD Android TV=NVIDIA/foster_e_hdd/foster:8.0.0/OPR6.170623.010/3507953_1441.7411:user/release-keys__2018-12-05;NVIDIA/foster_e_hdd/foster:9/PPR1.180610.011/4079208_2235.1395:user/release-keys__2020-07-05
Nvidia Shield TV 2017 (8.0.0 & 9):NVIDIA:SHIELD Android TV=NVIDIA/darcy/darcy:8.0.0/OPR6.170623.010/3507953_1441.7411:user/release-keys__2018-12-05;NVIDIA/darcy/darcy:9/PPR1.180610.011/4079208_2235.1395:user/release-keys__2020-07-05
Nvidia Shield TV 2019 (9):NVIDIA:SHIELD Android TV=NVIDIA/sif/sif:9/PPR1.180610.011/4079180_2235.1395:user/release-keys__2020-07-05
Nvidia Shield TV 2019 Pro (9):NVIDIA:SHIELD Android TV=NVIDIA/mdarcy/mdarcy:9/PPR1.180610.011/4079208_2235.1395:user/release-keys__2020-07-05
OnePlus One (6.0.1):OnePlus:A0001=oneplus/bacon/A0001:6.0.1/MMB29X/ZNH0EAS2JK:user/release-keys
OnePlus 2 (6.0.1):OnePlus:ONE A2003=OnePlus/OnePlus2/OnePlus2:6.0.1/MMB29M/1447858500:user/release-keys
OnePlus X (6.0.1):OnePlus:ONE E1003=OnePlus/OnePlus/OnePlus:6.0.1/MMB29M/10281213:user/release-keys
OnePlus 3 (8.0.0 & 9):OnePlus:ONEPLUS A3000=OnePlus/OnePlus3/OnePlus3:8.0.0/OPR1.170623.032/1809142047:user/release-keys__2018-09-01;OnePlus/OnePlus3/OnePlus3:9/PKQ1.181203.001/1911042107:user/release-keys__2019-10-01
OnePlus 3T (8.0.0 & 9):OnePlus:ONEPLUS A3003=OnePlus/OnePlus3/OnePlus3T:8.0.0/OPR1.170623.032/1812060016:user/release-keys__2018-11-01;OnePlus/OnePlus3/OnePlus3T:9/PKQ1.181203.001/1911042108:user/release-keys__2019-10-01
OnePlus 5 (8.1.0 & 9 & 10):OnePlus:ONEPLUS A5000=OnePlus/OnePlus5/OnePlus5:8.1.0/OPM1.171019.011/1809241512:user/release-keys__2018-09-01;OnePlus/OnePlus5/OnePlus5:9/PKQ1.180716.001/2002242003:user/release-keys__2020-02-01;OnePlus/OnePlus5/OnePlus5:10/QKQ1.191014.012/2010292059:user/release-keys__2020-09-01
OnePlus 5T (7.1.1 & 8.0.0 & 8.1.0 & 9 & 10):OnePlus:ONEPLUS A5010=OnePlus/OnePlus5T/OnePlus5T:7.1.1/NMF26X/12152312:user/release-keys;OnePlus/OnePlus5T/OnePlus5T:8.0.0/OPR1.170623.032/02040656:user/release-keys;OnePlus/OnePlus5T/OnePlus5T:8.1.0/OPM1.171019.011/1809241512:user/release-keys__2018-09-01;OnePlus/OnePlus5T/OnePlus5T:9/PKQ1.180716.001/2002242012:user/release-keys__2020-02-01;OnePlus/OnePlus5T/OnePlus5T:10/QKQ1.191014.012/2010292059:user/release-keys__2020-09-01
OnePlus 6 (8.1.0 & 9 & 10):OnePlus:ONEPLUS A6003=OnePlus/OnePlus6/OnePlus6:8.1.0/OPM1.171019.011/06140300:user/release-keys;OnePlus/OnePlus6/OnePlus6:9/PKQ1.180716.001/1908012000:user/release-keys__2019-08-01;OnePlus/OnePlus6/OnePlus6:10/QKQ1.190716.003/2011161919:user/release-keys__2020-11-01
OnePlus 6T (9 & 10):OnePlus:ONEPLUS A6013=OnePlus/OnePlus6T/OnePlus6T:9/PKQ1.180716.001/1909112330:user/release-keys__2019-08-01;OnePlus/OnePlus6T/OnePlus6T:10/QKQ1.190716.003/2011161919:user/release-keys__2020-11-01
OnePlus 6T T-Mobile (9):OnePlus:ONEPLUS A6013=OnePlus/OnePlus6TSingle/OnePlus6TSingle:9/PKQ1.180716.001/1810291147:user/release-keys__2018-11-01
OnePlus 7 China GM1900 (10):OnePlus:GM1900=OnePlus/OnePlus7_CH/OnePlus7:10/QKQ1.190716.003/2005132200:user/release-keys__2020-05-01
OnePlus 7 GM1901 (9 & 10):OnePlus:GM1901=OnePlus/OnePlus7/OnePlus7:9/PKQ1.190110.001/1907280700:user/release-keys__2019-08-01;OnePlus/OnePlus7/OnePlus7:10/QKQ1.190716.003/2011052232:user/release-keys__2020-11-01
OnePlus 7 Europe GM1903 (9 & 10):OnePlus:GM1903=OnePlus/OnePlus7_EEA/OnePlus7:9/PKQ1.190110.001/1907280700:user/release-keys__2019-08-01;OnePlus/OnePlus7_EEA/OnePlus7:10/QKQ1.190716.003/2011052232:user/release-keys__2020-11-01
OnePlus 7 GM1905 (9 & 10):OnePlus:GM1905=OnePlus/OnePlus7/OnePlus7:9/PKQ1.190110.001/1907280700:user/release-keys__2019-08-01;OnePlus/OnePlus7/OnePlus7:10/QKQ1.190716.003/2011052232:user/release-keys__2020-11-01
OnePlus 7 Pro China GM1910 (10):OnePlus:GM1910=OnePlus/OnePlus7Pro_CH/OnePlus7Pro:10/QKQ1.190716.003/2005132200:user/release-keys__2020-05-01
OnePlus 7 Pro GM1911 (9 & 10):OnePlus:GM1911=OnePlus/OnePlus7Pro/OnePlus7Pro:9/PKQ1.190110.001/1907281556:user/release-keys__2019-08-01;OnePlus/OnePlus7Pro/OnePlus7Pro:10/QKQ1.190716.003/2011052232:user/release-keys__2020-11-01
OnePlus 7 Pro Europe GM1913 (9 & 10):OnePlus:GM1913=OnePlus/OnePlus7Pro_EEA/OnePlus7Pro:9/PKQ1.190110.001/1907281556:user/release-keys__2019-08-01;OnePlus/OnePlus7Pro_EEA/OnePlus7Pro:10/QKQ1.190716.003/2011052232:user/release-keys__2020-11-01
OnePlus 7 Pro T-Mobile GM1915 (9 & 10):OnePlus:GM1915=OnePlus/OnePlus7ProTMO/OnePlus7ProTMO:9/PKQ1.190110.001/1905021004:user/release-keys__2019-03-01;OnePlus/OnePlus7ProTMO/OnePlus7ProTMO:10/QKQ1.190716.003/2012102113:user/release-keys__2020-12-01
OnePlus 7 Pro GM1917 (9 & 10):OnePlus:GM1917=OnePlus/OnePlus7Pro/OnePlus7Pro:9/PKQ1.190110.001/1907281556:user/release-keys__2019-08-01;OnePlus/OnePlus7Pro/OnePlus7Pro:10/QKQ1.190716.003/2011052232:user/release-keys__2020-11-01
OnePlus 7 Pro NR Europe GM1920 (9 & 10):OnePlus:GM1920=OnePlus/OnePlus7ProNR_EEA/OnePlus7ProNR:9/PKQ1.190223.001/1912171007:user/release-keys__2019-12-01;OnePlus/OnePlus7ProNR_EEA/OnePlus7ProNR:10/QKQ1.190716.003/2011182309:user/release-keys__2020-11-01
OnePlus 7 Pro NR Sprint GM1925 (9 & 10):OnePlus:GM1925=OnePlus/OP7ProNRSpr/OP7ProNRSpr:9/PKQ1.190223.001/1908201041:user/release-keys__2019-08-01;OnePlus/OP7ProNRSpr/OP7ProNRSpr:10/QKQ1.190716.003/2006051914:user/release-keys__2020-06-01
OnePlus 7T China HD1900 (10):OnePlus:HD1900=OnePlus/OnePlus7T_CH/OnePlus7T:10/QKQ1.190716.003/2005131900:user/release-keys__2020-05-01
OnePlus 7T HD1901 (10):OnePlus:HD1901=OnePlus/OnePlus7T/OnePlus7T:10/QKQ1.190716.003/2011052234:user/release-keys__2020-11-01
OnePlus 7T Europe HD1903 (10):OnePlus:HD1903=OnePlus/OnePlus7T_EEA/OnePlus7T:10/QKQ1.190716.003/2011052234:user/release-keys__2020-11-01
OnePlus 7T HD1905 (10):OnePlus:HD1905=OnePlus/OnePlus7T/OnePlus7T:10/QKQ1.190716.003/2011052234:user/release-keys__2020-11-01
OnePlus 7T Pro China HD1910 (10):OnePlus:HD1910=OnePlus/OnePlus7TPro_CH/OnePlus7TPro:10/QKQ1.190716.003/2005131900:user/release-keys__2020-05-01
OnePlus 7T Pro HD1911 (10):OnePlus:HD1911=OnePlus/OnePlus7TPro/OnePlus7TPro:10/QKQ1.190716.003/2011052221:user/release-keys__2020-11-01
OnePlus 7T Pro Europe HD1913 (10):OnePlus:HD1913=OnePlus/OnePlus7TPro_EEA/OnePlus7TPro:10/QKQ1.190716.003/2011052221:user/release-keys__2020-11-01
OnePlus 7T Pro HD1917 (10):OnePlus:HD1917=OnePlus/OnePlus7TPro/OnePlus7TPro:10/QKQ1.190716.003/2011052221:user/release-keys__2020-11-01
OnePlus 7T Pro NR HD1925 (10):OnePlus:HD1925=OnePlus/OnePlus7TProNR/OnePlus7TProNR:10/QKQ1.190716.003/2011302116:user/release-keys__2020-11-01
OnePlus 8 China IN2010 (10):OnePlus:IN2010=OnePlus/OnePlus8_CH/OnePlus8:10/QKQ1.191222.002/2006300106:user/release-keys__2020-06-01
OnePlus 8 India IN2011 (10 & 11):OnePlus:IN2011=OnePlus/OnePlus8_IND/OnePlus8:10/QKQ1.191222.002/2008080019:user/release-keys__2020-08-01;OnePlus/OnePlus8_IND/OnePlus8:11/RP1A.201005.001/2012102310:user/release-keys__2020-11-01
OnePlus 8 Europe IN2013 (10 & 11):OnePlus:IN2013=OnePlus/OnePlus8_EEA/OnePlus8:10/QKQ1.191222.002/2008150504:user/release-keys__2020-08-01;OnePlus/OnePlus8_EEA/OnePlus8:11/RP1A.201005.001/2011190109:user/release-keys__2020-11-01
OnePlus 8 Global IN2015 (10 & 11):OnePlus:IN2015=OnePlus/OnePlus8/OnePlus8:10/QKQ1.191222.002/2008080019:user/release-keys__2020-08-01;OnePlus/OnePlus8/OnePlus8:11/RP1A.201005.001/2011190255:user/release-keys__2020-11-01
OnePlus 8 Visible IN2015 (10):OnePlus:IN2015=OnePlus/OnePlus8Visible/OnePlus8Visible:10/QKQ1.191222.002/2010121010:user/release-keys__2020-09-01
OnePlus 8 T-Mobile IN2017 (10):OnePlus:IN2017=OnePlus/OnePlus8TMO/OnePlus8TMO:10/QKQ1.191222.002/2006102149:user/release-keys__2020-06-01
OnePlus 8 Verizon IN2019 (10):OnePlus:IN2019=OnePlus/OnePlus8VZW/OnePlus8VZW:10/QKQ1.191222.002/2011031214:user/release-keys__2020-10-01
OnePlus 8 Pro China IN2020 (10):OnePlus:IN2020=OnePlus/OnePlus8Pro_CH/OnePlus8Pro:10/QKQ1.191222.002/2007021926:user/release-keys__2020-06-01
OnePlus 8 Pro India IN2021 (10 & 11):OnePlus:IN2021=OnePlus/OnePlus8Pro_IND/OnePlus8Pro:10/QKQ1.191222.002/2008080018:user/release-keys__2020-08-01;OnePlus/OnePlus8Pro_IND/OnePlus8Pro:11/RP1A.201005.001/2012102310:user/release-keys__2020-11-01
OnePlus 8 Pro Europe IN2023 (10 & 11):OnePlus:IN2023=OnePlus/OnePlus8Pro_EEA/OnePlus8Pro:10/QKQ1.191222.002/2008150503:user/release-keys__2020-08-01;OnePlus/OnePlus8Pro_EEA/OnePlus8Pro:11/RP1A.201005.001/2011190105:user/release-keys__2020-11-01
OnePlus 8 Pro Global IN2025 (10 & 11):OnePlus:IN2025=OnePlus/OnePlus8Pro/OnePlus8Pro:10/QKQ1.191222.002/2008080018:user/release-keys__2020-08-01;OnePlus/OnePlus8Pro/OnePlus8Pro:11/RP1A.201005.001/2011190108:user/release-keys__2020-11-01
OnePlus 8T China KB2000 (11):OnePlus:KB2000=OnePlus/OnePlus8T_CH/OnePlus8T:11/RP1A.201005.001/2011100046:user/release-keys__2020-10-01
OnePlus 8T India KB2001 (11):OnePlus:KB2001=OnePlus/OnePlus8T_IND/OnePlus8T:11/RP1A.201005.001/2101010457:user/release-keys__2020-11-01
OnePlus 8T Europe KB2003 (11):OnePlus:KB2003=OnePlus/OnePlus8T_EEA/OnePlus8T:11/RP1A.201005.001/2101010500:user/release-keys__2020-11-01
OnePlus 8T Global KB2005 (11):OnePlus:KB2005=OnePlus/OnePlus8T/OnePlus8T:11/RP1A.201005.001/2012162343:user/release-keys__2020-11-01
OnePlus 8T T-Mobile KB2007 (11):OnePlus:KB2007=OnePlus/OnePlus8TTMO/OnePlus8TTMO:11/RP1A.201005.001/2009240808:user/release-keys__2020-09-01
OnePlus N10 5G Global BE2029 (10):OnePlus:BE2029=OnePlus/OnePlusN10/OnePlusN10:10/QKQ1.200830.002/2012121358:user/release-keys__2020-12-05
OnePlus N10 5G Europe BE2029 (10):OnePlus:BE2029=OnePlus/OnePlusN10_EEA/OnePlusN10:10/QKQ1.200830.002/2012121358:user/release-keys__2020-12-05
OnePlus N100 Global BE2011 (10):OnePlus:BE2011=OnePlus/OnePlusN100/OnePlusN100:10/QKQ1.200719.002/2012151141:user/release-keys__2020-12-05
OnePlus N100 Europe BE2013 (10):OnePlus:BE2013=OnePlus/OnePlusN100_EEA/OnePlusN100:10/QKQ1.200719.002/2012232008:user/release-keys__2020-12-05
OnePlus Nord India AC2001 (10 & 11):OnePlus:AC2001=OnePlus/Nord_IND/Nord:10/QKQ1.200412.002/2012212158:user/release-keys__2020-12-01;OnePlus/Nord_IND/Nord:11/RP1A.201005.001/2012282045:user/release-keys__2020-12-01
OnePlus Nord Europe AC2003 (10 & 11):OnePlus:AC2003=OnePlus/Nord_EEA/Nord:10/QKQ1.200412.002/2012212158:user/release-keys__2020-12-01;OnePlus/Nord_EEA/Nord:11/RP1A.201005.001/2012282038:user/release-keys__2020-12-01
OnePlus Nord Global AC2003 (10 & 11):OnePlus:AC2003=OnePlus/Nord/Nord:10/QKQ1.200412.002/2012212217:user/release-keys__2020-12-01;OnePlus/Nord/Nord:11/RP1A.201005.001/2012282112:user/release-keys__2020-12-01
OPPO Find X2 Neo Europe CPH2009 (10):OPPO:CPH2009=OPPO/CPH2009EEA/OP4C2DL1:10/QKQ1.200216.002/1596223341:user/release-keys__2020-08-05
OPPO Neo 7 A33w (5.1):Oppo:A33w=OPPO/A33w/A33w:5.1/LMY47I/1487829433:user/release-keys
OPPO Neo 7 A1603 (5.1):Oppo:A1603=OPPO/A1603/A1603:5.1/LMY47I/1489407760:user/release-keys
POCO F2 Pro Europe (10):POCO:POCO F2 Pro=POCO/lmi_eea/lmi:10/QKQ1.191117.002/V12.0.3.0.QJKEUXM:user/release-keys__2020-09-01
POCO F2 Pro Global (10):Xiaomi:POCO F2 Pro=POCO/lmi_global/lmi:10/QKQ1.191117.002/V12.0.4.0.QJKMIXM:user/release-keys__2020-09-01
POCO X2 (10):POCO:POCO X2=POCO/phoenixin/phoenixin:10/QKQ1.190825.002/V12.0.2.0.QGHINXM:user/release-keys__2020-10-01
POCO X3 NFC Europe (10):POCO:M2007J20CG=POCO/surya_eea/surya:10/QKQ1.200512.002/V12.0.7.0.QJGEUXM:user/release-keys__2020-11-01
POCO X3 NFC Global (10):POCO:M2007J20CG=POCO/surya_global/surya:10/QKQ1.200512.002/V12.0.7.0.QJGMIXM:user/release-keys__2020-11-01
Razer Phone (7.1.1 & 8.1.0 & 9):Razer:Phone=razer/cheryl/cheryl:7.1.1/NMF26X-RZR-180118/3005:user/release-keys__2018-01-05;razer/cheryl/cheryl:8.1.0/OPM1.171019.011-RZR-180803/6033:user/release-keys__2018-07-05;razer/cheryl/cheryl:9/P-MR2-RC001-RZR-N/7083:user/release-keys__2019-11-05
Razer Phone 2 (8.1.0 & 9):Razer:Phone 2=razer/cheryl2/aura:8.1.0/O-MR2-RC009-RZR-181124/2009:user/release-keys__2018-10-05;razer/cheryl2/aura:9/P-SMR3-RC002-RZR-200226/3141:user/release-keys__2020-03-05
Realme X2 Pro (10):Realme:RMX1931=realme/RMX1931EEA/RMX1931L1:10/QKQ1.191021.002/1590460856:user/release-keys__2020-06-05
Redmi K30 Pro China (10):Redmi:Redmi K30 Pro=Redmi/lmi/lmi:10/QKQ1.191117.002/V12.0.1.0.QJKCNXM:user/release-keys__2020-06-01
Redmi K30 Pro Zoom Edition China (10):Redmi:Redmi K30 Pro Zoom Edition=Redmi/lmipro/lmipro:10/QKQ1.191117.002/V11.0.16.0.QJKCNXM:user/release-keys__2020-04-01
Redmi K30 Ultra China (10):Redmi:M2006J10C=Redmi/cezanne/cezanne:10/QP1A.190711.020/V12.0.12.0.QJNCNXM:user/release-keys__2020-09-01
Redmi K30S Ultra China (10):Redmi:M2007J3SC=Redmi/apollo/apollo:10/QKQ1.200419.002/V12.0.3.0.QJDCNXM:user/release-keys__2020-09-01
Redmi Note 8 Pro Europe (10):Redmi:Redmi Note 8 Pro=Redmi/begonia_eea/begonia:10/QP1A.190711.020/V12.0.3.0.QGGEUXM:user/release-keys__2020-11-01
Redmi Note 8 Pro Global (9 & 10):Redmi:Redmi Note 8 Pro=Redmi/begonia/begonia:9/PPR1.180610.011/V10.4.1.0.PGGMIXM:user/release-keys__2019-09-01;Redmi/begonia/begonia:10/QP1A.190711.020/V12.0.3.0.QGGMIXM:user/release-keys__2020-08-01
Redmi Note 8 Pro India (9 & 10):Redmi:Redmi Note 8 Pro=Redmi/begoniain/begoniain:9/PPR1.180610.011/V10.4.4.0.PGGINXM:user/release-keys__2019-09-01;Redmi/begoniain/begoniain:10/QP1A.190711.020/V11.0.2.0.QGGINXM:user/release-keys__2020-02-01
Redmi Note 8 Pro Russia (9 & 10):Redmi:Redmi Note 8 Pro=Redmi/begonia_ru/begonia:9/PPR1.180610.011/V11.0.3.0.PGGRUXM:user/release-keys__2019-11-01;Redmi/begonia_ru/begonia:10/QP1A.190711.020/V11.0.2.0.QGGRUXM:user/release-keys__2020-02-01
Redmi Note 9 Pro Europe (10):Redmi:Redmi Note 9 Pro=Redmi/joyeuse_eea/joyeuse:10/QKQ1.191215.002/V11.0.4.0.QJZEUXM:user/release-keys__2020-07-01
Redmi Note 9 Pro Global (10):Redmi:Redmi Note 9 Pro=Redmi/joyeuse_global/joyeuse:10/QKQ1.191215.002/V11.0.5.0.QJZMIXM:user/release-keys__2020-07-01
Redmi Note 9S Europe (10):Redmi:Redmi Note 9S=Redmi/curtana_eea/curtana:10/QKQ1.191215.002/V11.0.4.0.QJWEUXM:user/release-keys__2020-07-01
Redmi Note 9S Global (10):Redmi:Redmi Note 9S:=Redmi/curtana_global/curtana:10/QKQ1.191215.002/V11.0.10.0.QJWMIXM:user/release-keys__2020-07-01
Samsung Galaxy A01 Core (10):Samsung:SM-A013G=samsung/a01corextc/a01core:10/QP1A.190711.020/A013GXXU1ATGE:user/release-keys__2020-07-01
Samsung Galaxy A3 2015 SM-A300FU (6.0.1):Samsung:SM-A300FU=samsung/a3ultexx/a3ulte:6.0.1/MMB29M/A300FUXXU1CRF1:user/release-keys
Samsung Galaxy A3 2016 SM-A310F (7.0):samsung:SM-A310F=samsung/a3xeltexx/a3xelte:7.0/NRD90M/A310FXXU4CSB2:user/release-keys__2019-02-01
Samsung Galaxy A3 2017 SM-A320FL (8.0.0):samsung:SM-A320FL=samsung/a3y17ltexc/a3y17lte:8.0.0/R16NW/A320FLXXU4CSD2:user/release-keys__2019-04-01
Samsung Galaxy A5 2015 SM-A500FU (6.0.1):Samsung:SM-A500FU=samsung/a5ultexx/a5ulte:6.0.1/MMB29M/A500FUXXU1CPH3:user/release-keys
Samsung Galaxy A5 2017 SM-A520F (8.0.0):Samsung:SM-A520F=samsung/a5y17ltexx/a5y17lte:8.0.0/R16NW/A520FXXUGCTI9:user/release-keys__2020-09-01
Samsung Galaxy A6 SM-A600F (10):Samsung:SM-A600F=samsung/a6ltexx/a6lte:10/QP1A.190711.020/A600FNXXS7CTI1:user/release-keys__2020-09-01
Samsung Galaxy A6 Plus SM-A605G (9):Samsung:SM-A605G=samsung/a6pltedx/a6plte:9/PPR1.180610.011/A605GDXU3BSC6:user/release-keys__2019-03-01
Samsung Galaxy A7 2017 SM-A720F (8.0.0):Samsung:SM-A720F=samsung/a7y17ltexx/a7y17lte:8.0.0/R16NW/A720FXXU9CSK3:user/release-keys__2019-12-01
Samsung Galaxy A7 2018 SM-A750GN (9 & 10):samsung:SM-A750GN=samsung/a7y18ltedx/a7y18lte:9/PPR1.180610.011/A750GNDXU2BSD2:user/release-keys__2019-04-01;samsung/a7y18ltedx/a7y18lte:10/QP1A.190711.020/A750GNDXS6CTJ2:user/release-keys__2020-10-01
Samsung Galaxy A8 Plus SM-A730F (7.1.1):Samsung:SM-A730F=samsung/jackpot2ltexx/jackpot2lte:7.1.1/NMF26X/A730FXXU2ARD1:user/release-keys
Samsung Galaxy A20 SM-A205W (9):Samsung:SM-A205W=samsung/a20cs/a20:9/PPR1.180610.011/A205WVLU3ASK2:user/release-keys__2019-11-01
Samsung Galaxy A40 SM-A405FN (10):Samsung:SM-A405FN=samsung/a40xx/a40:10/QP1A.190711.020/A405FNXXS3BTI3:user/release-keys__2020-09-01
Samsung Galaxy A50 SM-A505F (9):Samsung:SM-A505F=samsung/a50dd/a50:9/PPR1.180610.011/A505FDDU1ASD6:user/release-keys__2019-04-01
Samsung Galaxy A50S SM-A507FN (10):Samsung:SM-A507FN=samsung/a50sxx/a50s:10/QP1A.190711.020/A507FNXXS5BTI1:user/release-keys__2020-09-01
Samsung Galaxy A51 SM-A515F (10):Samsung:SM-A515F=samsung/a51nsxx/a51:10/QP1A.190711.020/A515FXXU1ASKJ:user/release-keys__2019-12-01
Samsung Galaxy A70 SM-A705FN (10):samsung:SM-A705FN=samsung/a70qxx/a70q:10/QP1A.190711.020/A705FNXXU5CTK4:user/release-keys__2020-11-01
Samsung Galaxy A90 5G SM-A908B (9):samsung:SM-A908B=samsung/r3qxx/r3q:9/PPR1.180610.011/A908BXXU2ASK5:user/release-keys__2019-11-01
Samsung Galaxy Core Prime SM-G361F (5.1.1):Samsung:SM-G361F=samsung/coreprimeveltexx/coreprimevelte:5.1.1/LMY48B/G361FXXU1APB1:user/release-keys
Samsung Galaxy Grand Prime SM-G530BT (5.0.2):Samsung:SM-G530BT=samsung/fortuna3gdtvvj/fortuna3gdtv:5.0.2/LRX22G/G530BTVJU1BPH4:user/release-keys
Samsung Galaxy J2 2015 SM-J200H (5.1.1):Samsung:SM-J200H=samsung/j23gdd/j23g:5.1.1/LMY48B/J200HXXU0AQK2:user/release-keys
Samsung Galaxy J2 Core SM-S260DL (8.1.0):samsung:SM-S260DL:=samsung/j2corepltetfntmo/j2corepltetfntmo:8.1.0/M1AJQ/S260DLUDU1ASC7:user/release-keys__2019-03-01
Samsung Galaxy J3 SM-J320FN (5.1.1):Samsung:SM-J320FN=samsung/j3xnltexx/j3xnlte:5.1.1/LMY47V/J320FNXXU0ARB1:user/release-keys
Samsung Galaxy J5 2015 SM-J500FN (6.0.1):Samsung:SM-J500FN=samsung/j5nltexx/j5nlte:6.0.1/MMB29M/J500FNXXS1BQG1:user/release-keys
Samsung Galaxy J5 2016 SM-J510FN (7.1.1):Samsung:SM-J510FN=samsung/j5xnltexx/j5xnlte:7.1.1/NMF26X/J510FNXXS2BRA2:user/release-keys
Samsung Galaxy J5 Prime SM-G570F (7.0):Samsung:SM-G570F=samsung/on5xeltejv/on5xelte:7.0/NRD90M/G570FXXU1BQI6:user/release-keys
Samsung Galaxy J7 2016 SM-J710FQ (8.1.0):Samsung:SM-J710FQ=samsung/j7xeltetur/j7xelte:8.1.0/M1AJQ/J710FQXXU3CSG1:user/release-keys__2019-07-01
Samsung Galaxy J7 2017 SM-J730F (8.1.0):Samsung:SM-J730F=samsung/j7y17ltexx/j7y17lte:8.1.0/M1AJQ/J730FXXU3BRK2:user/release-keys__2018-11-01
Samsung Galaxy J7 Neo SM-J701M (8.1.0):Samsung:SM-J701M=samsung/j7velteub/j7velte:8.1.0/M1AJQ/J701MUBU6BSD2:user/release-keys__2019-04-01
Samsung Galaxy J7 Prime SM-G610F (6.0.1):Samsung:SM-G610F=samsung/on7xeltedd/on7xelte:6.0.1/MMB29K/G610FDDU1AQG2:user/release-keys
Samsung Galaxy M20 SM-M205F (10):Samsung:SM-M205F=samsung/m20ltedd/m20lte:10/QP1A.190711.020/M205FDDU3CSL4:user/release-keys__2019-12-01
Samsung Galaxy M21 SM-M215F (10):Samsung:SM-M215F=samsung/m21nsxx/m21:10/QP1A.190711.020/M215FXXU2ATI9:user/release-keys__2020-09-01
Samsung Galaxy Note 3 SM-N9005 (5.0):Samsung:SM-N9005=samsung/hltezh/hlte:5.0/LRX21V/N9005ZSUGPJ2:user/release-keys
Samsung Galaxy Note 4 SM-N910F (6.0.1):Samsung:SM-N910F=samsung/trltexx/trlte:6.0.1/MMB29M/N910FXXS1DQH9:user/release-keys
Samsung Galaxy Note 4 SM-N910G (6.0.1):Samsung:SM-N910G=samsung/trltedt/trlte:6.0.1/MMB29M/N910GDTU1DQL2:user/release-keys
Samsung Galaxy Note 5 SM-N920C (7.0):Samsung:SM-N920C=samsung/nobleltejv/noblelte:7.0/NRD90M/N920CXXU3CQH6:user/release-keys
Samsung Galaxy Note 8 SM-N950F (8.0.0):Samsung:SM-N950F=samsung/greatltexx/greatlte:8.0.0/R16NW/N950FXXU3CRC1:user/release-keys
Samsung Galaxy Note 9 SM-N960F (10):Samsung:SM-N960F=samsung/crownltexx/crownlte:10/QP1A.190711.020/N960FXXS4DTA5:user/release-keys__2020-02-01
Samsung Galaxy Note 10 Plus SM-N9750 (10):Samsung:SM-N9750=samsung/d2qzh/d2q:10/QP1A.190711.020/N9750ZSU2CTD1:user/release-keys__2020-04-01
Samsung Galaxy Note 10 Plus SM-N975F (10):Samsung:SM-N975F=samsung/d2sxx/d2s:10/QP1A.190711.020/N975FXXU1BSL7:user/release-keys__2019-12-01
Samsung Galaxy Note 10 Plus SM-N975U (10):Samsung:SM-N975U=samsung/d2qsq/d2q:10/QP1A.190711.020/N975USQU2BTA1:user/release-keys__2020-01-01
Samsung Galaxy Note 10.1 2014 SM-P600 (5.1.1):Samsung:SM-P600=samsung/lt03wifixx/lt03wifi:5.1.1/LMY47X/P600XXUDOJ3:user/release-keys
Samsung Galaxy Note 20 Ultra SM-N986U (10):Samsung:SM-N986U=samsung/c2qsqw/c2q:10/QP1A.190711.020/N986USQU1ATH3:user/release-keys__2020-08-01
Samsung Galaxy Note 20 Ultra 5G SM-N9860 (10):Samsung:SM-N9860=samsung/c2qzhx/c2q:10/QP1A.190711.020/N9860ZSU1ATJ6:user/release-keys__2020-09-01
Samsung Galaxy Note 20 Ultra 5G SM-N986B/DS (10):samsung:SM-N986B=samsung/c2sxxx/c2s:10/QP1A.190711.020/N986BXXU1ATJ1:user/release-keys__2020-10-01
Samsung Galaxy S3 Neo GT-I9300I (4.4.4):Samsung:GT-I9300I=samsung/s3ve3gdd/s3ve3gdd:4.4.4/KTU84P/I9300IDDUBQE2:user/release-keys
Samsung Galaxy S4 GT-I9505 (5.0.1):Samsung:GT-I9505=samsung/jfltexx/jflte:5.0.1/LRX22C/I9505XXUHPF4:user/release-keys
Samsung Galaxy S4 Active GT-I9295 (5.0.1):Samsung:GT-I9295=samsung/jactiveltexx/jactivelte:5.0.1/LRX22C/I9295XXSDQD6:user/release-keys
Samsung Galaxy S5 SM-G900F (6.0.1):Samsung:SM-G900F=samsung/kltexx/klte:6.0.1/MMB29M/G900FXXU1CRH1:user/release-keys
Samsung Galaxy S5 SM-G900H (6.0.1):Samsung:SM-G900H=samsung/k3gxx/k3g:6.0.1/MMB29K/G900HXXU1CPF2:user/release-keys
Samsung Galaxy S6 SM-G920F (7.0):Samsung:SM-G920F=samsung/zerofltexx/zeroflte:7.0/NRD90M/G920FXXS5EQL1:user/release-keys
Samsung Galaxy S6 Edge SM-G925F (7.0):Samsung:SM-G925F=samsung/zeroltexx/zerolte:7.0/NRD90M/G925FXXS5EQL1:user/release-keys
Samsung Galaxy S7 SM-G930F (8.0.0):Samsung:SM-G930F=samsung/heroltexx/herolte:8.0.0/R16NW/G930FXXU2ERD5:user/release-keys
Samsung Galaxy S7 Edge SM-G935F (8.0.0):Samsung:SM-G935F=samsung/hero2ltexx/hero2lte:8.0.0/R16NW/G935FXXS4ESC3:user/release-keys__2019-03-01
Samsung Galaxy S8 SM-G950F (8.0.0):Samsung:SM-G950F=samsung/dreamltexx/dreamlte:8.0.0/R16NW/G950FXXU1CRC7:user/release-keys
Samsung Galaxy S8 Plus SM-G955F (8.0.0):Samsung:SM-G955F=samsung/dream2ltexx/dream2lte:8.0.0/R16NW/G955FXXU1CRC7:user/release-keys
Samsung Galaxy S9 SM-G960F (8.0.0):Samsung:SM-G960F=samsung/starltexx/starlte:8.0.0/R16NW/G960FXXU1ARCC:user/release-keys
Samsung Galaxy S9 Plus SM-G965F (8.0.0):Samsung:SM-G965F=samsung/star2ltexx/star2lte:8.0.0/R16NW/G965FXXU1ARCC:user/release-keys
Samsung Galaxy S10 SM-G973F (10 & 11):Samsung:SM-G973F=samsung/beyond1ltexx/beyond1:10/QP1A.190711.020/G973FXXS3BSL4:user/release-keys__2020-01-01;samsung/beyond1ltexx/beyond1:11/RP1A.200720.012/G973FXXU9ETLJ:user/release-keys__2021-01-01
Samsung Galaxy S10 Plus SM-G975F (10 & 11):Samsung:SM-G975F=samsung/beyond2ltexx/beyond2:10/QP1A.190711.020/G975FXXU3BSKO:user/release-keys__2019-12-01;samsung/beyond2ltexx/beyond2:11/RP1A.200720.012/G975FXXU9ETLJ:user/release-keys__2021-01-01
Samsung Galaxy S10 Plus SM-G975U (9):Samsung:SM-G975U=samsung/beyond2qlteue/beyond2q:9/PPR1.180610.011/G975U1UEU1ASD3:user/release-keys__2019-03-01
Samsung Galaxy S10e SM-G970F (10 & 11):Samsung:SM-G970F=samsung/beyond0ltexx/beyond0:10/QP1A.190711.020/G970FXXS9DTK9:user/release-keys__2020-12-01;samsung/beyond0ltexx/beyond0:11/RP1A.200720.012/G970FXXU9ETLJ:user/release-keys__2021-01-01
Samsung Galaxy S10e SM-G970N (10):Samsung:SM-G970N=samsung/beyond0lteks/beyond0:10/QP1A.190711.020/G970NKSU4CTC9:user/release-keys__2020-04-01
Samsung Galaxy S20 FE 5G (10):samsung:SM-G781B=samsung/r8qxxx/r8q:10/QP1A.190711.020/G781BXXU1ATJ5:user/release-keys__2020-10-01
Samsung Galaxy S20 Ultra SM-G988B (10):Samsung:SM-G988B=samsung/z3sxxx/z3s:10/QP1A.190711.020/G988BXXU1ATCT:user/release-keys__2020-04-01
Samsung Galaxy Tab 2 7.0 GT-P5110 (4.2.2):Samsung:GT-P5110=samsung/espresso10wifixx/espresso10wifi:4.2.2/JDQ39/P5110XXDML1:user/release-keys
Samsung Galaxy Tab 4 7.0 SM-T230NU (4.4.2):samsung:SM-T230NU=samsung/degaswifiue/degaswifiue:4.4.2/KOT49H/T230NUUEU0APA1:user/release-keys
Samsung Galaxy Tab 4 8.0 SM-T330NU (5.1.1):samsung:SM-T330NU=samsung/milletwifiue/milletwifiue:5.1.1/LMY47X/T330NUUES1BPL1:user/release-keys
Samsung Galaxy Tab 4 10.1 SM-T530NU (5.0.2):samsung:SM-T530NU=samsung/matissewifiue/matissewifiue:5.0.2/LRX22G/T530NUUEU1BQC1:user/release-keys
Samsung Galaxy Tab A 8.0 LTE 2019 SM-T295 (9):Samsung:SM-T295=samsung/gtoxx/gto:9/PPR1.180610.011/T295XXS3ATB2:user/release-keys__2020-03-01
Samsung Galaxy tab A 10.1 WiFi 2019 SM-T510 (10):Samsung:SM-T510=samsung/gta3xlwifieea/gta3xlwifi:10/QP1A.190711.020/T510XXU3BTFN:user/release-keys__2020-07-01
Samsung Galaxt Tab A WiFi SM-T590 (9):Samsung:SM-T590=samsung/gta2xlwifixx/gta2xlwifi:9/PPR1.180610.011/T590XXU3BSJ1:user/release-keys__2019-10-01
Samsung Galaxt Tab A LTE SM-T595 (9):Samsung:SM-T595=samsung/gta2xlltexx/gta2xllte:9/PPR1.180610.011/T595XXU3BSF3:user/release-keys__2019-06-01
Samsung Galaxt Tab A LTE SM-T597 (9):Samsung:SM-T597=samsung/gta2xlltespr/gta2xlltespr:9/PPR1.180610.011/T597PVPU2BSH7:user/release-keys__2019-08-01
Samsung Galaxy Tab E 9.6 SM-T560 (4.4.4):Samsung:SM-T560=samsung/gtelwifixx/gtelwifi:4.4.4/KTU84P/T560XXU0APL1:user/release-keys
Samsung Galaxy Tab S2 SM-T813 (7.0):samsung:SM-T813=samsung/gts210vewifixx/gts210vewifi:7.0/NRD90M/T813XXS2BSJ3:user/release-keys__2019-08-01
Samsung Galaxy Tab S3 LTE SM-T825 (8.0.0):Samsung:SM-T825=samsung/gts3lltexx/gts3llte:8.0.0/R16NW/T825XXU2BRL2:user/release-keys__2018-12-01
Samsung Galaxy Tab S4 WiFi SM-T830 (10):samsung:SM-T830=samsung/gts4lwifixx/gts4lwifi:10/QP1A.190711.020/T830XXU4CTF5:user/release-keys__2020-06-01
Samsung Galaxy Tab S4 LTE SM-T835 (10):samsung:SM-T835=samsung/gts4lltexx/gts4llte:10/QP1A.190711.020/T835XXU4CTF5:user/release-keys__2020-06-01
Samsung Galaxy Tab S5e SM-T720 (9 & 10):samsung:SM-T720=samsung/gts4lvwifixx/gts4lvwifi:9/PPR1.180610.011/T720XXS1ASL3:user/release-keys__2020-01-01;samsung/gts4lvwifixx/gts4lvwifi:10/QP1A.190711.020/T720XXU1BTG3:user/release-keys__2020-06-01
Samsung Galaxy Tab S6 Lite SM-P610 (10):samsung:SM-P610=samsung/gta4xlwifixx/gta4xlwifi:10/QP1A.190711.020/P610XXU2BTK2:user/release-keys__2020-12-01
Sony Xperia 5 DSDS J9210 (10):Sony:J9210=Sony/J9210_RU/J9210:10/55.1.A.9.52/055001A009005201481357772:user/release-keys__2020-07-01
Sony Xperia 10 II Dual XQ-AU52 (10):Sony:XQ-AU52=Sony/XQ-AU52_EEA/XQ-AU52:10/59.0.A.6.24/059000A006002402956232951:user/release-keys__2020-07-01
Sony Xperia M (4.3):Sony:C1905=Sony/C1905/C1905:4.3/15.4.A.1.9/eng.user.20140509.125022:user/release-keys
Sony Xperia X F5121 (8.0.0):Sony:F5121=Sony/F5121/F5121:8.0.0/34.4.A.2.118/1631208121:user/release-keys__2018-09-01
Sony Xperia X Compact F5321 (8.0.0):Sony:F5321=Sony/F5321/F5321:8.0.0/34.4.A.2.118/1631208121:user/release-keys__2018-09-01
Sony Xperia X Dual F5122 (8.0.0):Sony:F5122=Sony/F5122/F5122:8.0.0/34.4.A.2.118/1631208121:user/release-keys__2018-09-01
Sony Xperia X Performance F8131 (8.0.0):Sony:F8131=Sony/F8131/F8131:8.0.0/41.3.A.2.99/1455830589:user/release-keys
Sony Xperia X Performance Dual F8132 (8.0.0):Sony:F8132=Sony/F8132/F8132:8.0.0/41.3.A.2.99/1455830589:user/release-keys
Sony Xperia XA2 Dual H4113 (8.0.0):Sony:H4113=Sony/H4113/H4113:8.0.0/50.1.A.4.76/2209478692:user/release-keys
Sony Xperia XA2 Ultra H3223 (9):Sony:H3223:=Sony/H3223/H3223:9/50.2.A.3.22/2120505936:user/release-keys__2019-11-01
Sony Xperia XZ F8331 (8.0.0):Sony:F8331=Sony/F8331/F8331:8.0.0/41.3.A.2.99/1455830589:user/release-keys
Sony Xperia XZ Dual F8332 (8.0.0):Sony:F8332=Sony/F8332/F8332:8.0.0/41.3.A.2.99/1455830589:user/release-keys
Sony Xperia XZ Premium G8141 (8.0.0):Sony:G8141=Sony/G8141/G8141:8.0.0/47.1.A.12.179/1909673090:user/release-keys
Sony Xperia XZ Premium Dual G8142 (8.0.0):Sony:G8142=Sony/G8142/G8142:8.0.0/47.1.A.12.179/1909673090:user/release-keys
Sony Xperia XZ1 G8341 (8.0.0):Sony:G8341=Sony/G8341/G8341:8.0.0/47.1.A.12.179/1909673090:user/release-keys
Sony Xperia XZ1 Compact G8441 (8.0.0 & 9):Sony:G8441=Sony/G8441/G8441:8.0.0/47.1.A.12.179/1909673090:user/release-keys;Sony/G8441/G8441:9/47.2.A.11.228/3311891731:user/release-keys__2019-09-01
Sony Xperia XZ1 Dual G8342 (8.0.0):Sony:G8342=Sony/G8342/G8342:8.0.0/47.1.A.12.179/1909673090:user/release-keys
Sony Xperia XZ2 H8216 (8.0.0):Sony:H8216=Sony/H8216/H8216:8.0.0/51.1.A.3.159/620448843:user/release-keys
Sony Xperia XZ2 Compact H8314 (8.0.0):Sony:H8314=Sony/H8314/H8314:8.0.0/51.1.A.3.159/620448843:user/release-keys
Sony Xperia XZ2 Compact Dual H8324 (8.0.0):Sony:H8324=Sony/H8324/H8324:8.0.0/51.1.A.3.159/620448843:user/release-keys
Sony Xperia XZ2 Dual H8266 (8.0.0):Sony:H8266=Sony/H8266/H8266:8.0.0/51.1.A.3.159/620448843:user/release-keys
Sony Xperia Z C6603 (5.1.1):Sony:C6603=Sony/C6603/C6603:5.1.1/10.7.A.0.228/58103698:user/release-keys
Sony Xperia Z1 C6903 (5.1.1):Sony:C6903=Sony/C6903/C6903:5.1.1/14.6.A.1.236/2031203603:user/release-keys
Sony Xperia Z2 D6503 (6.0.1):Sony:D6503=Sony/D6503/D6503:6.0.1/23.5.A.1.291/2769308465:user/release-keys
Sony Xperia Z3 D6633 (6.0.1):Sony:D6633=Sony/D6633/D6633:6.0.1/23.5.A.1.291/2769308465:user/release-keys
Sony Xperia Z3 Compact D5803 (6.0.1):Sony:D5803=Sony/D5803/D5803:6.0.1/23.5.A.1.291/2769308465:user/release-keys
Sony Xperia Z3 Tablet Compact SGP621 (6.0.1):Sony:SGP621=Sony/SGP621/SGP621:6.0.1/23.5.A.1.291/3706784398:user/release-keys
Sony Xperia Z4 Tablet LTE SGP771 (7.1.1):Sony:SGP771=Sony/SGP771/SGP771:7.1.1/32.4.A.1.54/219395100:user/release-keys
Sony Xperia Z5 E6603 (7.1.1):Sony:E6603=Sony/E6603/E6603:7.1.1/32.4.A.1.54/3761073091:user/release-keys
Sony Xperia Z5 E6653 (7.1.1):Sony:E6653=Sony/E6653/E6653:7.1.1/32.4.A.1.54/3761073091:user/release-keys
Sony Xperia Z5 Compact E5823 (7.1.1):Sony:E5823=Sony/E5823/E5823:7.1.1/32.4.A.1.54/3761073091:user/release-keys
Sony Xperia Z5 Dual E6633 (7.1.1):Sony:E6633=Sony/E6633/E6633:7.1.1/32.4.A.1.54/3761073091:user/release-keys
Sony Xperia Z5 Premium E6853 (7.1.1):Sony:E6853=Sony/E6853/E6853:7.1.1/32.4.A.1.54/3761073091:user/release-keys
Sony Xperia Z5 Premium Dual E6883 (7.1.1):Sony:E6883=Sony/E6883/E6883:7.1.1/32.4.A.1.54/3761073091:user/release-keys
Vodafone Smart Ultra 6 (5.1.1):Vodafone:Vodafone Smart ultra 6=Vodafone/P839V55/P839V55:5.1.1/LMY47V/20161227.134319.15534:user/release-keys
Walmart Onn 8 (9):Onn:ONA19TB002=onn/ONA19TB002/ONA19TB002:9/PPR1.180610.011/1551232410:user/release-keys__2019-01-05
Xiaomi Mi 3 Global (6.0.1):Xiaomi:MI 3W=Xiaomi/cancro/cancro:6.0.1/MMB29M/V9.5.2.0.MXDMIFA:user/release-keys
Xiaomi Mi 4 Global (6.0.1):Xiaomi:MI 4W=Xiaomi/cancro/cancro:6.0.1/MMB29M/V9.5.2.0.MXDMIFA:user/release-keys
Xiaomi Mi 4C China (7.0):Xiaomi:Mi-4c=Xiaomi/libra/libra:7.0/NRD90M/V9.6.2.0.NXKCNFD:user/release-keys
Xiaomi Mi 5/5 Pro Global (7.0 & 8.0.0):Xiaomi:MI 5=Xiaomi/gemini/gemini:7.0/NRD90M/V9.2.1.0.NAAMIEK:user/release-keys;Xiaomi/gemini/gemini:8.0.0/OPR1.170623.032/V9.6.1.0.OAAMIFD:user/release-keys
Xiaomi Mi 5S Global (7.0):Xiaomi:MI 5s=Xiaomi/capricorn/capricorn:7.0/NRD90M/V9.5.4.0.NAGMIFD:user/release-keys
Xiaomi Mi 5S Plus Global (6.0.1 & 7.0):Xiaomi:MI 5s Plus=Xiaomi/natrium/natrium:6.0.1/MXB48T/V8.5.2.0.MBGMIED:user/release-keys;Xiaomi/natrium/natrium:7.0/NRD90M/V9.6.2.0.NBGMIFD:user/release-keys
Xiaomi Mi 6 Global (8.0.0 & 9):Xiaomi:MI 6=Xiaomi/sagit/sagit:8.0.0/OPR1.170623.027/V9.2.3.0.OCAMIEK:user/release-keys;Xiaomi/sagit/sagit:9/PKQ1.190118.001/V11.0.6.0.PCAMIXM:user/release-keys__2019-09-01
Xiaomi Mi 8 Global (8.1.0 & 9 & 10):Xiaomi:MI 8=Xiaomi/dipper/dipper:8.1.0/OPM1.171019.011/V9.5.5.0.OEAMIFA:user/release-keys;Xiaomi/dipper/dipper:9/PKQ1.180729.001/V10.2.3.0.PEAMIXM:user/release-keys__2019-02-01;Xiaomi/dipper/dipper:10/QKQ1.190828.002/V11.0.3.0.QEAMIXM:user/release-keys__2020-01-01
Xiaomi Mi 9 Europe (9):Xiaomi:MI 9=Xiaomi/cepheus_eea/cepheus:9/PKQ1.181121.001/V10.2.27.0.PFAEUXM:user/release-keys__2019-06-01
Xiaomi Mi 9 Lite Global (9):Xiaomi:Mi 9 Lite=Xiaomi/pyxis/pyxis:9/PKQ1.181121.001/V11.3.3.0.PFCMIXM:user/release-keys__2019-10-01
Xiaomi Mi 9 SE Global (9):MI 9 SE=Xiaomi/grus/grus:9/PKQ1.181121.001/V11.0.4.0.PFBMIXM:user/release-keys__2019-10-01
Xiaomi Mi 9T China (10):Xiaomi:Mi 9T=Xiaomi/davinci/davinci:10/QKQ1.190825.002/V12.0.6.0.QFJCNXM:user/release-keys__2020-10-01
Xiaomi Mi 9T Europe (9 & 10):Xiaomi:Mi 9T=Xiaomi/davinci_eea/davinci:9/PKQ1.190302.001/V10.3.12.0.PFJEUXM:user/release-keys__2019-07-01;Xiaomi/davinci_eea/davinci:10/QKQ1.190825.002/V12.0.3.0.QFJEUXM:user/release-keys__2020-10-01
Xiaomi Mi 9T Pro China (9):Xiaomi:Mi 9T Pro=Xiaomi/raphael/raphael:9/PKQ1.181121.001/V10.3.14.0.PFKCNXM:user/release-keys__2019-06-01
Xiaomi Mi 9T Pro Global (9):Xiaomi:Mi 9T Pro=Xiaomi/raphael/raphael:10/QKQ1.190825.002/V11.0.1.0.QFKMIXM:user/release-keys__2019-10-01
Xiaomi Mi 10 China (10 & 11):Xiaomi:Mi 10=Xiaomi/umi/umi:10/QKQ1.191117.002/V12.0.8.0.QJBCNXM:user/release-keys__2020-07-01;Xiaomi/umi/umi:11/RKQ1.200710.002/V12.1.3.0.RJBCNXM:user/release-keys__2020-09-01
Xiaomi MI 10 Europe (10):Xiaomi:Mi 10=Xiaomi/umi_eea/umi:10/QKQ1.191117.002/V11.0.10.0.QJBEUVF:user/release-keys__2020-07-01
Xiaomi Mi 10 Lite 5G Europe (10):Xiaomi:M2002J9G=Xiaomi/monet_eea/monet:10/QKQ1.191222.002/V12.0.1.0.QJIEUXM:user/release-keys__2020-06-01
Xiaomi Mi 10 Lite 5G Global (10):Xiaomi:M2002J9G=Xiaomi/monet_global/monet:10/QKQ1.191222.002/V12.0.1.0.QJIMIXM:user/release-keys__2020-08-01
Xiaomi Mi 10 Pro China (10 & 11):Xiaomi:Mi 10 Pro=Xiaomi/cmi/cmi:10/QKQ1.191117.002/V12.0.4.0.QJACNXM:user/release-keys__2020-07-01;Xiaomi/cmi/cmi:11/RKQ1.200710.002/V12.1.2.0.RJACNXM:user/release-keys__2020-09-01
Xiaomi Mi 10 Ultra China (10):Xiaomi:Mi 10 Ultra=Xiaomi/cas/cas:10/QKQ1.200419.002/V12.0.10.0.QJJCNXM:user/release-keys__2020-08-01
Xiaomi Mi 10T Europe (10):Xiaomi:M2007J3SY=Xiaomi/apollo_eea/apollo:10/QKQ1.200419.002/V12.0.13.0.QJDEUXM:user/release-keys__2020-11-01
Xiaomi Mi 10T Pro Europe (10):Xiaomi:M2007J3SG=Xiaomi/apollopro_eea/apollo:10/QKQ1.200419.002/V12.0.13.0.QJDEUXM:user/release-keys__2020-11-01
Xiaomi Mi A1 Global (7.1.2 & 8.0.0 & 8.1.0 & 9):Xiaomi:Mi A1=xiaomi/tissot/tissot_sprout:7.1.2/N2G47H/7.12.19:user/release-keys;xiaomi/tissot/tissot_sprout:8.0.0/OPR1.170623.026/V.9.5.10.0.ODHMIFA:user/release-keys__2018-04-01;xiaomi/tissot/tissot_sprout:8.1.0/OPM1.171019.026/V9.6.8.0.ODHMIFE:user/release-keys__2018-11-01;xiaomi/tissot/tissot_sprout:9/PKQ1.180917.001/V10.0.24.0.PDHMIXM:user/release-keys__2020-08-01
Xiaomi Mi A2 Global (8.1.0 & 9 & 10):Xiaomi:Mi A2=xiaomi/jasmine/jasmine_sprout:8.1.0/OPM1.171019.011/V9.6.17.0.ODIMIFE:user/release-keys__2018-11-05;xiaomi/jasmine/jasmine_sprout:9/PKQ1.180904.001/V10.0.18.0.PDIMIXM:user/release-keys__2019-12-05;xiaomi/jasmine/jasmine_sprout:10/QKQ1.190910.002/V11.0.19.0.QDIMIXM:user/release-keys__2020-12-01
Xiaomi Mi A2 Lite Global (8.1.0 & 9 & 10):Xiaomi:Mi A2 Lite=xiaomi/daisy/daisy_sprout:8.1.0/OPM1.171019.019/V9.6.11.0.ODLMIFF:user/release-keys__2018-11-01;xiaomi/daisy/daisy_sprout:9/PKQ1.180917.001/V10.0.20.0.PDLMIXM:user/release-keys__2020-03-01;xiaomi/daisy/daisy_sprout:10/QKQ1.191002.002/V11.0.16.0.QDLMIXM:user/release-keys__2020-12-01
Xiaomi Mi A3 Global (9 & 10):Xiaomi:Mi A3=Xiaomi/laurel_sprout/laurel_sprout:9/PKQ1.190416.001/V10.3.16.0.PFQMIXM:user/release-keys__2020-03-05;Xiaomi/laurel_sprout/laurel_sprout:10/QKQ1.190910.002/V11.0.26.0.QFQMIXM:user/release-keys__2020-12-05
Xiaomi Mi Box S (9):Xiaomi:MIBOX4=Xiaomi/oneday/oneday:9/PI/2231:user/release-keys__2019-11-05
Xiaomi Mi Max Global (6.0.1):Xiaomi:MI MAX=Xiaomi/helium/helium:6.0.1/MMB29M/V8.2.3.0.MBDMIDL:user/release-keys
Xiaomi Mi Max 2 Global (7.1.1):Xiaomi:MI MAX 2=Xiaomi/oxygen/oxygen:7.1.1/NMF26F/V9.5.4.0.NDDMIFA:user/release-keys
Xiaomi Mi Max 3 Global (9):Xiaomi:MI MAX 3=Xiaomi/nitrogen/nitrogen:9/PKQ1.181007.001/V10.3.1.0.PEDMIXM:user/release-keys__2019-03-01
Xiaomi Mi Mix 2 Global (8.0.0 & 9):Xiaomi:Mi MIX 2=Xiaomi/chiron/chiron:8.0.0/OPR1.170623.027/V10.2.2.0.ODEMIXM:user/release-keys__2018-12-01;Xiaomi/chiron/chiron:9/PKQ1.190118.001/V11.0.3.0.PDEMIXM:user/release-keys__2019-09-01
Xiaomi Mi Mix 2S Global (8.0.0 & 9):Xiaomi:Mi MIX 2S=Xiaomi/polaris/polaris:8.0.0/OPR1.170623.032/V9.5.19.0.ODGMIFA:user/release-keys;Xiaomi/polaris/polaris:9/PKQ1.180729.001/V10.3.3.0.PDGMIXM:user/release-keys__2019-05-01
Xiaomi Mi Mix 2S China (10):Xiaomi:Mi MIX 2S=Xiaomi/polaris/polaris:10/QKQ1.190828.002/V11.0.1.0.QDGCNXM:user/release-keys__2019-12-01
Xiaomi Mi Mix 3 Global (9 & 10):Xiaomi:Mi MIX 3=Xiaomi/perseus/perseus:9/PKQ1.180729.001/V10.3.1.0.PEEMIXM:user/release-keys__2019-03-01;Xiaomi/perseus/perseus:10/QKQ1.190828.002/V11.0.3.0.QEEMIXM:user/release-keys__2020-02-01
Xiaomi Mi Note 2 China (8.0.0):Xiaomi:Mi Note 2=Xiaomi/scorpio/scorpio:8.0.0/OPR1.170623.032/V9.6.1.0.OADCNFD:user/release-keys
Xiaomi Mi Note 2 Global (7.0):Xiaomi:Mi Note 2=Xiaomi/scorpio/scorpio:7.0/NRD90M/V9.2.1.0.NADMIEK:user/release-keys
Xiaomi Mi Note 3 Global (8.1.0):Xiaomi:Mi Note 3=Xiaomi/jason/jason:8.1.0/OPM1.171019.019/V10.2.2.0.OCHMIXM:user/release-keys__2018-12-01
Xiaomi Mi Note 10 Europe (9):Xiaomi:Mi Note 10=Xiaomi/tucana_eea/tucana:9/PKQ1.190302.001/V11.0.11.0.PFDEUXM:user/release-keys__2019-11-01
Xiaomi Mi Pad Global (4.4.4):Xiaomi:MI PAD=Xiaomi/mocha/mocha:4.4.4/KTU84P/V7.5.2.0.KXFMIDE:user/release-keys
Xiaomi Mi Pad 4 China (8.1.0):Xiaomi:MI PAD 4=Xiaomi/clover/clover:8.1.0/OPM1.171019.019/V10.1.1.0.ODJCNFI:user/release-keys__2018-10-01
Xiaomi Pocophone F1 Global (9 & 10):Xiaomi:POCOPHONE F1=Xiaomi/beryllium/beryllium:9/PKQ1.180729.001/V11.0.5.0.PEJMIXM:user/release-keys__2019-10-01;Xiaomi/beryllium/beryllium:10/QKQ1.190828.002/V12.0.2.0.QEJMIXM:user/release-keys__2020-09-01
Xiaomi Redmi 3/3 Pro Global (5.1.1):Xiaomi:Redmi 3=Xiaomi/ido/ido:5.1.1/LMY47V/V9.6.2.0.LAIMIFD:user/release-keys
Xiaomi Redmi 3S/X Prime Global (6.0.1):Xiaomi:Redmi 3S=Xiaomi/land/land:6.0.1/MMB29M/V9.5.1.0.MALMIFA:user/release-keys
Xiaomi Redmi 4 Pro Global (6.0.1):Xiaomi:Redmi 4=Xiaomi/markw/markw:6.0.1/MMB29M/V9.5.3.0.MBEMIFA:user/release-keys
Xiaomi Redmi 4A Global (7.1.2):Xiaomi:Redmi 4A=Xiaomi/rolex/rolex:7.1.2/N2G47H/V9.2.6.0.NCCMIEK:user/release-keys
Xiaomi Redmi 4X China (6.0.1):Xiaomi:Redmi 4X=Xiaomi/santoni/santoni:6.0.1/MMB29M/V8.5.4.0.MAMCNED:user/release-keys
Xiaomi Redmi 5 Plus Global (7.1.2 & 8.1.0):Xiaomi:Redmi 5 Plus=xiaomi/vince/vince:7.1.2/N2G47H/V9.5.4.0.NEGMIFA:user/release-keys;xiaomi/vince/vince:8.1.0/OPM1.171019.019/V10.2.1.0.OEGMIXM:user/release-keys__2019-03-01
Xiaomi Redmi 5A Global (7.1.2 & 8.1.0):Xiaomi:Redmi 5A=Xiaomi/riva/riva:7.1.2/N2G47H/V9.1.8.0.NCKMIEI:user/release-keys;Xiaomi/riva/riva:8.1.0/OPM1.171019.026/V10.3.2.0.OCKMIXM:user/release-keys__2019-06-01
Xiaomi Redmi 6 Global (9):Xiaomi:Redmi 6=xiaomi/cereus/cereus:9/PPR1.180610.011/V11.0.3.0.PCGMIXM:user/release-keys__2020-03-01
Xiaomi Redmi 6A Global (9):Xiaomi:Redmi 6A=xiaomi/cactus/cactus:9/PPR1.180610.011/V11.0.7.0.PCBMIXM:user/release-keys__2020-03-01
Xiaomi Redmi 7 Global (9):Xiaomi:Redmi 7=xiaomi/onc/onc:9/PKQ1.181021.001/V11.0.5.0.PFLMIXM:user/release-keys__2020-03-01
Xiaomi Redmi 7A Global (9 & 10):Xiaomi:Redmi 7A=Xiaomi/pine/pine:9/PKQ1.190319.001/V11.0.7.0.PCMMIXM:user/release-keys__2020-03-01;Xiaomi/pine/pine:10/QKQ1.191014.001/V11.0.3.0.QCMMIXM:user/release-keys__2020-07-01
Xiaomi Redmi 8 China (9 & 10):Xiaomi:Redmi 8=Xiaomi/olive/olive:9/PKQ1.190319.001/V11.0.7.0.PCNCNXM:user/release-keys__2019-12-01;Xiaomi/olive/olive:10/QKQ1.191014.001/V11.0.1.0.QCNCNXM:user/release-keys__2020-06-01
Xiaomi Redmi Go Global (8.1.0):Xiaomi:Redmi Go=Xiaomi/tiare/tiare:8.1.0/OPM1.171019.026/V10.2.6.0.OCLMIXM:user/release-keys__2019-01-01
Xiaomi Redmi K20 Pro China (9 & 10):Xiaomi:Redmi K20 Pro=Xiaomi/raphael/raphael:9/PKQ1.181121.001/V10.3.14.0.PFKCNXM:user/release-keys__2019-06-01;Xiaomi/raphael/raphael:10/QKQ1.190825.002/V12.0.6.0.QFKCNXM:user/release-keys__2020-11-01
Xiaomi Redmi K20 Pro Global (10):Xiaomi:Redmi K20 Pro=Xiaomi/raphael/raphael:10/QKQ1.190825.002/V11.0.1.0.QFKMIXM:user/release-keys__2019-10-01
Xiaomi Redmi K20 Pro India (10):Xiaomi:Redmi K20 Pro=Xiaomi/raphaelin/raphaelin:10/QKQ1.190825.002/V12.0.2.0.QFKINXM:user/release-keys__2020-06-01
Xiaomi Redmi Note 2 Global (5.0.2):Xiaomi:Redmi Note 2=Xiaomi/hermes/hermes:5.0.2/LRX22G/V9.2.4.0.LHMMIEK:user/release-keys
Xiaomi Redmi Note 3 Pro China (6.0.1):Xiaomi:Redmi Note 3=Xiaomi/kenzo/kenzo:6.0.1/MMB29M/V8.2.1.0.MHOCNDL:user/release-keys
Xiaomi Redmi Note 3 Pro SE Global (6.0.1):Xiaomi:Redmi Note 3=Xiaomi/kate/kate:6.0.1/MMB29M/V8.1.3.0.MHRMIDI:user/release-keys
Xiaomi Redmi Note 4 Global (7.0):Redmi Note 4=xiaomi/mido/mido:7.0/NRD90M/V11.0.2.0.NCFMIXM:user/release-keys__2018-12-01
Xiaomi Redmi Note 4X Global (7.0):Redmi Note 4X=xiaomi/mido/mido:7.0/NRD90M/V11.0.2.0.NCFMIXM:user/release-keys__2018-12-01
Xiaomi Redmi Note 4 Mediatek Global (6.0):Xiaomi:Redmi Note 4=Xiaomi/nikel/nikel:6.0/MRA58K/V9.2.2.0.MBFMIEK:user/release-keys
Xiaomi Redmi Note 5 Global (7.1.2 & 8.1.0):Redmi Note 5=xiaomi/vince/vince:7.1.2/N2G47H/V9.5.4.0.NEGMIFA:user/release-keys;xiaomi/vince/vince:8.1.0/OPM1.171019.019/V10.2.1.0.OEGMIXM:user/release-keys__2019-03-01
Xiaomi Redmi Note 5 Pro Global (8.1.0 & 9):Xiaomi:Redmi Note 5 Pro=xiaomi/whyred/whyred:8.1.0/OPM1.171019.011/V10.0.6.0.OEIMIFH:user/release-keys__2018-11-01;xiaomi/whyred/whyred:9/PKQ1.180904.001/V11.0.3.0.PEIMIXM:user/release-keys__2019-11-05
Xiaomi Redmi Note 5A Lite Global (7.1.2):Xiaomi:Redmi Note 5A=xiaomi/ugglite/ugglite:7.1.2/N2G47H/V9.1.2.0.NDFMIEI:user/release-keys
Xiaomi Redmi Note 6 Pro Global (8.1.0):Xiaomi:Redmi Note 6 Pro=xiaomi/tulip/tulip:8.1.0/OPM1.171019.011/V10.0.5.0.OEKMIFH:user/release-keys__2018-10-01
Xiaomi Redmi Note 7 Global (9):Xiaomi:Redmi Note 7=xiaomi/lavender/lavender:9/PKQ1.180904.001/V11.0.5.0.PFGMIXM:user/release-keys__2020-01-05
Xiaomi Redmi Note 7 Pro India (9):Xiaomi:Redmi Note 7 Pro=xiaomi/violet/violet:9/PKQ1.181203.001/V10.3.13.0.PFHINXM:user/release-keys__2019-08-01
Xiaomi Redmi Note 8 Global (9 & 10):Xiaomi:Redmi Note 8=xiaomi/ginkgo/ginkgo:9/PKQ1.190616.001/V11.0.11.0.PCOMIXM:user/release-keys__2020-09-01;xiaomi/ginkgo/ginkgo:10/QKQ1.200114.002/V12.0.1.0.QCOMIXM:user/release-keys__2020-09-01
Xiaomi Redmi Note 8T Europe (9):Redmi:Redmi Note 8T=xiaomi/willow_eea/willow:9/PKQ1.190616.001/V10.3.5.0.PCXEUXM:user/release-keys__2019-10-01
Xiaomi Redmi Y1 Global (7.1.2):Xiaomi:Redmi Y1=xiaomi/ugg/ugg:7.1.2/N2G47H/V9.6.2.0.NDKMIFD:user/release-keys__2018-07-01
ZTE Axon 7 (7.1.1 & 8.0.0):ZTE:ZTE A2017=ZTE/P996A01_N/ailsa_ii:7.1.1/NMF26V/20171211.005949:user/release-keys;ZTE/P996A01_O/ailsa_ii:8.0.0/OPR1.170623.032/20180815.171922:user/release-keys__2018-07-01
ZTE Blade (6.0.1):ZTE:Blade A310=ZTE/P809A50_MY_MAX/P809A50:6.0.1/MMB29M/20161017.095504:user/release-keys
ZTE Nubia Z17 (7.1.1):ZTE:NX563J=nubia/NX563J/NX563J:7.1.1/NMF26X/eng.nubia.20171019.101529:user/release-keys
Zuk Z2 Pro (7.0):Zuk:ZUK Z2121=ZUK/z2_row/z2_row:7.0/NRD90M/2.5.435_170525:user/release-keys
"
