MODDIR=${0%/*}
test ! -e $MODDIR/log && mkdir -p $MODDIR/log
export PATH=/system/bin:$(magisk --path)/.magisk/busybox:/sbin/.magisk/busybox:$PATH

cd $MODDIR/log
echo "开始整理时间 $(date +%y年%m月%d日%H点%M分)" >>fstrim.log

function fstrimcount(){
fstrim_path="/system /vendor /cache /data "
for i in $fstrim_path;do
count=`fstrim -v $i |tr -cd [0-9]`
if test "$count" -le "1024";then
echo "正在对"$i"进行磁盘整理，已经整理了"$count"B"
elif test "$count" -gt "1024" -a "$count" -le "$((1024*1024))";then
count=$(($count/1024))
echo "正在对"$i"进行磁盘整理，已经整理了"$count"KB"
elif test "$count" -gt "$((1024*1024))" -a "$count" -le "$((1024*1024*1024))";then
count=$(($count/1024/1024))
echo "正在对"$i"进行磁盘整理，已经整理了"$count"MB"
elif test "$count" -gt "$((1024*1024*1024))" -a "$count" -le "$((1024*1024*1024*1024))";then
count=$(($count/1024/1024/1024))
echo "正在对"$i"进行磁盘整理，已经整理了"$count"GB"
fi
done
sm fstrim 2>/dev/null
}
echo "$(fstrimcount)" >>fstrim.log
echo -e "整理完成时间 $(date +%y年%m月%d日%H点%M分)\n" >>fstrim.log
