export PATH=/system/bin:$(magisk --path)/.magisk/busybox:/sbin/.magisk/busybox:$PATH

cd /data/adb/modules
for i in $(ls);do
	name=$(cat $i/module.prop | grep 'name' | cut -d = -f2 )
	author=$(cat $i/module.prop | grep 'author' | cut -d = -f2 )
	description=$(cat $i/module.prop | grep 'description' | cut -d = -f2 )
	size=` du -sh $i|awk '{print $1}'`
	if test -e "$i/system/vendor/overlay" -o -e "$i/system/product/overlay" ;then
		echo " "
		echo "∞————————————————————————∞"
		echo " "
		echo "－名称：$name"
		echo "－作者：$author"
		echo "－简介：$description"
		echo " "
		echo "－大小：$size"
		echo " "
		echo "－此模块包含Overlay模块"
		if test ! -e "$i/uninstall.sh" ;then
			echo "－并且此模块并无uninstall.sh(卸载脚本)"
			echo "－已经为您创建卸载脚本。"
			echo '
			#!/system/bin
			rm -rf /data/resource-cache/*
			' > $i/uninstall.sh
		else
			echo "－模块已经包含卸载脚本，跳过。"
		fi
		echo "∞————————————————————————∞"
		echo " "
	fi
done

