MODDIR=${0%/*}

capacity_raw=/sys/class/power_supply/bms/capacity_raw
capacity=/sys/class/power_supply/bms/capacity
status=/sys/class/power_supply/battery/status

current=0
set_level(){
  if [[ "$1" != "$current" ]]; then
    dumpsys battery set level $1
    if [ $? -eq 0 ]; then
      current="$1"
    fi
  fi
}

run_shell(){
  sleep 30
  interval=20
  if [ -f "$capacity_raw" ]
  then
    while [ 1=1 ]; do
      level=$(($(cat $capacity_raw)/100))
      if [[ $level -lt 1 ]]; then
        level=1
      fi
      set_level $level
      if [[ $(cat $status) == "Charging" ]]; then
        interval=5
      else
        interval=20
      fi
      sleep $interval
    done
  elif [ -f "$capacity" ]
  then
    while [ 1=1 ]; do
      set_level $(($(cat $capacity)/100))
      if [[ $(cat $status) == "Charging" ]]; then
        interval=5
      else
        interval=20
      fi
      sleep $interval
    done
  fi
}

run_binary(){
  if [[ -f $capacity ]] && [[ -f $capacity_raw ]]; then
    chmod 777 $capacity
    nohup $MODDIR/bat_capacity_fix > /dev/null 2>&1 &
  fi
}

run_binary
