##########################################################################################
#
# Magisk Module Template Config Script
# by topjohnwu
#
##########################################################################################
##########################################################################################
#
# Instructions:
#
# 1. Place your files into system folder (delete the placeholder file)
# 2. Fill in your module's info into module.prop
# 3. Configure the settings in this file (config.sh)
# 4. If you need boot scripts, add them into common/post-fs-data.sh or common/service.sh
# 5. Add your additional or modified system properties into common/system.prop
#
##########################################################################################

##########################################################################################
# Configs
##########################################################################################

# Set to true if you need to enable Magic Mount
# Most mods would like it to be enabled
AUTOMOUNT=true

# Set to true if you need to load system.prop
PROPFILE=false

# Set to true if you need post-fs-data script
POSTFSDATA=false

# Set to true if you need late_start service script
LATESTARTSERVICE=false

##########################################################################################
# Installation Message
##########################################################################################

# Set what you want to show when installing your mod

print_modname() {
  ui_print "*******************************"
  ui_print "*******************************"
  ui_print "		微信公众号：宁静之雨		
		十多年的老朋友		
		专注数码和手机		
		Wechat Ofiicial Account:		
		NJZYSHARE		"
  ui_print "*******************************"
}

##########################################################################################
# Replace list
##########################################################################################

# List all directories you want to directly replace in the system
# Check the documentations for more info about how Magic Mount works, and why you need this

# This is an example
REPLACE="
/system/app/Youtube
/system/priv-app/SystemUI
/system/priv-app/Settings
/system/framework
"

# Construct your own list here, it will override the example above
# !DO NOT! remove this if you don't need to replace anything, leave it empty as it is now
REPLACE="
/system/fonts/Clock2017L.ttf
/system/fonts/Clock2017R.ttf
/system/fonts/GoogleSans-Bold.ttf
/system/fonts/GoogleSans-BoldItalic.ttf
/system/fonts/GoogleSans-Italic.ttf
/system/fonts/GoogleSans-Medium.ttf
/system/fonts/GoogleSans-MediumItalic.ttf
/system/fonts/GoogleSans-Regular.ttf
/system/fonts/DroidSans-Bold.ttf
/system/fonts/DroidSans.ttf
/system/fonts/NotoSansCJK-Regular.ttc
/system/fonts/NotoSansSC-Bold.otf
/system/fonts/NotoSansSC-Medium.otf
/system/fonts/NotoSansSC-Regular.otf
/system/fonts/NotoSansSC-Light.otf
/system/fonts/NotoSansSC-Thin.otf
/system/fonts/Roboto-Black.ttf
/system/fonts/Roboto-BlackItalic.ttf
/system/fonts/Roboto-Bold.ttf
/system/fonts/Roboto-BoldItalic.ttf
/system/fonts/Roboto-Italic.ttf
/system/fonts/Roboto-Light.ttf
/system/fonts/Roboto-LightItalic.ttf
/system/fonts/Roboto-Medium.ttf
/system/fonts/Roboto-MediumItalic.ttf
/system/fonts/Roboto-Regular.ttf
/system/fonts/Roboto-Thin.ttf
/system/fonts/Roboto-ThinItalic.ttf
/system/fonts/RobotoCondensed-Bold.ttf
/system/fonts/RobotoCondensed-BoldItalic.ttf
/system/fonts/RobotoCondensed-Italic.ttf
/system/fonts/RobotoCondensed-Light.ttf
/system/fonts/RobotoCondensed-LightItalic.ttf
/system/fonts/RobotoCondensed-Regular.ttf
/system/etc/fonts.xml
"

##########################################################################################
# Permissions
##########################################################################################

set_permissions() {
  # Only some special files require specific permissions
  # The default permissions should be good enough for most cases

  # Here are some examples for the set_perm functions:

  # set_perm_recursive  <dirname>                <owner> <group> <dirpermission> <filepermission> <contexts> (default: u:object_r:system_file:s0)
  # set_perm_recursive  $MODPATH/system/lib       0       0       0755            0644

  # set_perm  <filename>                         <owner> <group> <permission> <contexts> (default: u:object_r:system_file:s0)
  # set_perm  $MODPATH/system/bin/app_process32   0       2000    0755         u:object_r:zygote_exec:s0
  # set_perm  $MODPATH/system/bin/dex2oat         0       2000    0755         u:object_r:dex2oat_exec:s0
  # set_perm  $MODPATH/system/lib/libart.so       0       0       0644

  # The following is default permissions, DO NOT remove
  set_perm_recursive  $MODPATH  0  0  0755  0644
}

##########################################################################################
# Custom Functions
##########################################################################################

# This file (config.sh) will be sourced by the main flash script after util_functions.sh
# If you need custom logic, please add them here as functions, and call these functions in
# update-binary. Refrain from adding code directly into update-binary, as it will make it
# difficult for you to migrate your modules to newer template versions.
# Make update-binary as clean as possible, try to only do function calls in it.

