MODDIR=${0%/*}
PROPS="$(awk -F'=' '!/^#/ && NF > 0 {print $1}' $MODDIR/system.prop)"

wait_until_login() {
    # in case of /data encryption is disabled
    while [ "$(getprop sys.boot_completed)" != "1" ]; do
        sleep 1
    done

    # in case of the user unlocked the screen
    until [ -d "/data/data/android" ]; do
        sleep 1
    done
}

grep_prop() {
    local REGEX="s/^$1=//p"
    shift
    local FILES=$@
    FILES='/dev/allprop.prop'
    cat $FILES 2>/dev/null | dos2unix | sed -n "$REGEX" | head -n 1
}

after_boot() {
    wait_until_login
    magiskpolicy --live "allow system_server * * *"
    for prop in $PROPS; do
        resetprop -p --delete "$prop"
    done
    device_config delete activity_manager max_cached_processes
    device_config delete activity_manager max_phantom_processes
    device_config delete netd_native happy_eyeballs_enable
    device_config delete netd_native parallel_lookup
    device_config delete netd_native sort_nameservers
    device_config delete runtime_native_boot enable_uffd_gc_2
    device_config delete runtime_native_boot disable_lock_profiling
    device_config delete lmkd_native use_minfree_levels
    device_config set_sync_disabled_for_tests none
    pm clear com.xiaomi.joyose
    pm enable com.xiaomi.joyose/com.xiaomi.joyose.cloud.CloudServerReceiver
    pm install-existing --user 0 com.mediatek.duraspeed
    am broadcast com.xiaomi.joyose/com.xiaomi.joyose.JoyoseBroadCastReceiver
    settings delete global settings_enable_monitor_phantom_procs
}

after_boot &
