MODDIR=${0%/*}
TMPDIR="/dev/mount_lib"

if [ -f /system_ext/lib64/libmigui.so ]; then
    if [ "$(getprop ro.hardware)" == "qcom" ]; then
        insmod $MODDIR/modules/perfmgr.ko
        mkdir -p $TMPDIR

        sed 's?ro.product.product.name?ro.product.prodcut.name?' \
            /system_ext/lib64/libmigui.so \
            >$TMPDIR/libmigui.so
        mount --bind "$TMPDIR/libmigui.so" "/system_ext/lib64/libmigui.so"

        restorecon /system_ext/lib64/libmigui.so
        resetprop ro.product.prodcut.name socrates_cn
    fi
fi

MODULE_DIR="/sys/module"
[ ! -d "$MODULE_DIR/zram" ] && insmod $MODDIR/modules/zram.ko
if [ "$(getprop ro.hardware)" != "qcom" ]; then
    insmod $MODDIR/modules/cpufreq_sugov_ext.ko
    insmod $MODDIR/modules/scheduler.ko
    insmod $MODDIR/modules/mtk_core_ctl.ko
    insmod $MODDIR/modules/mtk_fpsgo.ko
    insmod $MODDIR/modules/task_turbo.ko
    insmod /vendor_dlkm/lib/modules/fpsgo.ko
    insmod /vendor/lib/modules/msync2_frd.ko
    /system/bin/modprobe -d /vendor/lib/modules -b --all=/vendor/lib/modules/modules.load
fi

chcon "u:object_r:lmkd_exec:s0" "$MODDIR/system/bin/lmkd"
