MODDIR=${0%/*}

# $1:value $2:path
lock_val() {
    if [ -f "$2" ]; then
        umount "$2"
        chown root:root "$2"
        chmod 0666 "$2"
        echo "$1" >"$2"
        chmod 0444 "$2"
        restorecon -R -F "$2"
    fi
}

# $1:value $2:path
mask_val() {
    if [ -f "$2" ]; then
        umount "$2"
        chown root:root "$2"
        chmod 0666 "$2"
        echo "$1" >"$2"
        chmod 0444 "$2"
        restorecon -R -F "$2"

        TIME="$(date "+%s%N")"
        touch "/dev/mount_masks/mount_mask_$TIME"
        echo "$1" >"/dev/mount_masks/mount_mask_$TIME"
        mount --bind "/dev/mount_masks/mount_mask_$TIME" "$2"
        restorecon -R -F "$2"
    fi
}

wait_until_login() {
    # in case of /data encryption is disabled
    while [ "$(getprop sys.boot_completed)" != "1" ]; do
        sleep 1
    done

    # in case of the user unlocked the screen
    until [ -d "/data/data/android" ]; do
        sleep 1
    done
}


init_node_qcom() {
    mask_val "0-3" /dev/cpuset/system-background/cpus

    BUS_DIR="/sys/devices/system/cpu/bus_dcvs"
    for d in $(ls $BUS_DIR); do
        [ ! -f $BUS_DIR/$d/hw_max_freq ] && continue
        MAX_FREQ=$(cat $BUS_DIR/$d/hw_max_freq)
        MIN_FREQ=$(cat $BUS_DIR/$d/hw_min_freq)
        [ "$d" == "DDRQOS" ] && lock_val "$MAX_FREQ" "$BUS_DIR/$d/boost_freq"

        for df in $(ls $BUS_DIR/$d); do
            lock_val "$MAX_FREQ" "$BUS_DIR/$d/$df/max_freq"
        done
    done

    MIN_PWRLVL=$(($(cat /sys/class/kgsl/kgsl-3d0/num_pwrlevels) - 1))
    lock_val "$MIN_PWRLVL" /sys/class/kgsl/kgsl-3d0/default_pwrlevel
    lock_val "$MIN_PWRLVL" /sys/class/kgsl/kgsl-3d0/min_pwrlevel
    lock_val "0" /sys/class/kgsl/kgsl-3d0/max_pwrlevel
    lock_val "0" /sys/class/kgsl/kgsl-3d0/thermal_pwrlevel
    lock_val "0" /sys/class/kgsl/kgsl-3d0/throttling
}


gen_teg_config_sql() {
    GEN_JSON="$MODDIR/config/generated/teg_$1.json"
    {
        printf '{"config_name":"%s","group_name":"%s","with_model":false,"enable":true,"version":%s,"params":' "$1" "$1" "$2"
        cat "$3"
        printf '}'
    } >"$GEN_JSON"

    compact_json "$GEN_JSON"

    {
        printf "insert into rules\n"
        printf "(rule_id, rule_version, rule_module, rule_content) values "
        printf "(2147483646, 2147483646, '%s', CAST(readfile('%s') AS TEXT));\n" "$1" "$GEN_JSON"
        printf "select changes();\n"
    } >>"$MODDIR/config/generated/joyose_teg.sql"
}

gen_joyose_sql() {
    GEN_JSON="$MODDIR/config/generated/smartp_$1.json"
    cp -af "$3" "$GEN_JSON"
    compact_json "$GEN_JSON"

    {
        printf "insert into cloud_config(config_name, group_name, enable, version, with_model, params) values ('%s', '%s', 1, '%s', 0, CAST(readfile('%s') AS TEXT));\n" "$1" "$1" "$2" "$GEN_JSON"
        printf "select changes();\n"
    } >>"$MODDIR/config/generated/joyose_cloud.sql"
}

init_joyose_config() {
    JOY_CFG="/data/data/com.xiaomi.joyose/databases/SmartP.db"
    TEG_CFG="/data/data/com.xiaomi.joyose/databases/teg_config.db"
    [ ! -f $JOY_CFG ] && return

    exec_system "am force-stop com.xiaomi.joyose"
    rm -rf "$MODDIR/config/generated"
    mkdir "$MODDIR/config/generated"
    "$MODDIR/bin/sqlite3" $JOY_CFG ".read $MODDIR/config/cloud_config.sql"
    "$MODDIR/bin/sqlite3" $TEG_CFG ".read $MODDIR/config/teg_rules.sql"
    COMMON_VERSION="2024010101"
    BOOSTER_VERSION="2036010101"
    COMMON_JSON="$MODDIR/config/common_config.json"
    DEVICE="$(getprop ro.product.device)"
    if [ -f "$MODDIR/config/booster_config_$DEVICE.json" ]; then
        BOOSTER_JSON="$MODDIR/config/booster_config_$DEVICE.json"
    elif [ "$(getprop ro.hardware)" == "qcom" ]; then
        BOOSTER_JSON="$MODDIR/config/booster_config_qti.json"
    else
        BOOSTER_JSON="$MODDIR/config/booster_config_mtk.json"
    fi
    gen_teg_config_sql "common_config" "$COMMON_VERSION" "$COMMON_JSON"
    gen_teg_config_sql "booster_config" "$BOOSTER_VERSION" "$BOOSTER_JSON"
    gen_joyose_sql "common_config" "$COMMON_VERSION" "$COMMON_JSON"
    gen_joyose_sql "booster_config" "$BOOSTER_VERSION" "$BOOSTER_JSON"
    "$MODDIR/bin/sqlite3" $TEG_CFG ".read $MODDIR/config/generated/joyose_teg.sql"
    "$MODDIR/bin/sqlite3" $JOY_CFG ".read $MODDIR/config/generated/joyose_cloud.sql"

    exec_system "pm disable com.xiaomi.joyose/com.xiaomi.joyose.cloud.CloudServerReceiver"
    exec_system "am broadcast -a android.intent.action.BOOT_COMPLETED -p com.xiaomi.joyose"
}

init_xiaomi_config() {
    am force-stop com.xiaomi.trustservice
    pm uninstall --user 0 com.xiaomi.trustservice

    mask_val "1" /proc/package/stat/pause_mode
    lock_val "0" /sys/module/metis/parameters/cluaff_control
    lock_val "0" /sys/module/metis/parameters/mi_fboost_enable
    lock_val "0" /sys/module/metis/parameters/mi_freq_enable
    lock_val "0" /sys/module/metis/parameters/mi_link_enable
    lock_val "0" /sys/module/metis/parameters/mi_switch_enable
    lock_val "0" /sys/module/metis/parameters/mi_viptask
    lock_val "0" /sys/module/metis/parameters/mpc_fboost_enable
    lock_val "0" /sys/module/metis/parameters/vip_link_enable

    for cpu in $(seq 0 7); do
        lock_val "cpu$cpu 2147483647" /sys/class/thermal/thermal_message/cpu_limits
    done
    mask_val "" /sys/class/thermal/thermal_message/cpu_limits
    lock_val "0" /sys/class/thermal/thermal_message/flash_state
    lock_val "0" /sys/class/thermal/thermal_message/market_download_limit
    lock_val "0" /sys/class/thermal/thermal_message/modem_level
    lock_val "0" /sys/class/thermal/thermal_message/modem_limit
    lock_val "0" /sys/class/thermal/thermal_message/modem_rate
    lock_val "0" /sys/class/thermal/thermal_message/poor_modem_limit
    lock_val "0" /sys/class/thermal/thermal_message/temp_state
    lock_val "0" /sys/class/thermal/thermal_message/torch_level
    lock_val "0" /sys/class/thermal/thermal_message/torch_real_level
    lock_val "0" /sys/class/thermal/thermal_message/wifi_limit

    settings put system miui_app_cache_optimization 0
    init_joyose_config
}

init_brand_specific_config() {
    BRAND="$(getprop ro.product.brand)"
    if [ $BRAND == "OnePlus" ]; then
        init_oplus_config
    elif [ $BRAND == "Xiaomi" ] || [ $BRAND == "Redmi" ]; then
        init_xiaomi_config
    fi
}

init_android_config() {
    device_config set_sync_disabled_for_tests until_reboot
    device_config put activity_manager max_cached_processes 65535
    device_config put activity_manager max_phantom_processes 65535
    device_config put netd_native happy_eyeballs_enable true
    device_config put netd_native parallel_lookup true
    device_config put netd_native sort_nameservers true
    device_config put runtime_native_boot disable_lock_profiling true
    device_config put lmkd_native use_minfree_levels false
    device_config delete lmkd_native thrashing_limit_critical
    device_config put activity_manager use_compaction false

    settings put global settings_enable_monitor_phantom_procs false
}

if [ -f /data/adb/ksud ]; then
    /data/adb/ksud sepolicy patch "allow system_server * * *"
else
    magisk --sqlite "insert or replace into settings values ('mnt_ns', 0)"
    magiskpolicy --live "allow system_server * * *"
fi
mkdir -p /dev/mount_masks

wait_until_login
init_android_config
init_platform_config
init_brand_specific_config
init_zram
