set_perm_recursive $MODPATH 0 0 0755 0644
set_perm $MODPATH/bin/sqlite3 0 0 0755
chcon u:object_r:lmkd_exec:s0 "$MODPATH/system/bin/lmkd"
chcon -R "u:object_r:vendor_configs_file:s0" "$MODPATH/system/vendor/etc/"
chown root:shell "$MODPATH/system/bin/lmkd"
chmod 755 "$MODPATH/system/bin/lmkd"

if [ -f /data/adb/ksud ]; then
    /data/adb/ksud sepolicy patch "allow system_server * * *"
else
    magiskpolicy --live "allow system_server * * *"
    magisk --sqlite "insert or replace into settings values ('mnt_ns', 0)"
fi

BRAND="$(getprop ro.product.brand)"
if [ $BRAND == "OnePlus" ]; then
    cat $MODPATH/coloros.prop >>$MODPATH/system.prop
elif [ $BRAND == "Xiaomi" ] || [ $BRAND == "Redmi" ]; then
    cat $MODPATH/miui.prop >>$MODPATH/system.prop
fi
rm -rf $MODPATH/coloros.prop $MODPATH/miui.prop

if [ "$(getprop ro.hardware)" == "qcom" ]; then
    rm -rf $MODPATH/config/booster_config_6985.json $MODPATH/system/vendor/etc/powercontable.xml
    rm -rf $MODPATH/modules/perfmgr_mtk.ko $MODPATH/modules/cpufreq_sugov_ext.ko
    rm -rf $MODPATH/modules/scheduler.ko $MODPATH/modules/task_turbo.ko
    rm -rf $MODPATH/modules/mtk_fpsgo.ko $MODPATH/modules/mtk_core_ctl.ko
    rm -rf $MODPATH/modules/task_turbo.ko $MODPATH/system/vendor/etc/powerscntbl.xml
else
    rm -rf $MODPATH/modules/perfmgr.ko $MODPATH/config/booster_config_8550.json
    rm -rf $MODPATH/system/vendor/etc/perf
fi

if [ ! -f /system_ext/lib64/libmigui.so ]; then
    rm -rf $MODPATH/modules/perfmgr.ko $MODPATH/modules/perfmgr_mtk.ko $MODPATH/config/
fi

device_config put activity_manager max_cached_processes 65535
device_config put activity_manager max_phantom_processes 65535

OVERLAY_IMAGE_EXTRA=0     # number of kb need to be added to overlay.img
OVERLAY_IMAGE_SHRINK=true # shrink overlay.img or not?

if [ -f "/data/adb/modules/magisk_overlayfs/util_functions.sh" ] &&
    /data/adb/modules/magisk_overlayfs/overlayfs_system --test; then
    ui_print "- Add support for overlayfs"
    . /data/adb/modules/magisk_overlayfs/util_functions.sh
    support_overlayfs
    rm -rf "$MODPATH"/system
fi
