#!/system/bin/sh
MODDIR=${0%/*}
app="$MODDIR/bin/alist"

version1=$(curl -s https://api.github.com/repos/alist-org/alist/releases/latest | grep tag_name | cut -d '"' -f 4 | sed 's/^v//')
version2=$(bin/alist version | grep "Version" | sed -n '2p' | awk '{print $2}' | sed 's/^v//')

case `uname -m` in
aarch64)
  os=arm64;;
x86_64)
  os=amd64;;
armhf)
  os=arm;;
i*86)
  os=386;;
esac

down() {
url=$(curl -s https://api.github.com/repos/alist-org/alist/releases/latest | grep http | cut -d '"' -f 4|grep alist-android-"$os".tar.gz)
rm -r $app
curl -o $MODDIR/alist-android-"$os".tar.gz "https://github.moeyy.xyz/$url"
tar -xvzf alist-android-"$os".tar.gz
rm -r alist-android-"$os".tar.gz
mv alist "$MODDIR/bin/"
test $(stat -c "%a" "$app") != "777" && chmod 777 "$app"
echo "更新完成,无需重启"
$MODDIR/stop.sh && $MODDIR/start.sh
}

if [ ! -f $app ]; then
  down
fi

if [ 1 -eq "$(echo "$version1 > $version2" | bc)" ]; then
  echo "开始更新"
  down
  sed -i "s/^description.*/description=用户名:admin 密码:123456 更新请手动执行/data/adb/update.sh 当前版本$version1/" module.prop
else 
  sed -i "s/^description.*/description=用户名:admin 密码:123456 更新请手动执行/data/adb/update.sh 当前版本$version2/" module.prop
fi