#!/system/bin/sh
MODDIR=${0%/*}
MODID=${MODDIR##*/}
START_LOG=$MODDIR/Non.log
LOG=$MODDIR/Noon.log
MODPATH=/data/adb/modules/sleep
BUSYBOXDIR=$MODPATH/busybox
#SD=/data/media/0/Android/
SD=/cache/magisk.log
function JISHU0(){
if [[ ! -f $START_LOG ]]; then
    echo 0 >$START_LOG
fi
 }
 
 function JISHU1(){
if [[ ! -f $START_LOG ]]; then
    echo 1 >$START_LOG
fi
 }
 
function Statistics() {
    if [[ ! -f $LOG ]]; then
        echo "1" >$LOG
    else
        Noon=`cat $LOG`
        p="$(expr $Noon + 1)"
        echo "$p" >$LOG
    fi
}

#墓碑app名单
mbapp(){
cat  ${0%/*}/墓碑名单.conf | sed '/^[[:space:]]*$/d;/^#/d'
}
stopapp(){
cat  ${0%/*}/退后台名单.conf | sed '/^[[:space:]]*$/d;/^#/d'
}

#电池白名单
app(){
cat ${0%/*}/黑-白名单.conf | sed '/^[[:space:]]*$/d;/^#/d'
}

function limitlog(){
	local logfile=$1
	local maxsize=$((1024*20))
	filesize=`ls -l $logfile | awk '{ print $5 }'`
	if test $filesize -gt $maxsize ;then
		echo " " > $logfile
	fi
}

function log_key(){
	test ! -e $SD && mkdir -p $SD
	echo -e "\n时间: "$(date +%H:%M:%S)"－电量: "$(dumpsys battery | awk '/level/{print $2}')" "$1" " >> $SD
#	sed -i "/^description=/c description="息屏后台管理：$(date +%H:%M:%S)" "$1" " "$MODPATH/module.prop"
	limitlog $SD
}

function DEEP(){
	#禁用轻度休眠，进入深度休眠
	dumpsys deviceidle enable deep
	dumpsys deviceidle step deep
	dumpsys deviceidle force-idle deep
	log_key "①息屏了🌛进入打盹 $(dumpsys deviceidle get deep) ,强制休眠: $(dumpsys deviceidle get force)"
}

function OFFDEEP(){
	#解锁休眠状态
	dumpsys deviceidle disable
	dumpsys deviceidle unforce
	dumpsys battery reset
	log_key "①亮屏=☀️退出打盹 $(dumpsys deviceidle get deep) ,强制休眠: $(dumpsys deviceidle get force)"
}

function standby(){
#休眠app
#pid=`pgrep -f "$1"`
am set-inactive $1 true 2>/dev/null

}

function mbapps(){
#APP进入墓碑状态
pid=`pgrep -f "$1"`
kill -19 $pid 2>/dev/null
}
function contapps(){
#安卓解开墓碑进程
pid=`pgrep -f "$1"`
kill -18 $pid 2>/dev/null
}

function stopapps(){
#强制停止并断关联
am force-stop $1 2>/dev/null

}

function ST_APP(){

for i in $(stopapp);do 
	standby "$i"
done
	log_key "②息屏进入app待机模式"
}

function MB_SOME_APP(){

for i in $(mbapp);do 
	mbapps "$i"
done
break；
	log_key "③息屏进入墓碑机制🗿᭄️"
}

function WAKE_UP_APP(){
#使得某些app退出休眠状态
for i in $(mbapp);do 
	contapps "$i"
done
	log_key "③亮屏APP退出墓碑机制🎚️"
}

function UI(){
a=`pgrep surfaceflinger`
chrt -p $a
}

function Force_APP(){
#使得某些app进入休眠状态
for i in $(stopapp);do 
	stopapps "$i"
done
	log_key "④名单内app断开关联并退出后台🗡️️"
}

function XP_APP(){
	for i in /data/media/0/Android/息屏执行/*.sh ;do
		$i 2> /dev/null
done
	log_key "⑤已经执行息屏文件夹内所有.sh️️"
}

#执行移出电池优化名单
noDozes=`pm list packages -e | sed "s/package:/-/g"`$noDozes
#dumpsys deviceidle whitelist $noDozes

function MAKE_RESET_WHITE(){
	#清理白名单
	noDozes=`pm list packages -e | sed "s/package:/-/g"`$noDozes
dumpsys deviceidle whitelist $noDozes
	#加入白名单
#	for i in $(app);do dumpsys deviceidle whitelist +$i ;done
}

read_settings() {
[[ -f "$MODDIR/功能设置.ini" ]] && cat $MODDIR/功能设置.ini | awk '!/#/ {print $0}' | sed -n "s/^${1}=//p"
}

times=`read_settings 息屏后延迟多久执行`

function GET_SCREEN(){
	#获取屏幕状态
	dumpsys deviceidle get screen
}
#1如果屏幕关
Numerical=`cat $START_LOG`

if test "$(GET_SCREEN)" = "false" ;then
Statistics
#	if [[ $Numerical -eq 0 ]] && [[ $Noon -eq $times ]] ;then
	if [[ $Noon -eq $times ]] ;then
	status1=`read_settings Doze强制打盹`
if [[ "$status1" == "开" ]];then
  DEEP
fi
	status2=`read_settings 应用待机模式`
if [[ "$status2" == "开" ]];then
  ST_APP
fi
	status3=`read_settings 息屏墓碑模式`
if [[ "$status3" == "开" ]];then
  MB_SOME_APP 2>/dev/null
fi

	status4=`read_settings 清理电池白名单`
if [[ "$status4" == "开" ]];then
  MAKE_RESET_WHITE
fi
    status5=`read_settings 强退后台`
if [[ "$status5" == "开" ]];then
  	Force_APP  
fi		

#if [[ $START_LOG != "" ]];then
    rm -f "$START_LOG"
#fi	
	JISHU1
     fi

else
#1如果屏幕开

	if [[ $Numerical -eq 1 ]];then		
	status1a=`read_settings Doze强制打盹`
if [[ "$status1a" == "开" ]];then
  OFFDEEP
fi
	status3a=`read_settings 息屏墓碑模式`
if [[ "$status3a" == "开" ]];then
  WAKE_UP_APP 2>/dev/null
fi				
	JISHU0
	fi
	
#if [[ $LOG != "" ]];then
    rm -f "$START_LOG"
	rm -f "$LOG" 
#fi		
	
fi
