conf="/data/adb/swap_controller/"
function get_prop() {
  cat $conf/swap.conf | grep -v '^#' | grep "^$1=" | cut -f2 -d '='
}
set_value() {
  if [[ -f $2 ]]; then
    chmod 664 $2 2>/dev/null
    echo $1 > $2
  fi
}

sdk=`getprop ro.system.build.version.sdk`
# 解析配置
swap_enable=$(get_prop swap)
swap_size=$(get_prop swap_size)
swap_priority=$(get_prop swap_priority)
swap_use_loop=$(get_prop swap_use_loop)
zram_enable=$(get_prop zram)
zram_writeback=$(get_prop zram_writeback)
zram_size=$(get_prop zram_size)
swappiness=$(get_prop swappiness)
min_free_kbytes=$(get_prop min_free_kbytes)
extra_free_kbytes=$(get_prop extra_free_kbytes)
comp_algorithm=$(get_prop comp_algorithm)
watermark_scale_factor=$(get_prop watermark_scale_factor)
writeback_size=$(get_prop writeback_size)
memory_control=$(get_prop memory_control)

# 读取配置参数文件

sys_inf=$(head -n 2 $conf/swap.conf)
echo "${sys_inf// /}"
start=$(date "+%m月%d日_%H时%M分")
echo "✔开机时间：$start"
echo "-----------------------------------------------------------------"

  if [[ "$zram_enable" == "true" ]] && [[ "$zram_size" != "" ]]; then
    # 关闭ZRAM
    echo "关闭ZRAM"
    if [[ -f /system/bin/swapon ]]; then
      alias swapon="/system/bin/swapon"
      alias swapoff="/system/bin/swapoff"
      alias mkswap="/system/bin/mkswap"
    elif [[ -f /vendor/bin/swapon ]]; then
      alias swapon="/vendor/bin/swapon"
      alias swapoff="/vendor/bin/swapoff"
      alias mkswap="/vendor/bin/mkswap"
    fi
    if [[ -f /system/bin/dd ]]; then
      alias dd="/system/bin/dd"
    elif [[ -f /vendor/bin/dd ]]; then
      alias dd="/vendor/bin/dd"
    fi
    for i in $(seq 0 40); do
      swapoff /dev/block/zram0 2>/dev/null
      swapoff /dev/block/zram1 2>/dev/null
      swapoff /dev/block/zram2 2>/dev/null
      sleep 1
    done
  fi
    
# 配置其他内容
swapdir="/data"
swapfile="${swapdir}/swapfile"
recreate="${swapdir}/swap_recreate"
MemTotalStr=`cat /proc/meminfo | grep MemTotal`
MemTotalKB=${MemTotalStr:16:8}
loop_save="vtools.swap.loop"
next_loop_path=""

# 获取下一个可用的loop设备
get_next_loop() {
  current_loop=`getprop $loop_save`

  if [[ "$current_loop" != "" ]]; then
    next_loop_path="$current_loop"
    return
  fi
  
  losetup -f >/dev/null 2>&1
  nl=$(losetup -f | egrep -o '[0-9]{1,}' 2>/dev/null)
  if [[ "$nl" != "" ]]; then
    next_loop_path="/dev/block/loop$nl"
    return
  fi

  loop_index=0
  used=`blkid | grep /dev/block/loop`
  for loop in /dev/block/loop*
  do
    if [[ "$loop_index" -gt "0" ]]; then
      if [[ `echo $used | grep /dev/block/loop$loop_index` = "" ]]; then
        next_loop_path="/dev/block/loop$loop_index"
        return
      fi
    fi
    loop_index=`expr $loop_index + 1`
  done

  next_loop_path=""
}

set_swap() {
  echo "-----------------------------------------------------------------"
  
  # 判断是否需要重新创建文件
  if [[ -f ${recreate} ]]; then
    rm -rf ${swapfile}*
    rm -f ${recreate}
    echo "删除已有swapfile"
  fi

  if [[ "$swap_enable" == "true" ]] && ([[ "$swap_size" != "" ]] || [[ -f ${swapfile} ]]); then
    echo "设置Swapfile"
    set_value true /sys/kernel/mm/swap/vma_ra_enabled

    # mkdir -p ${swapdir}

    # 是否已经创建文件
    if [[ ! -f ${swapfile} ]]; then
      echo "创建swapfile"
      dd if=/dev/zero of=${swapfile} bs=1m count=${swap_size} > /dev/null
      chmod 666 ${swapfile} > /dev/null
      chown system:system ${swapfile} > /dev/null
    fi

    # 记录挂载点
    swap_mount=$swapfile

    # 如果需要挂载为回环设备，则先挂载并记录挂载点参数
    if [[ $swap_use_loop == "true" ]]; then
      echo "获取下一个可用回环设备"
      get_next_loop

      if [[ "$next_loop_path" != "" ]]; then
        swap_mount=$next_loop_path
      else
        echo '所有回环设备都已被占用，SWAP无法完成挂载！' 1>&2
        return
      fi

      # losetup $swap_mount $swapfile # 挂载
      if [[ -e $swap_mount ]]; then
        echo "删除已有回环设备" 
        losetup -d $swap_mount 2>/dev/null
      fi

      echo "初始化swapfile"
      mkswap ${swapfile} >/dev/null

      echo "挂载回环设备 $swap_mount"
      losetup $swap_mount $swapfile

      setprop $loop_save $next_loop_path
    else
      echo "初始化swapfile"
      mkswap ${swap_mount} >/dev/null
    fi

    echo "开启Swapfile"
    # 判断是否自定义优先级
    if [[ "$swap_priority" != "" ]] && [[ "$swap_priority" -gt -1 ]]; then
      swapon ${swap_mount} -p $swap_priority >/dev/null
    else
      swapon ${swap_mount} >/dev/null
    fi
  else
    echo "未启用Swapfile"
  fi
}

set_zram() {
  if [[ ! -e /dev/block/zram0 ]]; then
    if [[ -e /sys/class/zram-control ]]; then
      cat /sys/class/zram-control/hot_add
    else
      echo '内核不支持ZRAM!'
      return
    fi
  fi

    if [[ "$zram_enable" == "true" ]] && [[ "$zram_size" != "" ]]; then
    
    echo "设置ZRAM"

    repeat=0
    while [[ $repeat -lt 25 ]]; do
      swapoff /dev/block/zram0 2>/dev/null
      swapoff /dev/block/zram1 2>/dev/null
      repeat=$(($repeat+1))
      sleep 1
    done

    current_disksize=`cat /sys/block/zram0/disksize`
    target_disksize="${zram_size}m"
    # 读取 ZRAM Writeback配置
    backing_dev=''
    bd_path=/sys/block/zram0/backing_dev
    if [[ -f $bd_path ]]; then
      backing_dev=$(cat $bd_path)
    fi
    echo "重置ZRAM"
    swapoff /dev/block/zram0 2>/dev/null
    swapoff /dev/block/zram1 2>/dev/null
    if [[ "$zram_size" == "0" ]]; then
      return
    fi
    set_value 1 /sys/block/zram0/reset
    set_value 8 /sys/block/zram0/max_comp_streams

  if [[ -f $bd_path ]]; then
    # 配置ZRAM Writeback
    if [[ "$zram_writeback" == "true" ]]; then
      # 正常情况，关闭重启zram并不会导致backing_dev设置失效，但保险起见还是恢复配置一次
      echo "内存扩展回写 [开启]"
      if [[ "$backing_dev" != '' ]] && [[ "$backing_dev" != 'none' ]]; then
        set_value "$backing_dev" $bd_path
        set_value 0 /sys/block/zram0/writeback_limit_enable
      fi
      write_open=1
    elif [[ "$zram_writeback" == "false" ]]; then
      # 禁用 ZRAM Writeback
      echo "内存扩展回写 [关闭]"
      rm -rf /data/writeback
      set_value none $bd_path
      set_value 1 /sys/block/zram0/writeback_limit_enable
      set_value 0 /sys/block/zram0/writeback_limit
    else
      # 禁用 ZRAM Writeback
      echo "内存扩展回写 [参数错误]"
      rm -rf /data/writeback
      set_value none $bd_path
      set_value 1 /sys/block/zram0/writeback_limit_enable
      set_value 0 /sys/block/zram0/writeback_limit
    fi
  fi

    # 设置ZRAM压缩方式
    if [[ "$comp_algorithm" != "" ]]; then
      check_result=`cat /sys/block/zram0/comp_algorithm | grep $comp_algorithm`
      if [[ "$check_result" != "" ]]; then
        echo "设置压缩方式 [$comp_algorithm]"
        echo $comp_algorithm > /sys/block/zram0/comp_algorithm
      else
        echo "内核不支持压缩方式 [$comp_algorithm]"
      fi
    fi

    set_value 8 /sys/block/zram0/max_comp_streams

    echo "设置ZRAM大小 [${zram_size}MB]"
    echo $target_disksize > /sys/block/zram0/disksize

    echo "初始化ZRAM"
    mkswap /dev/block/zram0 >/dev/null

    echo "启动ZRAM"
    if [[ "$swap_priority" == "0" ]]; then
      swapon /dev/block/zram0 -p 0 >/dev/null
    else
      swapon /dev/block/zram0 >/dev/null
    fi
  else
    echo "未配置ZRAM（建议开启）"
    sleep 25
  fi
}

set_vm_params() {

  #其他功能
  echo "-----------------------------------------------------------------"
  set_value 0 /proc/sys/vm/watermark_boost_factor
  
  if [[ "$swappiness" != "" ]]; then
    echo "设置swappiness [$swappiness]"
    echo $swappiness > /proc/sys/vm/swappiness
    set_value $swappiness /dev/memcg/memory.swappiness
    set_value $swappiness /dev/memcg/apps/memory.swappiness
    set_value $swappiness /sys/fs/cgroup/memory/apps/memory.swappiness
    set_value $swappiness /sys/fs/cgroup/memory/memory.swappiness
  else
    echo "未配置swappiness"
  fi

  path1='/proc/sys/vm/min_free_kbytes'
  if [[ "$min_free_kbytes" != "" ]]; then
    echo "设置min_free_kbytes [$min_free_kbytes]"
    set_value "$min_free_kbytes" $path1
    resetprop sys.sysctl.min_free_kbytes "$min_free_kbytes"
  else
    echo "未配置min_free_kbytes"
  fi
  
  path2='/proc/sys/vm/extra_free_kbytes'
  if [[ "$extra_free_kbytes" != "" ]]; then
    echo "设置extra_free_kbytes [$extra_free_kbytes]"
    set_value "$extra_free_kbytes" $path2
    resetprop sys.sysctl.extra_free_kbytes "$extra_free_kbytes"
  else
    echo "未配置extra_free_kbytes"
  fi

  if [[ "$watermark_scale_factor" != "" ]]; then
    echo "设置watermark_scale_factor [$watermark_scale_factor]"
    set_value "$watermark_scale_factor" /proc/sys/vm/watermark_scale_factor
  else
    echo "未配置watermark_scale_factor"
  fi

  echo "设置cache"
  set_value 8 /proc/sys/vm/dirty_background_ratio
  set_value 16 /proc/sys/vm/dirty_ratio
  set_value 3000 /proc/sys/vm/dirty_expire_centisecs
  set_value 1500 /proc/sys/vm/dirty_writeback_centisecs
  set_value 100 /proc/sys/vm/vfs_cache_pressure
  
  echo "设置其它vm参数"
  set_value 0 /proc/sys/vm/swap_ratio_enable
  set_value 1 /proc/sys/vm/kswapd_threads
  set_value 0 /sys/module/vmpressure/parameters/allocstall_threshold
  # 每次换入的内存页，可以通过 `getcon PAGESIZE` 查看，一般是4KB
  set_value 0 /proc/sys/vm/page-cluster
  # 专项优化
  set_value 0 /proc/sys/vm/extfrag_threshold
  # 杀死触发oom的那个进程
  set_value 0 /proc/sys/vm/oom_kill_allocating_task
  # 是否打印 oom日志
  set_value 0 /proc/sys/vm/oom_dump_tasks
  # 是否要允许压缩匿名页
  set_value 1 /proc/sys/vm/compact_unevictable_allowed
  # vm 状态更新频率
  set_value 5 /proc/sys/vm/stat_interval
  set_value 10 /proc/sys/vm/overcommit_ratio
  # 是否允许过量使用运存
  set_value 1 /proc/sys/vm/overcommit_memory
  # 触发oom后怎么抛异常
  set_value 0 /proc/sys/vm/panic_on_oom
  # 禁用高通内存回收机制
  set_value 0 /sys/module/process_reclaim/parameters/enable_process_reclaim
}

set_lmk_params() {
  echo "-----------------------------------------------------------------"
  echo "设置lmk参数"

  # MIUI专属优化
  resetprop persist.sys.minfree_6g "16384,20480,32768,131072,262144,384000"
  resetprop persist.sys.minfree_8g "16384,20480,32768,131072,384000,524288"
  resetprop persist.sys.minfree_def "16384,20480,32768,131072,262144,384000"

  lowmemorykiller='/sys/module/lowmemorykiller/parameters'
  # Linux Kernel 4.9 前的内核
  if [[ -d $lowmemorykiller ]]; then
    set_value "4096,5120,8192,32768,65536,96000" $lowmemorykiller/minfree
    set_value 53059 $lowmemorykiller/vmpressure_file_min
    set_value 0 $lowmemorykiller/enable_adaptive_lmk
    set_value 1 $lowmemorykiller/oom_reaper
    set_value 0 /sys/module/lowmemorykiller/parameters/enable_lmk
    echo "设置lmk优化 [旧内核]"

  # Android Q+
  elif [[ $sdk -gt 28 ]]; then
    minfree_levels="4096:1001,5120:1001,8192:1001,32768:1001,65536:1001,96000:1001"
    echo "设置lmk优化 [新内核]"
    until [[ $(getprop service.bootanim.exit) == "1" ]]; do
      sleep 1
    done
    setprop sys.lmk.minfree_levels $minfree_levels
    stop lmkd
    start lmkd
    sleep 3
    setprop sys.lmk.minfree_levels $minfree_levels
  fi
}

dis_mi_reclaim() {
  manufacturer=$(getprop ro.product.vendor.manufacturer)
  ui_mi=$(getprop ro.miui.ui.version.name)
  if [[ "$manufacturer" == "Xiaomi" ]] || [[ "$ui_mi" != "" ]]; then
    echo "设置MIUI内存管理优化 [禁用mi_reclaim和rtmm]"
    setprop ro.lmk.direct_reclaim_pressure 100
    # 禁用 mi_reclaim
    set_value 0 /sys/kernel/mi_reclaim/enable
    # 尝试禁用小米的rtmm
    mi_rtmm=''
    if [[ -d '/d/rtmm' ]]; then
      mi_rtmm=/d/rtmm/reclaim
    elif [[ -d '/sys/kernel/mm/rtmm' ]]; then
      mi_rtmm='/sys/kernel/mm/rtmm'
    else
      return
    fi
    chmod 000 $mi_rtmm/reclaim/auto_reclaim 2>/dev/null
    chown root:root $mi_rtmm/reclaim/auto_reclaim 2>/dev/null
    chmod 000 $mi_rtmm/reclaim/global_reclaim 2>/dev/null
    chown root:root $mi_rtmm/reclaim/global_reclaim 2>/dev/null
    chmod 000 $mi_rtmm/reclaim/proc_reclaim 2>/dev/null
    chown root:root $mi_rtmm/reclaim/proc_reclaim 2>/dev/null
    chmod 000 $mi_rtmm/reclaim/kill 2>/dev/null
    chown root:root $mi_rtmm/reclaim/kill 2>/dev/null
    chown root:root $mi_rtmm/compact/compact_memory 2>/dev/null
  fi
}

dis_cos_reclaim(){
ui1=$(getprop ro.product.brand.ui | tr '[A-Z]' '[a-z]')
ui2=$(getprop ro.product.vendor.manufacturer | tr '[A-Z]' '[a-z]')
  if [[ "$ui1" == "realmeui" ]] || [[ "$ui1" == "coloros" ]] || [[ "$ui2" == "oneplus" ]] || [[ "$ui2" == "realme" ]] || [[ "$ui2" == "oppo" ]] || [[ "$ui2" == "coloros" ]]; then
    echo "设置ColorOS内存管理优化 [防杀后台]"
    setprop persist.vendor.sys.memplus.enable false 
    set_value "0" /sys/module/lowmemorykiller/parameters/batch_kill
    set_value "0" /sys/module/lowmemorykiller/parameters/quick_select
    set_value "0" /sys/module/lowmemorykiller/parameters/time_measure
    set_value "N" /sys/module/lowmemorykiller/parameters/trust_adj_chain
    set_value "0" /proc/sys/vm/memory_plus
    set_value "0" /proc/sys/vm/breath_period
    set_value "-1001" /proc/sys/vm/breath_priority
    set_value "0" /sys/module/memplus_core/parameters/memory_plus_enabled
    set_value "0" /proc/sys/vm/memory_plus
  fi
}

set_zram
set_swap
set_vm_params
dis_mi_reclaim
dis_cos_reclaim
set_lmk_params

# 设置CPU亲和性
lp=$(ps -ef | grep "lmkd" | grep -v "root" | awk '{print $1}')
taskset -p 1 $lp >/dev/null

echo "-----------------------------------------------------------------"

if [[ "$write_open" == "1" ]]; then
echo "[等待]正在开启内存扩展回写..."
MODDIR=${0%/*}
chmod +x $MODDIR/run_write.sh
chmod 777 $MODDIR/run_write.sh
sh $MODDIR/run_write.sh >> $conf/swap.log 2>&1 &
fi