#!/system/bin/sh

# Check Enable
SKIPMOUNT=true
# system.prop
PROPFILE=false
# post-fs-data script
POSTFSDATA=false
# service script
LATESTARTSERVICE=true

# Construct your own list here
REPLACE="
"

# ==============================
ui_print  "*****************************"
ui_print  "挂载分区"
# mount -o remount,rw /
ui_print  "*****************************"
cat $MODPATH/system/vendor/bin/cnss_diag 2> /dev/null
# 设置变量
cleanzdy=1
devices=`getprop ro.product.odm.device`
var_release="`grep_prop ro.*version.release`"
var_version="`grep_prop ro.*version.incremental`"
# ==============================
# 判断是否为官方内核
if cat '/proc/version' | grep "perf" > /dev/null
then
ui_print  "*****************************"
ui_print  "当前内核为:官方内核"
else
ui_print  "*****************************"
ui_print  "当前内核为:第三方内核"
fi
ui_print  "*****************************"
ui_print  "系统版本：$var_version"
ui_print  "设备版本：$var_release"
ui_print  "*****************************"
ui_print  "主要邮箱: OLX_Team@88.com"
ui_print  "Rulong主线维护成员：OLX_新的&分歧"
ui_print  "Rulong主线维护成员：OLX_LY_C"
ui_print  "请务必给予Rulong_Boost (Root权限)"
sleep 2
# ==============================
# getprop ro.boot.veritymode
# ==============================
# 更新日志
sh $MODPATH/update.sh
# ==============================
# 释放文件，普通shell命令
on_install() {
  unzip -o "$ZIPFILE" 'system/*' -d $MODPATH >&2
}
# ==============================
set_permissions() {
  set_perm_recursive $MODPATH 0 0 0755 0755
}
# ==============================
# Get option from zip name if applicable
case $(basename $ZIP) in
  *new*|*New*|*NEW*) NEW=true;;
  *old*|*Old*|*OLD*) NEW=false;;
esac
# ==============================
# Change this path to wherever the keycheck binary is located in your MODPATH
KEYCHECK=$MODPATH/keycheck
chmod 755 $KEYCHECK
# ==============================
keytest() {
ui_print  "----------------------------"
ui_print  "- 音量键测试 -"
ui_print  "请按下 [音量➕] 键"
ui_print  "无反应或传统模式无法正确安装时，请触摸一下屏幕后继续。"
  (/system/bin/getevent -lc 1 2>&1 | /system/bin/grep VOLUME | /system/bin/grep " DOWN" > $MODPATH/events) || return 1
  return 0
}   
# ==============================
choose() {
  #note from chainfire @xda-developers: getevent behaves weird when piped, and busybox grep likes that even less than toolbox/toybox grep
  while true; do
    /system/bin/getevent -lc 1 2>&1 | /system/bin/grep VOLUME | /system/bin/grep " DOWN" > $MODPATH/events
    if (`cat $MODPATH/events 2>/dev/null | /system/bin/grep VOLUME >/dev/null`); then
      break
    fi
  done
  if (`cat $MODPATH/events 2>/dev/null | /system/bin/grep VOLUMEUP >/dev/null`); then
    return 0
  else
    return 1
  fi
}
# ==============================
chooseold() {
  # Calling it first time detects previous input. Calling it second time will do what we want
  $KEYCHECK
  $KEYCHECK
  SEL=$?
  if [ "$1" == "UP" ]; then
    UP=$SEL
  elif [ "$1" == "DOWN" ]; then
    DOWN=$SEL
  elif [ $SEL -eq $UP ]; then
    return 0
  elif [ $SEL -eq $DOWN ]; then
    return 1
  else
		abort "未检测到音量键!"
  fi
}
# ==============================
if [ -z $NEW ]; then
  if keytest; then
    FUNCTION=choose
  else
    FUNCTION=chooseold
ui_print  "----------------------------"
ui_print  "- 检测到遗留设备！使用旧的 keycheck 方案"
ui_print  " "
ui_print  "- 进行音量键录入 -"
ui_print  "录入：请按下 [音量➕] 键："
    $FUNCTION "UP"
ui_print  "已录入 [音量➕] 键。"
ui_print  "录入：请按下 [音量➖] 键："
    $FUNCTION "DOWN"
ui_print  "已录入 [音量➖] 键。"
ui_print  "----------------------------"
  fi
else
ui_print  "----------------------------"
fi
# ==============================
ui_print  " "
ui_print  "是否安装：查杀天御组件？"
ui_print  "音量+ = 安装"
ui_print  "音量- = 不安装"
  if $FUNCTION; then 
    NEW=true
  else 
    NEW=false
  fi
# ==============================
ui_print  " "
if $NEW; then
mv $MODPATH/Beta/clear_tianyu $MODPATH/system/etc/olx.d
ui_print  "已安装查杀天御组件!"
else
ui_print  "不安装查杀天御组件!"
fi
ui_print  " "
# ==============================
if [ -e /system/app/olx/olx.apk ]
then
ui_print  "*****************************"
ui_print  "检测到MiuiCX_Rom"
rm -rf $MODPATH/system/vendor/app/Rulong.version.olx
rm -rf $MODPATH/system/app/Rulong.sqlite.boost
fi
# ==============================
if [[ "$devices" = apollo ]] ; then
ui_print  "*****************************"
ui_print  "机型验证通过..."
else
rm -rf $MODPATH/system/vendor/etc/wifi
fi
# ==============================
msmcore=`cat /proc/cpuinfo | grep SM | sed 's/.*SM//'`
if [[ "$msmcore" = 8250 ]] ; then
ui_print  "检测到Soc:高通骁龙865.正在应用温控..."
else
ui_print  "*****************************"
ui_print  "检测到Soc非:高通骁龙865.不应用温控..."
rm -rf $MODPATH/system/vendor/etc/thermal*.conf
fi
# ==============================
if [[ "$cleanzdy" = 0 ]] ; then 2> /dev/null
ui_print  "*****************************"
ui_print  "本次更新将会清除如龙的自定义修改"
ui_print  "已备份如龙自定义至/内置储存/如龙自定义备份.conf"
cp -r /cache/Rulong/RulongPro/RulongPro.conf /sdcard/如龙自定义备份.conf
rm -rf /sdcard/Rulong/*
rm -rf /cache/Rulong/*
else
ui_print  "*****************************"
ui_print  "本次更新不会清除如龙的自定义修改"
fi
# ==============================
ui_print  "*****************************"
ui_print  "清除缓存"
rm -rf /data/system/package_cache/*
rm -rf $MODPATH/Beta
rm -rf $MODPATH/events
rm -rf $MODPATH/keycheck
rm -rf $MODPATH/update.sh
rm -rf $MODPATH/mod.sh
rm -rf /data/adb/modules/Rulong_ZhuLong/*
# ==============================
rm -rf /data/system/ifw/com.miui.securitycenter.xml
rm -rf /data/adb/modules/Rulong
rm -rf /data/adb/modules/Rulong_ZhuQue
rm -rf /data/adb/modules/Rulong_QingLong

# 设置权限
chmod -R 777 $MODPATH/*
# ==============================
ui_print  "*****************************"
ui_print  "安装完成"
exit 0