#!/system/bin/sh

export PATH=/system/bin:$(magisk --path)/.magisk/busybox:/sbin/.magisk/busybox:$PATH
function correctpath(){
	case `echo "$1"` in
	/system_ext* )
		echo "/system"$1""
	;;
	/system* )
		echo "$1"
	;;
	/vendor* )
		echo "/system"$1""
	;;
	/product* )
		echo "/system"$1""
	;;
	esac
}

find /system/ /system_ext /vendor /product -iname '*thermal*' -type f  2> /dev/null | sed -e '/.*android.*/d' -e '/.*libthermalclient.*/d' -e '/.*map.*\.conf/d' | while read file ;do
file=$(correctpath $file )
test -n $file && {
mkdir -p $MODPATH${file%/*} && touch $MODPATH$file && echo -e "——替换 ${file##/*} 文件大小: $(du -sh $file| awk '{print $1}')"
}
done