#!/system/bin/sh

function show_value() {
	local value=$1
	local file="$MODPATH/配置.prop"
	test ! -f "$file" && file="$MODPATH/配置.conf"
	cat "$file" | grep -E "(^$value=)" | head -n 1 | sed '/^#/d;/^[[:space:]]*$/d;s/.*=//g' | sed 's/，/,/g;s/——/-/g;s/：/:/g'
}

if test "$(show_value 'crond定时更新')" != "是" ;then
	mkdir -p "${MODPATH}/mod"
	cp -rf ${MODPATH}/crond/* "${MODPATH}/mod"
	rm -rf "$MODPATH/crond"
	return 0
fi


#crond配置文件
crond_file="$MODPATH/crond/root"

test ! -d "${crond_file%/*}" && return 0

#模块变量
id="$id"
Magisk_mod=$(grep -w -q 'lite_modules' /data/adb/magisk/util_functions.sh && echo "lite_modules" || echo "modules")
key_MODPATH="/data/adb/$Magisk_mod/$id"

#为每个脚本写入变量和crond配置文件
for i in $MODPATH/crond/*.sh
do
name="${i##*/}"
sed -i "1i #!/system/bin/sh" "$i"
sed -i "2i #@coolapk 1007" "$i"
sed -i "3i MODPATH="${key_MODPATH}"" "$i"
sed -i "4i export PATH=\$MODPATH/busybox:\$PATH" "$i"
cat <<key >> $crond_file
0 6,22 */2 * * $key_MODPATH/crond/$name
key
done




