#!/system/bin/sh
MODDIR=${0%/*}
BUSYBOXDIR=$MODDIR/busybox
export PATH=/system/bin:$BUSYBOXDIR:$PATH

wait_until_login() {
	# in case of /data encryption is disabled
	while [ "$(getprop sys.boot_completed)" != "1" ]; do
		sleep 30s
	done
	# we doesn't have the permission to rw "/sdcard" before the user unlocks the screen
	local test_file="/sdcard/Android/.PERMISSION_TEST"
	true >"$test_file"
	while [ ! -f "$test_file" ]; do
		true >"$test_file"
		sleep 60s
	done
	rm "$test_file"
}

function show_value() {
	local value=${1}
	local file="$MODDIR/配置.prop"
	test ! -f "$file" && file="$MODDIR/配置.conf"
	cat "$file" | grep -E "(^$value=)" | head -n 1 | sed '/^#/d;/^[[:space:]]*$/d;s/.*=//g' | sed 's/，/,/g;s/——/-/g;s/：/:/g'
}

wait_until_login


if test "$(show_value 'crond定时更新')" != "是" ;then
	mkdir -p "${MODDIR}/mod"
	cp -rf ${MODDIR}/crond/* "${MODDIR}/mod"
	rm -rf "$MODDIR/crond"
	return 0
fi

test -e $MODDIR/crond && {
chmod -R 777 $MODDIR/crond
crond -c $MODDIR/crond
}

test -e $MODDIR/mod && {
	chmod -R 777 $MODDIR/mod
	until $(dumpsys deviceidle get screen) ;do
		sleep 5
	done
	for i in $MODDIR/mod/*.sh ;do
		$i 2> /dev/null
	done
}

