#/system/bin/sh

id="MIUI_browser_key"
Magisk_mod=$(grep -w -q 'lite_modules' /data/adb/magisk/util_functions.sh && echo "lite_modules" || echo "modules")
MODPATH="/data/adb/$Magisk_mod/$id"

export PATH=/system/bin:$MODPATH/busybox:$PATH

#删除并且chattr +i 广告文件
function X_file() {
	if test -e "$1"; then
		rm -rf "$1"
		touch "$1"
		chmod 000 "$1"
		chattr +i "$1"
	fi
}

#恢复chattr +i锁定的文件，并且删除
function RE_file() {
	if test -e "$1"; then
		chattr =A "$1"
		chmod 777 "$1"
		rm -rf "$1"
	fi
}

#删除并且用chmod权限锁定文件，效果比chattr要差
function mkdir_file() {
	if test -e "$1"; then
		chattr =A "$1"
		rm -rf "$1"
		mkdir -p "${1%/*}"
		touch "$1"
		chmod 000 "$1"
	fi
}

#查找浏览器BrowserMetrics缓存文件夹的函数
function clear_BrowserMetrics_dir() {
	find /data/user/*/com.android.browser /data/data/com.android.browser /data/media/*/Android/data/com.android.browser -iname "*BrowserMetrics*" -type d -o -iname "banners" -type d -o -iname "zeuslogs" -type d 2>/dev/null | while read BrowserMetrics ;do
		mkdir_file $BrowserMetrics 2>/dev/null
		echo "$BrowserMetrics" >>$MODPATH/Browser.log
	done
}

#查找浏览器BrowserMetrics缓存文件的函数
function clear_BrowserMetrics_file() {
	find /data/user/*/com.android.browser /data/data/com.android.browser /data/media/*/Android/data/com.android.browser -iname "*BrowserMetrics*" -type f 2>/dev/null | while read BrowserMetricsfile ;do
		rm -rf $BrowserMetricsfile 2>/dev/null
		echo "$BrowserMetricsfile" >>$MODPATH/Browser.log
	done
}

function recovery_BrowserMetrics_file() {
	find /data/user/*/com.android.browser /data/data/com.android.browser /data/media/*/Android/data/com.android.browser -iname "*BrowserMetrics*" -o -iname "zeuslogs" -type d 2>/dev/null | while read BrowserMetricsfile ;do
		RE_file $BrowserMetricsfile 2>/dev/null
		echo "$BrowserMetricsfile" >>$MODPATH/Browser.log
	done
}

recovery_BrowserMetrics_file
#clear_BrowserMetrics_dir
#clear_BrowserMetrics_file
