#!/system/bin/sh
#编写作者：@coolapk 10007
#gitee主页https://gitee.com/keytoolazy/mapdepot

id="MIUI_browser_key"
Magisk_mod=$(grep -w -q 'lite_modules' /data/adb/magisk/util_functions.sh && echo "lite_modules" || echo "modules")
MODPATH="/data/adb/$Magisk_mod/$id"

export PATH=/system/bin:$MODPATH/busybox:$PATH

#获取小米浏览器UID
userid="$(dumpsys package com.android.browser | grep userId | uniq | tr -cd '[0-9]' | head -n 1)"
test "$userid" = "" && echo "无法找到浏览器uid" && exit 1

#替换目标文件名称
target_name="miui_businesslist.json"
test "$target_name" = "" && target_name="miui_blacklist.json"

#替换规则文件位置
adbfile="$MODPATH/mod/$target_name"
test ! -f "$adbfile" && echo "找不到 [ $target_name ] 文件！" && exit 1


#设置权限和用户组以及selinux上下文
function set_perm() {
	if test -e "$1" ;then
	chattr -R -i -a "$1" 2>/dev/null
		chown -R $2:$3 $1 || return 1
			chmod -R $4 $1 || return 1
	CON=$5
			test -z $CON && CON=u:object_r:system_file:s0
		chcon -R $CON $1 || return 1
	fi
}

function run_mode_1(){
for file in `ls /data/user/*/com.android.browser/files/data/adblock/$target_name /data/data/com.android.browser/files/data/adblock/$target_name 2>/dev/null `
do
chattr -i "${file}" 2>/dev/null 
	cp -rf "$adbfile" "$file" || {
		chattr -R -i -a "${file%/*}" 
			cp -rf "$adbfile" "$file"
	}
		set_perm "$file" $userid $userid 0755 u:object_r:app_data_file:s0
	chattr +i "$file"
done
}

function run_mode_2(){
for dir in `ls -d /data/user/*/com.android.browser /data/data/com.android.browser 2>/dev/null `
do
target_dir="$dir/files/data/adblock"
file="$target_dir/$target_name"
	mkdir -p "$target_dir" || {
		chattr -R -i -a "${dir}" 
			mkdir -p "$target_dir"
	}
		cp -rf "$adbfile" "$file" || {
			chattr -R -i -a "${dir}" 
				cp -rf "$adbfile" "$file"
	}
		set_perm "$file" $userid $userid 0755 u:object_r:app_data_file:s0
	chattr +i "$file"
done 
}



if test -e "/data/data/com.android.browser/files/data/adblock/$target_name" ;then 
	run_mode_1 && kill -15 $(echo -n `pgrep -f com.android.browser ` ) 2>/dev/null 
else 
	run_mode_2 && kill -15 $( echo -n `pgrep -f com.android.browser ` ) 2>/dev/null 
fi

