#!/bin/sh

id="MIUI_browser_key"
Magisk_mod=$(grep -w -q 'lite_modules' /data/adb/magisk/util_functions.sh && echo "lite_modules" || echo "modules")
MODPATH="/data/adb/$Magisk_mod/$id"

export PATH=/system/bin:$MODPATH/busybox:$PATH


function notification_simulation(){
local title="${2}"
local text="${1}"
if test "$(pm list package | grep -w 'com.google.android.ext.services' )" != "" ;then
	cmd notification allow_assistant 'com.google.android.ext.services/android.ext.services.notification.Assistant'
fi
#local word_count="`echo "${text}" | wc -c`"
#test "${word_count}" -gt "375" && text='文字超出限制，请尽量控制在375个字符！'
	test -z "${title}" && title='10007'
	test -z "${text}" && text='您未给出任何信息'
su -lp 2000 -c "cmd notification post -S messaging --conversation '${title}' --message '${title}':'${text}' 'Tag' '$(echo $RANDOM)' " >/dev/null 2>&1
}

function show_value() {
	local value=${1}
	local file="$MODPATH/配置.prop"
	test ! -f "$file" && file="$MODPATH/配置.conf"
	cat "$file" | grep -E "(^$value=)" | head -n 1 | sed '/^#/d;/^[[:space:]]*$/d;s/.*=//g' | sed 's/，/,/g;s/——/-/g;s/：/:/g'
}

function log_module_running(){
local text="${1}"
local output_flag="${2}"
if test "${2}" = "false" ;then
	echo -e "${1}"
else
	echo -e "${1}"
	#echo -e "${1}" >> "${module_log_file}"
fi
}

function Download_github_raw_link(){
local user_agent="Mozilla/5.0 (Linux; CPU iPhone OS 20_4_1 like Mac OS X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/107.0.0.0 YaBrowser/22.9.3.82.00 SA/3 SearchCraft/2.0.0.0 Mobile Safari/537.36"
local download_target="${1}"
local TMPDIR="${3}"
local file_name="${2}"
test "${file_name}" = "" && file_name="${target##*/}"
test "${TMPDIR}" = "" && TMPDIR="`pwd`"
if test "`ping -c 1 -W 3 raw.githubusercontent.com | grep -qE '127\.0\.0\.1|0\.0\.0\.0|1\.1\.1\.1' || echo 'yes'`" = "yes" ;then
	target="${download_target}"
elif test "`ping -c 1 -W 3 raw.fgit.ml >/dev/null 2>&1 && echo 'yes'`" = "yes" ;then
	target="`echo ${download_target} | sed 's|raw.githubusercontent.com|raw.fgit.ml|g'`"
elif test "`ping -c 1 -W 3 raw.gitmirror.com >/dev/null 2>&1 && echo 'yes'`" = "yes" ;then
	target="`echo ${download_target} | sed 's|raw.githubusercontent.com|raw.gitmirror.com|g'`"
elif test "`ping -c 1 -W 3 raw.iqiq.io >/dev/null 2>&1 && echo 'yes'`" = "yes" ;then
	target="`echo ${download_target} | sed 's|raw.githubusercontent.com|raw.iqiq.io|g'`"
elif test "`ping -c 1 -W 3 raw.fastgit.org >/dev/null 2>&1 && echo 'yes'`" = "yes" ;then
	target="`echo ${download_target} | sed 's|raw.githubusercontent.com|raw.fastgit.org|g'`"
elif test "`ping -c 1 -W 3 ghproxy.com >/dev/null 2>&1 && echo 'yes'`" = "yes" ;then
	target="https://ghproxy.com/${download_target}"
else
	echo "${download_target}" | grep -q 'raw.githubusercontent.com' && log_module_running "[E]`date +'%F %T'` 错误！无法连接网络！" && exit 1
fi

if $(curl -V > /dev/null 2>&1) ; then
	curl --user-agent "${user_agent}" "${target}" -k -L -o "${TMPDIR}/${file_name}" >/dev/null 2>&1 && echo "[I]`date +'%F %T'` ${target} 下载成功！" || log_module_running "[E]`date +'%F %T'` ${target} 下载失败！请自行检查！"
elif $(wget --help > /dev/null 2>&1) ; then
	wget --user-agent "${user_agent}" -c --no-check-certificate "${target}" -O "${TMPDIR}/${file_name}" >/dev/null 2>&1 && echo "[I]`date +'%F %T'` ${target} 下载成功！" || log_module_running "[E]`date +'%F %T'` ${target} 下载失败！请自行检查！"
else
	log_module_running "\n\n[E]`date +'%F %T'` 请先安装Curl命令或者Wegt命令到您的手机上！\n\n" && exit 1
fi
}

#设置权限和用户组以及selinux上下文
function set_perm() {
	if test -e "$1" ;then
	chattr -R -i -a "$1" 2>/dev/null
		chown -R ${2}:${3} "${1}" || return 1
			chmod -R ${4} "${1}" || return 1
	CON="${5}"
			test -z ${CON} && CON=u:object_r:system_file:s0
		chcon -R ${CON} "${1}" || return 1
	fi
}


function check_prop_value(){
for i in system vendor product system_ext oem odm vendor_dlkm odm_dlkm
do
	test "`getprop ${i}.sla.ifaces`" != "" && echo `getprop "${i}.sla.ifaces"` && break
done
}

function get_WiFi_settings_value(){
for i in global system secure 
do
	for o in `settings list "${i}" `
		do
	if test "`echo ${o} | grep -wi 'wifi_on=[0-9]'`" != "" ;then
		settings_value="`echo ${o} | sed 's|=.*||g' `"
		if test "`settings get "${i}" "${settings_value}"`" != "0" ;then
			echo "wlan"
			break
		fi
	fi
	done
done
}

function check_connect_WIFI(){
if test "`check_prop_value`" = "" ;then
#	if test "`get_WiFi_settings_value`" = "" ;then
#		log_module_running "[W]`date +'%F %T'` WIFI开关已经关闭" && exit 0
#	fi
	log_module_running "[W]`date +'%F %T'` 未找到有关的Prop值，该功能已经失效，默认继续任务……"
	return 0
fi
if test "$(echo -n `check_prop_value` | grep 'wlan')" != "" ;then
	log_module_running "[I]`date +'%F %T'` WIFI已连接。"
else
	echo "[W]`date +'%F %T'` 正在使用数据，10秒后复查……"
	sleep 10s
	if test "$(echo -n `check_prop_value` | grep 'wlan')" != "" ;then
		log_module_running "[I]`date +'%F %T'` WIFI已连接。"
	else
		log_module_running "\n[I]`date +'%F %T'` 使用数据中，已自动终止任务！"
		exit 0
	fi
fi
}

function Show_original_Marked_Ads(){
local sqlite_file="${1}"
test ! -f "${sqlite_file}" && return 0
sqlite3 "${sqlite_file}" << EOF
SELECT * FROM rules WHERE host NOT LIKE '';
EOF
}


function get_user_rules(){
local IFS=$'\n'
local sqlite_file="${1}"
test ! -f "${sqlite_file}" && return 0
for i in `Show_original_Marked_Ads "${sqlite_file}" `
do
target_time="`echo ${i} | cut -d'|' -f1`"
target_host="`echo ${i} | cut -d'|' -f2`"
target_rule="`echo ${i} | cut -d'|' -f3`"
target_type="`echo ${i} | cut -d'|' -f4`"
cat << key 
DELETE FROM rules WHERE rule='${target_rule}';  
INSERT INTO rules VALUES('${target_time}', '${target_host}', '${target_rule}', '${target_type}'); 
key
done
}

function add_user_rules(){
local target_file="${2}"
local sqlite_file="${1}"
test ! -f "${sqlite_file}" && return 0
sqlite3 "${sqlite_file}" << EOF
`get_user_rules "${target_file}"`
EOF
}


#检测是否是WIFI
if test -f "${MODPATH}/配置.prop" ;then
	if test "$(show_value '仅在WIFI连接时更新' )" = "是" ;then
		check_connect_WIFI
	fi
fi

Download_github_raw_link "https://raw.githubusercontent.com/lingeringsound/Miui_Browser_enhance/main/sqlite/Marked%20Ads" "Marked Ads" "${0%/*}"

#获取小米浏览器UID
userid="$(dumpsys package com.android.browser | grep userId | uniq | tr -cd '[0-9]' | head -n 1)"
test "$userid" = "" && echo "无法找到浏览器uid" && exit 1

if test -f "${0%/*}/Marked Ads" ;then
for dir in `ls -d /data/user/*/com.android.browser /data/data/com.android.browser 2>/dev/null `
	do
	find "${dir}" -iname "Marked Ads" -type f 2>/dev/null | while read file; do
		add_user_rules "${0%/*}/Marked Ads" "${file}"
		cp -rf "${0%/*}/Marked Ads" "${file}" && notification_simulation "`date +'%F %T' `完成一次广告标记文件更新" "MIUI浏览器增强模块"
	done
	cp -rf "${0%/*}/Marked Ads" "/data/data/com.android.browser/app_miui_webview/Marked Ads"
	set_perm "${file}" ${userid} ${userid} '0755' 'u:object_r:app_data_file:s0'
done
fi

