#!/system/bin/sh

local_host_file=$MODPATH/hosts

id="GGAT_10007"
Magisk_mod=$(grep -w -q 'lite_modules' /data/adb/magisk/util_functions.sh && echo "lite_modules" || echo "modules")
GGAT_10007_MODPATH="/data/adb/$Magisk_mod/$id"

function show_value() {
	local value=$1
	local file="$MODPATH/配置.prop"
	test ! -f "$file" && file="$MODPATH/配置.conf"
	cat "$file" | grep -E "(^$value=)" | head -n 1 | sed '/^#/d;/^[[:space:]]*$/d;s/.*=//g' | sed 's/，/,/g;s/——/-/g;s/：/:/g'
}

if test "$(show_value '修改hosts')" != "是" ;then
	rm -rf "${local_host_file}"
	return 0
fi

test -e "$GGAT_10007_MODPATH" && echo -e "\n- 已安装了 [ 去广告 ]模块，跳过安装hosts。\n" && return 0

test ! -e "$local_host_file" && return 0

function correctpath() {
	case $(echo "$1") in
	/system_ext* | /vendor* | /product*)
		echo "/system"$1""
	;;
	/system*)
		echo "$1"
	;;
	esac
}

function mk_new_file() {
	local file=$1
	local new=$(cat "$file" | sort | uniq)
	echo "$new" > "$file"
}

function grep_host() {
	find /data/adb/modules -type f -iname "hosts" | cut -d'/' -f5 | sort | uniq | grep -v "$id"
}

function combine_host() {
	for o in $(grep_host); do
		for i in $(ls /data/adb/modules); do
			name=$(cat /data/adb/modules/$i/module.prop | grep 'name' | cut -d = -f2)
			author=$(cat /data/adb/modules/$i/module.prop | grep 'author' | cut -d = -f2)
			description=$(cat /data/adb/modules/$i/module.prop | grep 'description' | cut -d = -f2)
			size=$(du -sh /data/adb/modules/$i | sed "s|/data/adb/modules/$i||g")
			if test "$i" = "$o" -a "$i" != "$id" -a ! -e "/data/adb/modules/$i/remove" -a ! -e "/data/adb/modules/$i/disable" ; then
				echo " "
				echo "∞————————————————————————∞"
				echo ""
				echo "－名称：$name"
				echo "－作者：$author"
				echo "－简介：$description"
				echo " "
				echo "－大小：$size"
				echo " "
				echo "－ 该模块含有hosts！"
				echo ""
				test "$value" = "1" && echo "－ 正在合并模块中……"
				test "$value" = "0" && echo "－ 禁用该模块的host……"
				echo ""
				find "/data/adb/modules/$i" -iname "hosts" -type f | while read mod_hostfile; do
				if test "$value" = "1" ;then
					echo "$(cat "$mod_hostfile")" >> $local_host_file
					mv -f "$mod_hostfile" "$mod_hostfile.bak"
				else
					mv -f "$mod_hostfile" "$mod_hostfile.bak"
				fi
			done && echo "－ 完成！"
			echo ""
			echo "∞————————————————————————∞"
			echo " "
		fi
	done
done
}

function mktouch_host() {
find /system/ /system_ext /vendor /product -iname 'hosts' -type f 2> /dev/null | while read hostfile; do
mkdir -p "$MODPATH${hostfile%/*}"
cp -rf $local_host_file "$MODPATH$hostfile"
if test "$value" = "1" ;then
	mk_new_file "$MODPATH$hostfile"
fi
done && rm -rf $local_host_file
}



value='1'
combine_host
mktouch_host

echo ""
echo "∞————————————————————————∞"
echo " "


