#!/system/bin/sh
# Do NOT assume where your module will be located.
# ALWAYS use $MODDIR if you need to know where this script
# and module is placed.
# This will make sure your module will still work
# if Magisk change its mount point in the future
MODDIR=${0%/*}

# This script will be executed in post-fs-data mode
# Set to true if you do *NOT* want Magisk to mount
# any files for you. Most modules would NOT want
# to set this flag to true
SKIPMOUNT=false

# Set to true if you need to load system.prop
PROPFILE=false

# Set to true if you need post-fs-data script
POSTFSDATA=true

# Set to true if you need late_start service script
LATESTARTSERVICE=true

##########################################################################################
# Replace list
##########################################################################################

# List all directories you want to directly replace in the system
# Check the documentations for more info why you would need this
# Construct your list in the following format
# This is an example
REPLACE_EXAMPLE="
/system/priv-app/SystemUI
/system/priv-app/Settings
/system/framework
"

# Construct your own list here
REPLACE="
"
 ui_print "##################"
 ui_print "清理系统缓存"
 ui_print "##################"

rm -rf /data/magisk_backup_*
rm -rf /data/resource-cache/*
rm -rf /data/system/package_cache/*
rm -rf /cache/*
 ui_print "##################"
 ui_print "清理应用缓存"
 ui_print "##################"
rm -rf /data/user/0/com.amap.android.location
rm -rf /data/user/0/com.android.location.fused
rm -rf /data/user/0/com.xiaomi.location.fused
rm -rf /data/user/0/com.xiaomi.metoknlp
rm -rf /data/user/0/com.xiaomi.bsp.gps.nps
rm -rf /data/user_de/0/com.amap.android.location
rm -rf /data/user_de/0/com.android.location.fused
rm -rf /data/user_de/0/com.xiaomi.location.fused
rm -rf /data/user_de/0/com.xiaomi.metoknlp
rm -rf /data/user_de/0/com.xiaomi.bsp.gps.nps
rm -rf /data/misc/profiles/ref
rm -rf /data/vendor/location
rm -rf /data/user/0/com.miui.packageinstaller/*
rm -rf /data/user_de/0/com.miui.packageinstaller/*
rm -rf /data/app/*/com.miui.packageinstaller*
rm -rf /data/app/com.miui.packageinstaller*
rm -rf /data/user/0/com.miui.analytics/*
rm -rf /data/user_de/0/com.miui.analytics/*
rm -rf /data/app/*/com.miui.analytics*
rm -rf /data/app/com.miui.analytics*

