#!/system/bin/sh

function remove_file() {
 if [ -e $1 ] ; then
  file_path=$1
  file_dir=$(dirname $1)
  mod_dir=$(echo "${MODPATH}/${file_dir}/")
  if [ ! -d ${mod_dir} ] ; then
   mkdir -p ${mod_dir}
  fi
  true > ${MODPATH}/${file_path}
 fi
}
ui_print "- Creating blank thermal files."

remove_file "/system/vendor/etc/power_app_cfg.xml"
remove_file "/system/vendor/etc/powercontable.xml"
remove_file "/system/vendor/etc/powerhint.json"
remove_file "/system/vendor/etc/powerscntbl.cfg"
remove_file "/system/vendor/etc/powerscntbl.xml"

remove_file "/system/vendor/etc/perf/perfboostsconfig.xml"
remove_file "/system/vendor/etc/powerhint.xml"

remove_file "/system/app/MiuiDaemon/MiuiDaemon.apk"
remove_file "/system/system_ext/app/MiuiDaemon/MiuiDaemon.apk"
remove_file "/system/app/Joyose/Joyose.apk"

for file in /system/bin/*thermal* ; do
	remove_file ${file}
done
for file in /system/xbin/*thermal* ; do
	remove_file ${file}
done
for file in /system/vendor/bin/*thermal* ; do
    remove_file ${file}
done
for file in /system/system_ext/bin/*thermal* ; do
    remove_file ${file}
done
for file in /system/product/bin/*thermal* ; do
    remove_file ${file}
done
for file in /system/etc/*thermal* ; do
    remove_file ${file}
done
for file in /system/etc/.tp/*thermal* ; do
    remove_file ${file}
done
for file in /system/framework/*thermal* ; do
    remove_file ${file}
done
for file in /system/framework/arm/*thermal* ; do
    remove_file ${file}
done
for file in /system/framework/arm64/*thermal* ; do
    remove_file ${file}
done
for file in /system/framework/oat/arm/*thermal* ; do
    remove_file ${file}
done
for file in /system/framework/oat/arm64/*thermal* ; do
    remove_file ${file}
done
for file in /system/lib/hw/thermal.*.so ; do
    remove_file ${file}
done
for file in /system/lib64/hw/thermal.*.so ; do
    remove_file ${file}
done
for file in /system/lib/thermal.*.so ; do
    remove_file ${file}
done
for file in /system/lib64/thermal.*.so ; do
    remove_file ${file}
done
for file in /system/vendor/etc/*thermal* ; do
    remove_file ${file}
done
for file in /system/vendor/etc/.tp/*thermal* ; do
    remove_file ${file}
done
for file in /system/vendor/etc/thermal/*thermal* ; do
    remove_file ${file}
done
for file in /system/vendor/lib/hw/thermal.*.so ; do
    remove_file ${file}
done
for file in /system/vendor/lib64/hw/thermal.*.so ; do
    remove_file ${file}
done
for file in /system/vendor/lib/thermal.*.so ; do
    remove_file ${file}
done
for file in /system/vendor/lib64/thermal.*.so ; do
    remove_file ${file}
done
for file in /system/vendor/lib/modules/*thermal*.ko ; do
    remove_file ${file}
done
for file in /system/system_ext/etc/horae/horae*.conf ; do
    remove_file ${file}
done
remove_file "/system/system_ext/etc/sys_bad_battery_config.xml"

chmod -R 0000 ${MODPATH}/

ui_print "- Blank files created."

  
  
  