#!/system/bin/sh
MODDIR=${0%/*}

wait_until_login() {
    while [ "$(getprop sys.boot_completed)" != "1" ]; do
        sleep 1
    done
    while [ ! -d "/sdcard/Android" ]; do
        sleep 1
    done
}
wait_until_login

chmod +x $MODDIR/Mly
MODID="$(cat $(dirname "$0")/module.prop | grep "id=" | sed 's/id=//g')"
cp -f "$MODDIR/config/dirac.xml" /data/data/com.miui.misound/shared_prefs/
cp -f "$MODDIR/config/sound_transmit_loopback_mode.xml" /data/data/com.miui.misound/shared_prefs/
cp -f "$MODDIR/config/myprefs.xml" /data/data/com.miui.misound/shared_prefs/
cp -f "$MODDIR/config/com.miui.misound_preferences.xml" /data/data/com.miui.misound/shared_prefs/
am force-stop com.miui.misound
nohup $MODDIR/Mly $MODID > /dev/null 2>&1 &
nohup $MODDIR/Shadow3 $MODDIR/config/shadow3.conf > /dev/null 2>&1 &