#!/sbin/sh
######################
#
# Magisk模块安装脚本
# 编写:酷安@Bugme7
#
######################

# 调试
# ui_print() {
# echo "$1"
# }

# 调试标记
DUBUG_FLAG=false

SKIPMOUNT=false

# 是否加载 system.prop
PROPFILE=true

# 是否执行 post-fs-data 脚本
POSTFSDATA=false

REPLACE=""

# 获取机型
var_device=$(getprop ro.product.device)

# 获取Android 版本
var_version=$(getprop ro.build.version.release)

# 获取MIUI大版本
var_MIUI_version=$(getprop ro.miui.ui.version.name)

# 获取模块版本
module_version="`grep_prop version $TMPDIR/module.prop`"

# 获取模块名称
module_name="`grep_prop name $TMPDIR/module.prop`"

# 获取模块id
module_id="`grep_prop id $TMPDIR/module.prop`"

# 获取模块作者
module_author="`grep_prop author $TMPDIR/module.prop`"

# 获取模块支持的机型
require_version="`grep_prop require_version $TMPDIR/module.prop`"

# 获取模块支持的Android版本
require_device="`grep_prop require_device $TMPDIR/module.prop`"

# 获取模块支持的MIUI大版本
require_MIUI_version="`grep_prop require_MIUI_version $TMPDIR/module.prop`"

run_exit() {
  rm -rf /data/adb/modules/$module_id/
  rm -rf /data/adb/modules_update/$module_id/
  rm -rf /data/system/package_cache/*
  ui_print "- 已退出安装"
  exit 0
}

# 介绍等(无需更改，脚本将会自动从module.prop中获取信息)
print_modname() {
  ui_print "-------------------------------------"
  ui_print "- $module_name "
  ui_print "- 作者: $module_author"
  ui_print "- 版本: $module_version"
  ui_print "-------------------------------------"
  ui_print "- 机型: $var_device"
  ui_print "- Android 版本: $var_version"
}

# 安装脚本
on_install() {
  
  # 检测Android 版本
  if [ -n "$require_version" ]; then
    if [ "$var_version" != "$require_version" ]; then
      ui_print "- 您的Android 版本不支持此模块"
      run_exit # 如果不支持则自动退出安装
    fi
  fi

  # 检测MIUI大版本
  if [ -n "$require_MIUI_version" ]; then
    if [ "$var_MIUI_version" != "$require_MIUI_version" ]; then
      ui_print "- 您的MIUI版本不支持此模块"
      run_exit # 如果不支持则自动退出安装
    fi
  fi

  unzip -o "$ZIPFILE" 'common/*' -d $TMPDIR >&2

  ui_print "- 正在安装..."

  unzip -o "$ZIPFILE" 'system/*' -d $MODPATH >&2
  mkdir -p /data/vendor/voice_model/
  cp -rf $TMPDIR/common/* /data/vendor/voice_model/
  chmod -R 0666 /data/vendor/voice_model/tutu_voice_model.bin 
 
  # 清除缓存
  rm -rf /data/system/package_cache/*
}

# 设置权限
set_permissions() {
  # 普通权限
  set_perm_recursive $MODPATH 0 0 0755 0644
}
