##########################################################################################
#
# Magisk Module Template Config Script
#
##########################################################################################
##########################################################################################
#
# Instructions:
#
# 1. Place your files into system folder (delete the placeholder file)
# 2. Fill in your module's info into module.prop
# 3. Configure the settings in this file (config.sh)
# 4. If you need boot scripts, add them into common/post-fs-data.sh or common/service.sh
# 5. Add your additional or modified system properties into common/system.prop
#
##########################################################################################

##########################################################################################
# Configs
##########################################################################################

# Set to true if you need to enable Magic Mount
# Most mods would like it to be enabled
SKIPMOUNT=false
#是否安装模块后自动关闭，改为faslse，安装后不会自动勾选启用

# Set to true if you need to load system.prop
PROPFILE=false
#是否使用common/system.prop文件

# Set to true if you need post-fs-data script
POSTFSDATA=false
#是否使用post-fs-data脚本执行文件

# Set to true if you need late_start service script
LATESTARTSERVICE=false
#是否在开机时候允许允许common/service.sh中脚本

##########################################################################################
# Installation Message
##########################################################################################

# Set what you want to show when installing your mod

print_modname() {
  ui_print "*******************************"
  ui_print "   王者荣耀开启VT优化  "
  ui_print " 加入CF优化  By 听风辰 "
  ui_print "      By Koolight      "
  ui_print "*******************************"
}

##########################################################################################
# Replace list
##########################################################################################

# List all directories you want to directly replace in the system
# Check the documentations for more info about how Magic Mount works, and why you need this

# This is an example
REPLACE="
/system/app/Youtube
/system/priv-app/SystemUI
/system/priv-app/Settings
/system/framework
"

# Construct your own list here, it will override the example above
# !DO NOT! remove this if you don't need to replace anything, leave it empty as it is now
REPLACE="

"
#添加您要精简的APP/文件夹目录
#例如：精简状态栏，找到状态栏目录为  /system/priv-app/SystemUI/SystemUI.apk     
#转化加入:/system/priv-app/SystemUI
#（可以搭配高级设置获取APP目录）

##########################################################################################
# Permissions
##########################################################################################
#释放文件，普通shell命令
wz=/data/data/com.tencent.tmgp.sgame/shared_prefs
prefs=$wz/com.tencent.tmgp.sgame.v2.playerprefs.xml
CF=$TMPDIR/OpenGLES3Config.xml
CF_Path=$wz/OpenGLES3Config.xml
on_install() {
rm -rf $CF_Path
sleep 0.5
cp -rf $CF $wz
ui_print "- 复制CF优化文件成功"
if [ ! -f "$prefs" ]; then
ui_print "- 未找到王者优化参数文件"
exit;
fi
ui_print "- 开始移除原未优化参数";
sed -i '/.*<int name="VulkanTryCount" value=".*" \/>/'d "$prefs"
sed -i '/.*<int name="EnableVulkan" value=".*" \/>/'d "$prefs"
sed -i '/.*<int name="EnableGLES3" value=".*" \/>/'d "$prefs"
sed -i '/.*<int name="EnableMTR" value=".*" \/>/'d "$prefs"
sed -i '/.*<int name="DisableMTR" value=".*" \/>/'d "$prefs"
sed -i '/.*<int name="sgame_ALL_HighFPS" value=".*" \/>/'d "$prefs"
sed -i '/.*<int name="EnableHWVendorOpt" value=".*" \/>/'d "$prefs"
sed -i '/.*<int name="UnityGraphicsQuality" value=".*" \/>/'d "$prefs"
sed -i '/.*<int name="EnableGPUReport" value=".*" \/>/'d "$prefs"
ui_print "- 开始载入VT优化参数";
sed  -i '2a \ \ \ \ <int name="VulkanTryCount" value="1" \/>' "$prefs";
sed  -i '3a \ \ \ \ <int name="EnableVulkan" value="2" \/>' "$prefs";
sed  -i '4a \ \ \ \ <int name="EnableGLES3" value="3" \/>' "$prefs";
sed  -i '5a \ \ \ \ <int name="EnableMTR" value="1" \/>' "$prefs";
sed  -i '6a \ \ \ \ <int name="DisableMTR" value="3" \/>' "$prefs";
sed -i '7a \ \ \ \ <int name="sgame_ALL_HighFPS" value="1" \/>' "$prefs";
sed -i '8a \ \ \ \ <int name="EnableHWVendorOpt" value="1" \/>' "$prefs";
sed -i '9a \ \ \ \ <int name="UnityGraphicsQuality" value="1" \/>' "$prefs";
sed -i '10a \ \ \ \ <int name="EnableGPUReport" value="2" \/>' "$prefs";
chmod 550 $wz
chmod 440 $prefs
ui_print "- 配置文件权限设置成功"
ui_print "- 开启VT成功"
}

set_permissions() {
  # Only some special files require specific permissions
  # The default permissions should be good enough for most cases

  # Here are some examples for the set_perm functions:

  # set_perm_recursive  <dirname>                <owner> <group> <dirpermission> <filepermission> <contexts> (default: u:object_r:system_file:s0)
  # set_perm_recursive  $MODPATH/system/lib       0       0       0755            0644

  # set_perm  <filename>                         <owner> <group> <permission> <contexts> (default: u:object_r:system_file:s0)
  # set_perm  $MODPATH/system/bin/app_process32   0       2000    0755         u:object_r:zygote_exec:s0
  # set_perm  $MODPATH/system/bin/dex2oat         0       2000    0755         u:object_r:dex2oat_exec:s0
  # set_perm  $MODPATH/system/lib/libart.so       0       0       0644

  # The following is default permissions, DO NOT remove
  set_perm_recursive  $MODPATH  0  0  0755  0644
  
  #设置权限，基本不要去动
}

##########################################################################################
# Custom Functions
##########################################################################################

# This file (config.sh) will be sourced by the main flash script after util_functions.sh
# If you need custom logic, please add them here as functions, and call these functions in
# update-binary. Refrain from adding code directly into update-binary, as it will make it
# difficult for you to migrate your modules to newer template versions.
# Make update-binary as clean as possible, try to only do function calls in it.
