#!/sbin/sh

# List of the driver files
package_list="
OpenGL
Vulkan"

ui_print " ";
ui_print "         ___       __                          ";
ui_print "        /   | ____/ /_______  ____  ____       ";
ui_print "       / /| |/ __  / ___/ _ \/ __ \/ __ \      ";
ui_print "      / ___ / /_/ / /  / ___/ / / / /_/ /      ";
ui_print "     /_/  |_\____/_/   \___/_/ /_/\____/       ";
ui_print "            ______                             ";
ui_print "           /_  __/__  ______________           ";
ui_print "            / / / _ \/ __  / __  __ \          ";
ui_print "           / / / ___/ /_/ / / / / / /          ";
ui_print "          /_/  \___/\____/_/ /_/ /_/           ";
ui_print "     ______                 __                 ";
ui_print "    / ____/______________  / /_  ____________  ";
ui_print "   / / __/ ___/ __  / __ \/ __ \/ / ___/ ___/  ";
ui_print "  / /_/ / /  / /_/ / /_/ / / / / / /__(__  )   ";
ui_print "  \____/_/   \____/ ____/_/ /_/_/\___/____/    ";
ui_print "         ____    /_/                           ";
ui_print "        / __ \________   _____  __________     ";
ui_print "       / / / / ___/ / | / / _ \/ ___/ ___/     ";
ui_print "      / /_/ / /  / /| |/ / ___/ /  (__  )      ";
ui_print "     /_____/_/  /_/ |___/\___/_/  /____/       ";
ui_print "                                               ";   
ui_print " ";
ui_print "***********************************************";
ui_print " Developed by Arda Süzen - Adreno Modding Team ";
ui_print "***********************************************";
ui_print " ";
ui_print " Thanks to";
ui_print " ";
ui_print "  Adreno Modding Team members";
ui_print " ";
ui_print "  heindrix and his drivers";
ui_print " ";
ui_print "  ayandebnath and his FlameGApps project";
ui_print " ";
ui_print "  D1stRU3TOR and his Seshstation kernel";
ui_print " ";
ui_print "  Kyliekyler and his MAGNETAR project";
ui_print " ";
ui_print "  k1ks and his NFS INJECTOR project";
ui_print " ";
ui_print "  FeraVolt and his FDE.AI project";
ui_print " ";
ui_print "  All my friends who contributed to the ";
ui_print "  development of the project and many others...";
ui_print " ";
ui_print "***********************************************";
ui_print " ";
ui_print " Preparing Adreno Team Installer";
ui_print " ";

PROPFILES="$SYSTEM/build.prop $SYSTEM/vendor/build.prop $MODPATH/adreno.prop"

get_file_prop() {
  grep -m1 "^$2=" "$1" | cut -d= -f2
}

get_prop() {
  #check known .prop files using get_file_prop
  for f in $PROPFILES; do
    if [ -e "$f" ]; then
      prop="$(get_file_prop "$f" "$1")"
      if [ -n "$prop" ]; then
        break #if an entry has been found, break out of the loop
      fi
    fi
  done
  #if prop is still empty; try to use recovery's built-in getprop method; otherwise output current result
  if [ -z "$prop" ]; then
    getprop "$1" | cut -c1-
  else
    printf "$prop"
  fi
}

# Get ROM, Device & Package information
adreno_android="$(get_prop "ro.adreno.android")"
adreno_sdk="$(get_prop "ro.adreno.sdk")"
adreno_arch="$(get_prop "ro.adreno.arch")"
adreno_soc="$(get_prop "ro.adreno.soc")"
adreno_series="$(get_prop "ro.adreno.series")"
edition_type="$(get_prop "ro.adreno.edition")"
package_version="$(get_prop "ro.adreno.version")"
opengl_version="$(get_prop "ro.adreno.opengl")"
vulkan_version="$(get_prop "ro.adreno.vulkan")"
rom_version="$(get_prop "ro.build.version.release")"
rom_sdk="$(get_prop "ro.build.version.sdk")"
device_architecture="$(get_prop "ro.product.cpu.abilist")"
board_soc="$(get_prop "ro.product.board")"
platform_soc="$(get_prop "ro.board.platform")"

if [ -z "$device_architecture" ]; then
  device_architecture="$(get_prop "ro.product.cpu.abi")"
fi;

case "$device_architecture" in
  *x86_64*) arch="x86_64"
    ;;
  *x86*) arch="x86"
    ;;
  *arm64*) arch="arm64"
    ;;
  *armeabi*) arch="arm"
    ;;
  *) arch="unknown"
    ;;
esac

# Prepare msgs
wrong_version="! Wrong Android Version Detected"
wrong_arch="! Wrong Device Architecture Detected"
pkg_details="! This Package is For Android: $adreno_android Only"
rom_ver_info="Your ROM is Android: $rom_version"
pkg_details_arch="! This Package is For Device: $adreno_arch Only"
edition_detection_failed="! Failed to detect Adreno Edition type"
wrong_soc="! This Package is For Device Platform: $adreno_soc Only"

sleep 1;
ui_print "- Android: $rom_version, SDK: $rom_sdk, ARCH: $arch";
sleep 1;
ui_print " ";
ui_print " Attention! You should always use the correct Device Platform SOC for install Adreno Team Graphics Drivers.";

if [ "$rom_sdk" -lt "$adreno_sdk" ]; then
  ui_print " ";
  ui_print "                    WARNING                    ";
  ui_print " ";
  ui_print "$wrong_version ";
  sleep 0.5;
  ui_print "$pkg_details ";
  sleep 0.5;
  ui_print "$rom_ver_info ";
  sleep 0.5;
  ui_print " ";
  ui_print "              Installation Failed              ";
  ui_print " ";
  abort;
fi;

if [ ! "$arch" = "$adreno_arch" ]; then
  ui_print " ";
  ui_print "                    WARNING                    ";
  ui_print " ";
  ui_print "$wrong_arch ";
  sleep 0.5;
  ui_print "$pkg_details_arch ";
  sleep 0.5;
  ui_print "Your Device is: $arch ";
  sleep 0.5;
  ui_print " ";
  ui_print "              Installation Failed              ";
  ui_print " ";
  abort;
fi;

if [ ! "$platform_soc" = "$adreno_soc" ]; then
  ui_print " ";
  ui_print "                    WARNING                    ";
  ui_print " ";
  ui_print "$wrong_soc ";
  sleep 0.5;
  ui_print "Your Device is: $platform_soc ";
  sleep 0.5;
  ui_print " ";
  ui_print "              Installation Failed              ";
  ui_print " ";
  abort;
fi;

sleep 1;
ui_print " ";
ui_print "- Adreno VER    : $adreno_android";
ui_print "- Adreno SDK    : $adreno_sdk";
ui_print "- Adreno ARCH   : $adreno_arch";
ui_print "- Adreno SOC    : $adreno_soc";
ui_print " ";
ui_print "- Adreno Series : $adreno_series";
ui_print "- Edition type  : $edition_type";
ui_print "- Package VER   : $package_version";
ui_print "  ";
ui_print "- OpenGL VER    : $opengl_version";
ui_print "- Vulkan VER    : $vulkan_version";
ui_print "  ";
ui_print "- ROM VER       : $rom_version";
ui_print "- ROM SDK       : $rom_sdk";
ui_print "- Device ARCH   : $device_architecture";
ui_print "- Board SOC     : $board_soc";
ui_print "- Platform SOC  : $platform_soc";
ui_print " ";
ui_print "***********************************************"
sleep 1;

ui_print " ";
if [ "$edition_type" = "OpenGL and Vulkan" ]; then
  ui_print "- Preparing OpenGL and Vulkan (AIO) package";
  sleep 1.5;
elif [ "$edition_type" = "OpenGL" ]; then
  ui_print "- Preparing OpenGL package";
  sleep 1.5;
elif [ "$edition_type" = "OpenGL lite" ]; then
  ui_print "- Preparing OpenGL lite package";
  sleep 1.5;
elif [ "$edition_type" = "Vulkan" ]; then
  ui_print "- Preparing Vulkan package";
  sleep 1.5;
else
  # Abort the installation if the installer failed to detect edition type
  ui_print "                    WARNING                    ";
  ui_print " ";
  sleep 0.5;
  ui_print "$edition_detection_failed";
  sleep 0.5;
  ui_print " ";
  ui_print "              Installation Failed              ";
  abort;
fi;

ui_print " "

for g in $package_list; do
    ui_print "- Installing $g";
    tar -xf "$MODPATH/tar_adreno/$g.tar.xz" -C $MODPATH;
    rm -f $MODPATH/tar_adreno/$g.tar.xz
done;

# Clean shader caches
ui_print " ";
ui_print "- Cleaning OpenGL and Vulkan shader caches";
sleep 1.5;
for i in "$(find /data -type f -name '*shader*')"; do
  rm -f $i
done;
