#!/bin/sh

#>> Sunshine.Toolbox

TeamS=${0%/*}
chmod -R 755 "$TeamS"

# in case of /data encryption is disabled
While() {
	[ "$(getprop sys.boot_completed)" != 1 ] && {
		sleep 15s
		While
	}
}
While

#Use system interpreter
alias orien=">/dev/null 2>&1"
Arrax=($(dumpsys display | grep 'DisplayModeRecord' | sed 's/[[:space:]]//g' | sed 's/,/ /g' | awk '{print $2}' | cut -f2 -d '='))
fxmax=${Arrax[0]}
for I in ${!Arrax[@]}; do
	if [[ $fxmax -le ${Arrax[${I}]} ]]; then
		fxmax="${Arrax[${I}]}"
	fi
done

Arran=($(dumpsys display | grep 'DisplayModeRecord' | awk -F 'fps=' '{print $2}' | sed 's/[.]/ /g' | awk '{print $1}'))
fsmax=${Arran[0]}
for x in ${!Arran[@]}; do
	if [[ $fsmax -le ${Arran[${x}]} ]]; then
		fsmax="${Arran[${x}]}"
	fi
done

i=0
dumpsys display | grep -A 1 'mSupportedModesByDisplay' | tail -1 | tr "}" "\n" | cut -f2 -d '{' | while read TeamS; do
	if [ -n "$TeamS" ]; then
		echo "$TeamS" | tr "," "\n" | while read TeamS2s; do
			case "$TeamS2s" in
			"width="*)
				Display="$(echo ${TeamS2s:6})"
				[ "$Display" = "$fxmax" ] && {
					echo "$TeamS" | tr "," "\n" | while read TeamS3s; do
						case "$TeamS3s" in
						"fps="*)
							Frate="$(echo ${TeamS3s:4} | cut -f1 -d '.')"
							[ "$Frate" = "$fsmax" ] && {
								echo "- 锁定档位 $i\n- 帧率信息 $Frate\n- 屏幕尺寸 $Display"
								echo "[ $(date +'%Y-%m-%d %H:%M:%S') ] 设备屏幕分辨率 $Display 屏幕帧率 $Frate"
								orien service call SurfaceFlinger 1035 i64 "$i"
							}
							;;
						esac
					done
				}
				;;
			esac
		done
		i=$((i + 1))
	fi
done
