# 读取配置参数文件
echo "---------------------------------------------------------------------------"
#设置变量
if [[ -f /system/bin/swapon ]]; then
  alias swapon="/system/bin/swapon"
  alias swapoff="/system/bin/swapoff"
  alias mkswap="/system/bin/mkswap"
elif [[ -f /vendor/bin/swapon ]]; then
  alias swapon="/vendor/bin/swapon"
  alias swapoff="/vendor/bin/swapoff"
  alias mkswap="/vendor/bin/mkswap"
fi
#全局变量
huanchen=${0%/*}
huanchen=${huanchen//\/main_program/}
get_prop() {
  grep -v '^#' < "$huanchen"/swap/swap.conf | grep "^$1=" | cut -f2 -d '='
}
set_value() {
  if [[ -f "$2" ]]; then
    chmod 666 "$2" &> /dev/null
    echo "$1" > "$2"
    chmod 664 "$2" &> /dev/null
  fi
}
# 解析配置
zram_enable=$(get_prop zram)
swappiness=$(get_prop swappiness)
comp_algorithm=$(get_prop comp_algorithm)
watermark_scale_factor=$(get_prop watermark_scale_factor)
easter_egg=$(get_prop zram_size)
set_zram() {
  if [[ ! -e /dev/block/zram0 ]]; then
    if [[ -e /sys/class/zram-control ]]; then
      echo "内核支持ZRAM"
    else
      echo "内核不支持ZRAM"
      return
    fi
  fi
  #获取物理运存大小，并自动配置zram
  zram_size_out=$(grep 'MemTotal' < /proc/meminfo | tr -cd "0-9")
  #请根据你手机物理内存大小更改
  #直接更改前面的”15“”11“等就行
  if [[ $zram_size_out -gt 11000000 ]]; then
    zram_size_in=14
  elif [[ $zram_size_out -gt 7000000 ]]; then
    zram_size_in=10
  elif [[ $zram_size_out -gt 5000000 ]]; then
    zram_size_in=8
  else
    zram_size_in=6
  fi
  zram_size=$(awk 'BEGIN{print '$zram_size_in'*(1024^3)}')
  if [[ $zram_enable == "true" ]] && [[ $zram_size != "" ]]; then
    echo "设置ZRAM"
    echo "重置ZRAM"
    for z in /dev/block/zram*; do
      swapoff "$z" &> /dev/null
    done
    if [[ $zram_size == "0" ]]; then
      return
    fi
    # 禁用系统回写
    set_value none /sys/block/zram0/backing_dev
    #    set_value 1 /sys/block/zram0/writeback_limit_enable
    #    set_value 0 /sys/block/zram0/writeback_limit
    #重置zram
    set_value 1 /sys/block/zram0/reset
    #zram限制
    set_value 0 /sys/block/zram0/mem_limit
    #自动设置压缩线程
    max_comp_stream=$(cat /sys/block/zram0/max_comp_streams)
    max_comp_streams=$((max_comp_stream + 2))
    set_value $max_comp_streams /sys/block/zram0/max_comp_streams
    echo "设置压缩模式 $comp_algorithm"
    echo "$comp_algorithm" > /sys/class/block/zram0/comp_algorithm
    echo "设置ZRAM大小 [$zram_size]"
    echo "$zram_size" > /sys/block/zram0/disksize
    echo "初始化ZRAM"
    mkswap /dev/block/zram0 &> /dev/null
    echo "启动ZRAM"
    swapon /dev/block/zram0 &> /dev/null
  else
    echo "未配置ZRAM（建议开启）"
    sleep 10
  fi
}
set_vm_params() {
  echo "---------------------------------------------------------------------------"
  if [[ $swappiness != "" ]]; then
    echo "设置swappiness [$swappiness]"
    echo "$swappiness" > /proc/sys/vm/swappiness
    set_value "$swappiness" /dev/memcg/memory.swappiness
    set_value "$swappiness" /dev/memcg/apps/memory.swappiness
    set_value "$swappiness" /sys/fs/cgroup/memory/apps/memory.swappiness
    set_value "$swappiness" /sys/fs/cgroup/memory/memory.swappiness
  else
    echo "未配置swappiness"
  fi
  if [[ $watermark_scale_factor != "" ]]; then
    echo "设置watermark_scale_factor [$watermark_scale_factor]"
    echo "$watermark_scale_factor" > /proc/sys/vm/watermark_scale_factor
  else
    echo "未配置watermark_scale_factor"
  fi
  echo "设置cache"
  set_value 10 /proc/sys/vm/dirty_background_ratio
  set_value 80 /proc/sys/vm/dirty_ratio
  set_value 2000 /proc/sys/vm/dirty_expire_centisecs
  set_value 300 /proc/sys/vm/dirty_writeback_centisecs
  set_value 150 /proc/sys/vm/vfs_cache_pressure
  echo "设置其它vm参数"
  # 杀死触发oom的那个进程
  set_value 1 /proc/sys/vm/oom_kill_allocating_task
  # 是否打印 oom日志
  set_value 0 /proc/sys/vm/oom_dump_tasks
  # 是否要允许压缩匿名页
  set_value 1 /proc/sys/vm/compact_unevictable_allowed
  # io调试开关
  set_value 0 /proc/sys/vm/block_dump
  # vm 状态更新频率
  set_value 20 /proc/sys/vm/stat_interval
  # 是否允许过量使用运存
  #  set_value 200 /proc/sys/vm/overcommit_ratio
  set_value 1 /proc/sys/vm/overcommit_memory
  # 触发oom后怎么抛异常
  set_value 0 /proc/sys/vm/panic_on_oom
  #压缩内存节省空间（会导致kswap0异常）
  #  set_value 1 /proc/sys/vm/compact_memory
  #watermark_boost_factor用于优化内存外碎片化
  #  set_value 100 /proc/sys/vm/watermark_boost_factor
  #参数越小越倾向于进行内存规整，越大越不容易进行内存规整。
  #  set_value 400 /proc/sys/vm/extfrag_threshold
  # 禁用高通内存回收机制（ppr）
  set_value 0 /sys/module/process_reclaim/parameters/enable_process_reclaim
  # 禁用 mi_reclaim
  set_value 0 /sys/kernel/mi_reclaim/enable
}
lmk_page_cluster() {
  if [[ $comp_algorithm == "zstd" ]]; then
    # 每次换入的内存页.
    set_value 0 /proc/sys/vm/page-cluster
  fi
  if [[ $comp_algorithm != "zstd" ]]; then
    # 每次换入的内存页.
    set_value 1 /proc/sys/vm/page-cluster
  fi
}
lmk_parameter_setting() {
  # for MIUI 12
  version_12=$(getprop ro.build.version.incremental | cut -c1-3)
  if [[ $version_12 = "V12" ]]; then
    resetprop persist.sys.minfree_6g 1024,1025,1026,1027,1028,1029
    resetprop persist.sys.minfree_8g 1024,1025,1026,1027,1028,1029
    resetprop persist.sys.minfree_12g 1024,1025,1026,1027,1028,1029
    resetprop persist.sys.minfree_def 1024,1025,1026,1027,1028,1029
    echo "MIUI12专属优化完成"
  fi
  sdk=$(getprop ro.system.build.version.sdk)
  lowmemorykiller="/sys/module/lowmemorykiller/parameters"
  # Linux Kernel 4.9 前的内核
  if [[ -d $lowmemorykiller ]]; then
    set_value 1024,1025,1026,1027,1028,1029 $lowmemorykiller/minfree
    set_value 13631488 $lowmemorykiller/vmpressure_file_min
    set_value 0 $lowmemorykiller/enable_adaptive_lmk
    set_value 0 $lowmemorykiller/oom_reaper
    echo "设置lmk优化（旧内核）"
  # Android Q+
  elif [[ $sdk -gt 28 ]]; then
    minfree_levels=1024:1001,1025:1001,1026:1001,1027:1001,1028:1001,1029:1001
    resetprop sys.lmk.minfree_levels $minfree_levels
    stop lmkd
    start lmkd
    resetprop sys.lmk.minfree_levels $minfree_levels
    echo "设置lmk优化（新内核）"
  fi
}
io_parameter_setting() {
  for io in /sys/block/sd*; do
    #    io2=$(echo "$io" | sed 's/\/sys\/block\///g')
    set_value deadline "$io"/queue/scheduler
    set_value 256 "$io"/queue/read_ahead_kb
    set_value 64 "$io"/queue/nr_requests
    set_value 2 "$io"/queue/rq_affinity
  done
  echo "io调度优化完成"
}
lru_gen_on() {
  if [[ -f /sys/kernel/mm/lru_gen/enabled ]]; then
    set_value y /sys/kernel/mm/lru_gen/enabled
    echo "成功开启multi-gen LRU"
  fi
}
easter_eggs() {
  if [[ $easter_egg != "none" ]] && [[ $easter_egg != "焕晨" ]]; then
    echo "都说了自动配置zram为什么还要自己改呢"
  fi
  if [[ $easter_egg != "none" ]] && [[ $easter_egg == "焕晨" ]]; then
    echo "焕晨老大了，你的手机可能承受不住哦，手机会被我塞满的"
  fi
}
set_kswap_task() {
  cpus=$(nproc)
  if [[ $cpus == "8" ]]; then
    #绑定进程
    kswapd_cpus=11110000
    mask=$(echo "obase=16;$((2#$kswapd_cpus))" | bc)
    for i in $(pgrep kswapd); do
      taskset -p "$mask" "$i" &> /dev/null
      renice "-8" -p "$i" &> /dev/null
    done
    echo "设置kswapd线程成功"
    kswapd_cpusd=00001111
    maskd=$(echo "obase=16;$((2#$kswapd_cpusd))" | bc)
    for a in $(pgrep oom_reaper); do
      taskset -p "$maskd" "$a" &> /dev/null
      renice "-6" -p "$a" &> /dev/null
    done
    echo "设置oom_reaper线程成功"
    for b in $(pgrep lmkd); do
      taskset -p "$maskd" "$b" &> /dev/null
      renice "-6" -p "$b" &> /dev/null
    done
    echo "设置lmkd线程成功"
  fi
  echo "---------------------------------------------------------------------------"
}
#最后还是放弃这个功能吧
#stop_services() {
#  #  来自newbing
#  #  是MTK平台自研的AEE系统机制1。
#  #  AEE是用于侦测Android手机系统异常重启的一套系统机制.
#  stop aee.log-1-1
#  #  记录充电的？
#  stop charge_logger
#  #  写入日志的。
#  stop connsyslogger
#  #  未知，看样子是日志
#  stop emdlogger
#  #  真的不知道了
#  stop mcd_service
#  stop mi_ic
#  stop mi_ric_file
#  stop mi_ric_init
#  stop mi_ric_run
#  stop mimd-service
#  stop minetd
#  #  小米用户态
#  stop miuibooster
#  #  mobile_log_d是一个日志服务，它是Android系统的核心服务之一，由logd守护进程提供支持。
#  stop mobile_log_d
#  stop oplus_kevents
#  #  vendor.msm_irqbalance是一个用于优化中断分配的服务，
#  stop vendor.msm_irqbalance
#  #  用于实现vendor和system分区之间的通信。
#  stop vendor.xiaomi.hidl.minet
#  stop vendor.xiaomi.hidl.miwill
#  #  调试工具
#  stop vendor_tcpdump
#  #  用于传递电量提示并报告子系统休眠状态指标的累积数据
#  stop power-hal-1-0 && start power-hal-1-0
#  if [ "$(getprop ro.hardware)" != "qcom" ]; then
#    #调试工具
#    stop vendor.miperf
#  fi
#
#  #  start iorapd
#  echo "成功处理无用服务"
#}
#定位（勿删）
set_zram
easter_eggs
set_vm_params
lmk_page_cluster
lmk_parameter_setting
io_parameter_setting
lru_gen_on
#stop_services
set_kswap_task
