##########################################################################################
#
# Magisk Module Template Config Script
# by 沉浸人声
#
##########################################################################################
##########################################################################################
#
# Instructions:
#
# 1. Place your files into system folder (delete the placeholder file)
# 2. Fill in your module's info into module.prop
# 3. Configure the settings in this file (config.sh)
# 4. If you need boot scripts, add them into common/post-fs-data.sh or common/service.sh
# 5. Add your additional or modified system properties into common/system.prop
#
##########################################################################################

##########################################################################################
# Configs
##########################################################################################

# Set to true if you need to enable Magic Mount
# Most mods would like it to be enabled
SKIPMOUNT=false

# Set to true if you need to load system.prop
PROPFILE=true

# Set to true if you need post-fs-data script
POSTFSDATA=false

# Set to true if you need late_start service script
LATESTARTSERVICE=false

##########################################################################################
# Installation Message
##########################################################################################

# Set what you want to show when installing your mod

print_modname() {
  ui_print "**************************"
  ui_print "|   Miui哈曼卡顿音质音效   |"
  ui_print "***************************"
  ui_print "|          V2.9           |"
  ui_print "|       By:沉淀人生       |"
  ui_print "|          适配:           |"
  ui_print "|         小米11           |"
  ui_print "|        小米11pro        |"
  ui_print "|       小米11ultra        |"
  ui_print "|    咨询QQ:232128218   |"
  ui_print "**************************"
  ui_print " "
}

##########################################################################################
# Replace list
##########################################################################################

# List all directories you want to directly replace in the system
# Check the documentations for more info about how Magic Mount works, and why you need this

# Construct your own list here, it will override the example above
# !DO NOT! remove this if you don't need to replace anything, leave it empty as it is now
REPLACE="
/system/etc/audio_diag.cfg
/system/etc/audio_effect.conf
/system/vendor/etc/audio_diag.cfg
/system/vendor/etc/audio_effect.conf
/system/vendor/etc/audio_effects.xml
/system/vendor/etc/mixer_paths.xml
/system/vendor/etc/acdbdata/adsp_avs_config.acdb
/system/vendor/etc/acdbdata/Tutu/Tutu_Speaker_cal.acdb
/system/vendor/lib/rfsa/adsp/misound_res_spk.bin
/system/vendor/lib/soundfx/libasphere.so
/system/vendor/lib/soundfx/libaudiopreprocessing.so
/system/vendor/lib/soundfx/libbundlewrapper.so
/system/vendor/lib/soundfx/libdownmix.so
/system/vendor/lib/soundfx/libdseffect.so
/system/vendor/lib/soundfx/libdynproc.so
/system/vendor/lib/soundfx/libeffectproxy.so
/system/vendor/lib/soundfx/libldnhncr.so
/system/vendor/lib/soundfx/libmisoundfx.so
/system/vendor/lib/soundfx/libqcbassboost.so
/system/vendor/lib/soundfx/libqcompostprocbundle.so
/system/vendor/lib/soundfx/libqcomvisualizer.so
/system/vendor/lib/soundfx/libqcomvoiceprocessing.so
/system/vendor/lib/soundfx/libqcreverb.so
/system/vendor/lib/soundfx/libqcvirt.so
/system/vendor/lib/soundfx/libreverbwrapper.so
/system/vendor/lib/soundfx/libshoebox.so
/system/vendor/lib/soundfx/libv4a.so
/system/vendor/lib/soundfx/libvisualizer.so
/system/vendor/lib/soundfx/libvolumelistener.so
/system/vendor/lib64/soundfx/libasphere.so
/system/vendor/lib64/soundfx/libaudiopreprocessing.so
/system/vendor/lib64/soundfx/libbundlewrapper.so
/system/vendor/lib64/soundfx/libdownmix.so
/system/vendor/lib64/soundfx/libdynproc.so
/system/vendor/lib64/soundfx/libeffectproxy.so
/system/vendor/lib64/soundfx/libldnhncr.so
/system/vendor/lib64/soundfx/libmisoundfx.so
/system/vendor/lib64/soundfx/libqcbassboost.so
/system/vendor/lib64/soundfx/libqcompostprocbundle.so
/system/vendor/lib64/soundfx/libqcomvisualizer.so
/system/vendor/lib64/soundfx/libqcomvoiceprocessing.so
/system/vendor/lib64/soundfx/libqcreverb.so
/system/vendor/lib64/soundfx/libqcvirt.so
/system/vendor/lib64/soundfx/libreverbwrapper.so
/system/vendor/lib64/soundfx/libshoebox.so
/system/vendor/lib64/soundfx/libvisualizer.so
/system/vendor/lib64/soundfx/libvolumelistener.so

"

on_install() {
  # The following is the default implementation: extract $ZIPFILE/system to $MODPATH
  # Extend/change the logic to whatever you want
  unzip -o "$ZIPFILE" 'system/*' -d $MODPATH >&2
}

##########################################################################################
# Permissions
##########################################################################################

set_permissions() {
  # Only some special files require specific permissions
  # The default permissions should be good enough for most cases

  # Here are some examples for the set_perm functions:

  # set_perm_recursive  <dirname>                <owner> <group> <dirpermission> <filepermission> <contexts> (default: u:object_r:system_file:s0)
  # set_perm_recursive  $MODPATH$MODPATH/system/lib       0       0       0755            0644

  # set_perm  <filename>                         <owner> <group> <permission> <contexts> (default: u:object_r:system_file:s0)
  # set_perm  $MODPATH$MODPATH/system/bin/app_process32   0       2000    0755         u:object_r:zygote_exec:s0
  # set_perm  $MODPATH$MODPATH/system/bin/dex2oat         0       2000    0755         u:object_r:dex2oat_exec:s0
  # set_perm  $MODPATH$MODPATH/system/lib/libart.so       0       0       0644

  # The following is default permissions, DO NOT remove
  set_perm_recursive  $MODPATH  0  0  0755  0644
  set_perm_recursive  $MODPATH/system/bin  0  2000  0755  0755
}

##########################################################################################
# Custom Functions
##########################################################################################

# This file (config.sh) will be sourced by the main flash script after util_functions.sh
# If you need custom logic, please add them here as functions, and call these functions in
# update-binary. Refrain from adding code directly into update-binary, as it will make it
# difficult for you to migrate your modules to newer template versions.
# Make update-binary as clean as possible, try to only do function calls in it.