#节点保存目录
subDir='节点'

#订阅链接
subLink='此处填订阅地址'

#HTTP代理地址(如果不为空则使用代理IP获取订阅)
http_proxy='157.0.148.53:443'

#mux开关(false关闭/true开启)
mux='false'

#免流Host, 如果不设置则使用节点自带的
repHost='a.189.cn'

#path, 如果不设置则使用节点自带的
repPath=''

#清空 [全局节点] 和 [海内节点] 目录(true开启)
clearNodeDir='true'

#自动复制到全局节点的名称(正则表达式, 多个用|隔开)
globalNodesName=''

#自动复制到海内节点的名称(正则表达式, 多个用|隔开)
cnNodesName=''









[ -z "$subLink" ] && exit
cd "${0%/*}"
../Core/downloadCore.sh "$repHost" 'MLBox' 'Usage'
echo "节点保存目录为: $PWD/$subDir"
echo '所有 节点文件(.ini结尾) 需要复制到 全局节点 或 海内节点 文件夹才可以用'
echo '正在获取节点列表...'
sleep 1
alias 'MLBox=../Core/MLBox'
export http_proxy
nodeBase64=`MLBox -timeout=10 -http="$subLink"`
node=`MLBox -base64="-d $nodeBase64"`
echo "$node" | grep -qE 'vmess|vless' || exec echo '获取节点列表失败'
if [ -n "$subDir" ]; then
	rm -rf "$subDir"
	mkdir "$subDir"
fi
[ "$clearNodeDir" = 'true' ] && rm -f ../海内节点/*.ini ../全局节点/*.ini
i=1
for v2link in $node; do
	v2msg=`MLBox -v2Link="$v2link"`
	eval "$v2msg"
	echo "$ps" | grep -q '/' && ps="${ps//\//-}"
	filePath="${subDir:=$PWD}/${i}_${ps// /_}.ini"
	echo "$v2link" | grep -q '^vless' && protocol='vless' || protocol='vmess'
	echo "protocol=$protocol" >"$filePath"
	echo "mux='$mux'" >>"$filePath"
	echo "$v2msg" | grep -Ev '^host|^sni|^path' >>"$filePath"
	if [ -n "$repHost" ]; then
		host="$repHost"
		sni="$repHost"
	fi
	if [ -n "$repPath" ]; then
		path="$repPath"
	fi
	echo "host='$host'" >>"$filePath"
	echo "sni='$host'" >>"$filePath"
	echo "path='$path'" >>"$filePath"
	echo -E "第$i个节点: ${ps}, 已写入文件: ${i}_${ps// /_}.ini"
	for v in ${v2msg// /_}; do
		unset "${v%=*}"
	done
	i=$((i + 1))
done
if [ -n "$globalNodesName" ]; then
	echo
	for name in `ls "$subDir" | grep -E "$globalNodesName"`; do
		echo "复制 $name 到 全局节点"
		\cp "$subDir/$name" "../全局节点"
	done
fi
if [ -n "$cnNodesName" ]; then
	echo
	for name in `ls "$subDir" | grep -E "$cnNodesName"`; do
		echo "复制 $name 到 海内节点"
		\cp "$subDir/$name" "../海内节点"
	done
fi
