#自带核心默认为linux arm64，大部分安卓机可以运行
#其他系统无法运行则需要重新下载核心


#是否下载体积更小的upx压缩版本，部分系统不支持(1开启)
downloadUPX='1'

#免流Host(该功能暂时关闭)
mlHost='dm.toutiao.com'

#HTTP代理地址
http_proxy=''






aotuGetAbi() {
	abi=`uname -m 2>/dev/null`
	if echo "$abi"|grep -Eq 'i686|i386'; then
		abi="386"
	elif echo "$abi"|grep -Eq 'armv8|aarch64'; then
		abi="arm64"
	elif getprop 2>/dev/null|grep -Eq 'armv8|arm64'; then
		abi="arm64"
	elif getprop 2>/dev/null|grep -Eq 'arm'; then
		abi="arm"
	elif echo "$abi"|grep -Eq 'arm'; then
		abi="arm"
	elif echo "$abi"|grep -q 'mips64'; then
		abi='mips64'
	elif echo "$abi"|grep -q 'mips'; then
		abi='mips'
	else
		abi="amd64"
	fi
}

setDownloadTool() {
	if [ -n "$http_proxy" ]; then
		export http_proxy
	fi
	if type curl; then
		download_tool() {
			curl --header "Proxy-Authorization: Basic dWMxMC43LjE2My4xNDQ6MWY0N2QzZWY1M2IwMzU0NDM0NTFjN2VlNzg3M2ZmMzg=" --header "X-T5-Auth: 1967948331"  --user-agent "curl baiduboxapp" -L -ko $@
		}
	elif type wget; then
		download_tool() {
			wget --header "Proxy-Authorization: Basic dWMxMC43LjE2My4xNDQ6MWY0N2QzZWY1M2IwMzU0NDM0NTFjN2VlNzg3M2ZmMzg=" --header "X-T5-Auth: 1967948331"  --user-agent "curl baiduboxapp" --no-check-certificate -O $@
		}
	else
		return 1
	fi &>/dev/null
}

installDownloadTool() {
	for PM in apt-get yum pacman pkg opkg dnf; do
		type $PM && break
	done &>/dev/null
	$PM -y install wget curl 2>/dev/null
}

testCore() {
	local coreName="$1"
	local helpFlag="$2"
	[ -f "$coreName" ] || return 1
	echo "正在测试${coreName}是否可用..."
	if ./$coreName -h 2>&1 | grep -iv "Unable to Open.*$coreName" | grep -q "$helpFlag"; then
		echo 'OK' >"${coreName}.lock"
	fi 2>/dev/null &
	sleep 2
	if [ -f "/proc/$!/cwd/${coreName}" ]; then  #启动失败
		kill -9 $! 2>&-
		echo "${coreName}启动卡死"
		rm -f "${coreName}.lock"
		return 1
	elif [ -f "${coreName}.lock" ]; then  #启动成功
		echo "${coreName}启动成功"
		return 0
	else  #启动失败
		echo "${coreName}启动失败"
		rm -f "${coreName}.lock"
		return 1
	fi
}

downloadCore() {
	local host="$1"
	local coreName="$2"
	local helpFlag="$3"
	[ "$4" = '1' ] && local upxDir='upx' || local upxDir=''
	testCore "$coreName" "$helpFlag" && return
	if ! type download_tool &>/dev/null && ! setDownloadTool; then
		installDownloadTool
		setDownloadTool || exec echo "系统必须安装curl或者wget命令才可以下载核心！"
	fi
	echo "$coreName($abi)下载中..."
	rm new$coreName 2>/dev/null
	#download_tool new$coreName --header 'Cute: pros.cutebi.flashproxy.cn' http://$host/$coreName/$upxDir/linux_$abi
	download_tool new$coreName http://binary.quicknet.cyou/$coreName/$upxDir/linux_$abi
	chmod 777 new$coreName
	if ./new$coreName -h 2>&1 | grep -iv "Unable to Open.*new$coreName" | grep -q "$helpFlag"; then
		\mv new$coreName $coreName
	fi 2>/dev/null &
	sleep 2
	if [ -f "/proc/$!/cwd/CuteBi" ]; then
		kill -9 $! 2>&-
		echo "$coreName($abi)下载或启动失败"
		if [ "$downloadUPX" = '1' ]; then
			echo "尝试下载非upx压缩的版本"
			downloadUPX='0'
			downloadCore "$host" "$coreName" "$helpFlag"
			return $?
		else
			rm -f "${coreName}.lock"
			return 1
		fi
	elif [ -f "new$coreName" ]; then
		echo "$coreName($abi)下载或启动失败"
		if [ "$abi" = 'arm' ]; then
			abi='arm5'
			echo "尝试下载${abi}的版本"
			downloadCore "$host" "$coreName" "$helpFlag"
			return $?
		elif [ "$abi" = 'mips' -o "$abi" = 'mips64' ]; then
			abi="${abi}le"
			echo "尝试下载${abi}的版本"
			downloadCore "$host" "$coreName" "$helpFlag"
			return $?
		fi
		return 1
	else
		echo 'OK' >"${coreName}.lock"
		echo "$coreName($abi)下载成功"
		return 0
	fi
}

cd "${0%/*}"
[ -f "${2}" -a -f "${2}.lock" ] && exit 0  #exec "如需下载核心请删除 downloadCores.lock 文件"
aotuGetAbi
if [ "$abi" = 'arm' ]; then
	for abi in 'arm' 'arm5'; do
		downloadCore "$1" "$2" "$3" "$downloadUPX" && break
	done
elif echo "$abi" | grep '^mips'; then
	abiPrefix="$abi"
	for mips in 'le' '' 'le_softloat' '_softfloat'; do
		abi="${abiPrefix}${mips}"
		downloadCore "$1" "$2" "$3" "$downloadUPX" && break
	done
else
	downloadCore "$1" "$2" "$3" "$downloadUPX"
fi
