#!/system/bin/sh
MODDIR=${0%/*}
. $MODDIR/script/sdcard_purification_manager_pro_functions.sh
MAGISK_TMP=$(magisk --path 2>/dev/null)
[[ -z $MAGISK_TMP ]] && MAGISK_TMP="/sbin"
if [[ -f "/data/adb/ksud" ]]; then
	Module_Path="/data/adb/modules"
	alias fstrim="$Module_Path/crond_sdcard_purification_manager_pro/bin/busybox fstrim"
	alias crond="$Module_Path/crond_sdcard_purification_manager_pro/bin/busybox crond"
	S=$(/data/adb/ksud -V | awk '/ksud/{gsub("ksud ", ""); print substr($0,1,4)}')
	if [[ $S == "v0.3" ]]; then
		Module_Path="/data/adb/ksu/modules"
		alias fstrim="$Module_Path/crond_sdcard_purification_manager_pro/bin/busybox fstrim"
		alias crond="$Module_Path/crond_sdcard_purification_manager_pro/bin/busybox crond"
	fi
fi
if [[ -f "/data/adb/magisk/magiskboot" ]]; then
	Module_Path="/data/adb/modules"
	alias fstrim="$Module_Path/crond_sdcard_purification_manager_pro/bin/busybox fstrim"
	alias crond="$MAGISK_TMP/.magisk/busybox/crond"
elif [[ -d "/data/adb/lite_modules" ]]; then
	Module_Path="/data/adb/lite_modules"
	alias fstrim="$Module_Path/crond_sdcard_purification_manager_pro/bin/busybox fstrim"
	alias crond="$Module_Path/crond_sdcard_purification_manager_pro/bin/busybox crond"
fi
chmod -R 0777 $MODDIR
chmod -R 0777 $black_and_white_list_path
logd "初始化完成: [initial.sh]"

if [[ -f $MODDIR/script/set_cron.d/root ]]; then
	[[ -f $MODDIR/script/cron.d/root ]] && rm -rf $MODDIR/script/cron.d/root
	crond -c $MODDIR/script/set_cron.d
	crond_root_file=$MODDIR/script/set_cron.d/root
else
	echo "默认: 24H 每隔30分钟运行一次" >$MODDIR/print_set
	echo "SHELL=sh" >$MODDIR/script/cron.d/root
	echo "*/30 * * * *  sh \"$MODDIR/script/Run_clear.sh\"" >>$MODDIR/script/cron.d/root
	crond -c $MODDIR/script/cron.d
	crond_root_file=$MODDIR/script/cron.d/root
fi

sleep 1

if [[ $(pgrep -f "crond_sdcard_purification_manager_pro/script/cron.d" | grep -v grep | wc -l) -ge 1 ]]; then
	basic_Information
	logd "$(cat $MODDIR/print_set)"
	logd "开始运行: [$crond_root_file]"
	logd "======================================================"
elif [[ $(pgrep -f "crond_sdcard_purification_manager_pro/script/set_cron.d" | grep -v grep | wc -l) -ge 1 ]]; then
	basic_Information
	logd "$(cat $MODDIR/print_set)"
	logd "开始运行: [$crond_root_file]"
	logd "======================================================"
else
	basic_Information
	logd "运行失败！"
	exit 1
fi

sh $MODDIR/script/Run_clear_start.sh
