# Magisk 模块脚本配置
# 说明：
# 1. 将你要替换的文件放入 system 文件夹 (删除 placeholder 文件)
# 2. 将模块信息写入 module.prop
# 3. 在这个文件中进行设置 (customize.sh)
# 4. 如果你需要在启动时执行命令, 请把它们加入 post-fs-data.sh 或 service.sh
# 5. 如果需要修改系统属性(build.prop), 请把它加入 system.prop

# 如果你需要启用 Magic Mount 请把它设置为 true 不启用则设置为 false
# 大多数模块都需要启用它
AUTOMOUNT=true

SKIPMOUNT=false
#是否安装模块后自动关闭，改为false，安装后不会自动勾选启用

# Set to true if you need to load system.prop
PROPFILE=false
#是否使用system.prop文件

# Set to true if you need post-fs-data script
POSTFSDATA=false
#是否使用post-fs-data脚本执行文件

# Set to true if you need late_start service script
LATESTARTSERVICE=true
#是否在开机时候允许加载service.sh中脚本


# 列出你想在系统中直接删除的所有路径 一行一个路径 只能文件夹 不能文件 并且只能system里面的文件夹
# 此命令会删除下列路径文件夹内的所有文件
# /system/SuiNian666/ 只是一个例子 如果你要删除其他路径 请删除那一行例子
REPLACE="
"

# 这个文件 (customize.sh) 将被安装脚本在 util_functions.sh 之后 source 化（设置为环境变量）
# 如果你需要自定义操作, 请在这里以函数方式定义它们 然后在 update-binary 里调用这些函数
# 不要直接向 update-binary 添加代码 因为这会让你很难将模块迁移到新的模板版本
# 尽量不要对 update-binary 文件做其他修改 尽量只在其中执行函数调用
## 执行模块安装
#安装模块时打印的信息，不需要的部分可以自己删除，也可以自己添加。
print_modname() {
ui_print "
 ****************************
 - 模块: $MODNAME
 - 模块ID: $MODID
 - 作者: 淘宝小二
 ****************************
 "
}

#开始安装（shell命令）
on_install() {
ui_print "_______________"
    ui_print "  ※ 模块安装 ※"
    ui_print "¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯"
   unzip -o "$ZIPFILE" 'tool/*' -d $MODPATH >&2
   mv $MODPATH/tool/1.sh $MODPATH/1.sh
   set_perm_recursive  $MODPATH  0  0  0777  0777
   Extract="$MODPATH/tool/vendor_boot"
[[ ! -d "$Extract" ]] && mkdir -p "$Extract"
IMG=""
IFS=$'\n'
SLOT=`cat /proc/cmdline | tr '[:space:]' '\n' | sed -rn 's/androidboot.slot.{0,7}=//p'`
if [[ -n "$SLOT" ]]; then
        ui_print "- 当前使用的分区：$SLOT"
        case $SLOT in
            _a)
                IMG="/dev/block/bootdevice/by-name/vendor_boot_a"  
                Extract="$MODPATH/tool/vendor_boot/vendor_boot.img"
                
            ;;
            _b)
                IMG="/dev/block/bootdevice/by-name/vendor_boot_b"  
                Extract="$MODPATH/tool/vendor_boot/vendor_boot.img"
        esac
fi

for i in $IMG; do
    e=${i##*/}
    File="$Extract"
    [[ ! -L $i ]] && abort "！$e分区不存在无法提取"
    ui_print "- 开始提取$e分区…………"
    dd if="$i" of="$File"
    ui_print "- 已提取$e分区到：$File"
done
}

#设置权限
set_permissions() {
set_perm_recursive  $MODPATH  0  0  0777  0777
}