#!/system/bin/sh
MODDIR=${0%/*}
export PATH=/system/bin:$MODDIR/busybox:$PATH
sleep 5

set_perm() {
	chown $2:$3 $1 || return 1
	chmod $4 $1 || return 1
	CON=$5
	test -z $CON  && CON=u:object_r:system_file:s0
	chcon $CON $1 || return 1
}

set_perm_recursive() {
	find $1 -type d 2> /dev/null | while read dir; do
	set_perm $dir $2 $3 $4 $6
done
	find $1 -type f -o -type l 2> /dev/null | while read file; do
	set_perm $file $2 $3 $5 $6
done
}

chmod -R 777 $MODDIR/keymod/*
chmod -R 755 $MODDIR/scripts/*
chmod -R 777 /data/media/0/Android/data/QQ微信小模块 2> /dev/null

scripts=/data/media/0/Android/QQ微信小模块
file="$MODDIR/scripts"

checkscripts(){
test ! -e $scripts  && mkdir -p $scripts
cp -rf $file/* $scripts
set_perm_recursive  $scripts  9997  9997  0777  0777
}

test ! -e $scripts  && checkscripts 2> /dev/null



if test -e $MODDIR/keymod/AK ;then
chmod -R 777 $MODDIR/keymod/*
crond -c $MODDIR/keymod/A
fi

if test -e $MODDIR/keymod/BK ;then
chmod -R 777 $MODDIR/keymod/*
crond -c $MODDIR/keymod/B
fi

if test -e $MODDIR/keymod/CK ;then
chmod -R 777 $MODDIR/keymod/*
crond -c $MODDIR/keymod/C
fi

if test -e $MODDIR/keymod/DK ;then
chmod -R 777 $MODDIR/keymod/*
crond -c $MODDIR/keymod/D
fi

for i in $MODDIR/keymod/*.sh
do
$i &
done


