MODPATH="/data/adb/modules/WHCHATQQ"
BUSYBOXDIR=$MODPATH/busybox
export PATH=/system/bin:$BUSYBOXDIR:$PATH

mdir="$MODPATH/scripts/cleartrash"

cleaopts(){
	reset
	clear
	echo ""
	echo "☞=======================================☜"
	echo ""
	echo "●——————QQ微信垃圾清理————●"
	echo ""
	echo ""
	echo "1. 清理无关紧要的垃圾"
	echo ""
	echo "2. 查看一些储存占用"
	echo ""
	echo "3. 清理一些敏感项"
	echo ""
	echo "4. 禁用某些软件的开屏广告(如微博、抖音……)"
	echo ""
	echo "5. 回到终端控制器"
	echo ""
	read c1

	if test $c1 == 1;then

		source $mdir/findQMtrash.sh && backopts

	elif test $c1 == 2;then

		source $mdir/clearinfo.sh && backopts

	elif test $c1 == 3;then

		clearscene

	elif test $c1 == 4;then

		adsopt

	elif test $c1 == 5;then

		source $MODPATH/scripts/qw.sh

	elif [ "$c1" != "*[0-9]*" ];then
		reset
		clear
		cleaopts
	fi
}

backopts(){
	echo ""
	echo ""
	echo "∞————————————————————————∞"
	echo ""
	echo ""
	echo "1. 回到QQ微信垃圾清理"
	echo ""
	echo "2. 回到模块终端控制器"
	echo ""
	echo "- 请用键盘输入数字，进行选择"
	echo ""
	read c2
	if test $c2 == 1 ;then
		cleaopts
	elif [ $c2 == 2 ];then
		source $MODPATH/scripts/qw.sh
	elif [ "$c2" != "*[0-9]*" ];then
		reset
		clear
		backopts
	fi
	echo ""
	echo "∞————————————————————————∞"
}

adsopt(){
	clear
	reset
	echo ""
	echo "●——————禁用某些软件的开屏广告————●"
	echo ""
	echo " 注意，此脚本可能会使得有的软件出现bug！"
	echo ""
	echo "1. 禁用"
	echo ""
	echo "2. 恢复文件权限"
	echo ""
	echo "3. 回到菜单"
	echo ""
	read c3
	source $mdir/ad.sh
	if test $c3 == 1 ;then
	echo "请耐心等待！"
		cadsclear && echo "完成！" && sleep 1 && adsopt 
	elif [ $c3 == 2 ];then
	echo "请耐心等待！"
		readclear && echo "完成！" && sleep 1 &&  adsopt
	elif [ $c3 == 3 ];then
		cleaopts
	elif [ "$c3" != "*[0-9]*" ];then
		reset
		clear
		adsopt
	fi
}


clearscene(){
	clear
	reset
	echo ""
	echo "●——————清理一些敏感项————●"
	echo ""
	echo "注意，清理不可逆！请三思而后行！"
	echo ""
	echo "1. QQ微信小程序清理"
	echo ""
	echo "2. 聊天视频清理"
	echo ""
	echo "3. x5相关清理"
	echo ""
	echo "4. QQ聊天图片清理(谨慎，会清理你聊天记录的图片，但是已经保存在手机的不影响。)"
	echo ""
	echo "5. 微信聊天图片清理"
	echo ""
	echo "6. 微信朋友圈视频和图片清理"
	echo ""
	echo "7. 回到菜单"
	echo ""
	read c4
	source $mdir/warning.sh
	if test $c4 == 1 ;then
	echo "请耐心等待！"
		liteappclear && echo "完成！" && sleep 1 && clearscene
	elif [ $c4 == 2 ];then
	echo "请耐心等待！"
		videoclear && echo "完成！" && sleep 1 && clearscene
	elif [ $c4 == 3 ];then
	echo "请耐心等待！"
		x5lear && echo "完成！" && sleep 1 &&  clearscene
	elif [ $c4 == 4 ];then
	echo "请耐心等待！"
		qqchatpicclear && echo "完成！" && sleep 1 && clearscene
	elif [ $c4 == 5 ];then
	echo "请耐心等待！"
		mmchatpicclear && echo "完成！" && sleep 1 && clearscene
	elif [ $c4 == 6 ];then
	echo "请耐心等待！"
		mmpypicclear && echo "完成！" && sleep 1 && clearscene
	elif [ $c4 == 7 ];then
		cleaopts
	elif [ "$c4" != "*[0-9]*" ];then
		reset
		clear
		clearscene
	fi
}
cleaopts


