# Module requires Zygisk to work
SKIPUNZIP=0
isZygiskEnabled=$(magisk --sqlite "SELECT value FROM settings WHERE key='zygisk';")
if [ "$isZygiskEnabled" == "value=0" ] && [ ! -d "/data/adb/modules/zygisksu" ]; then
    abort "! Zygisk没有被启用，请在设置中打开，或者安装ZygiskNext模块(建议使用此模块)或ReZygisk模块" 
fi

# Error on < Android 8
if [ "$API" -lt 26 ]; then
    abort "! 你不能在小于安卓8的设备中安装本模块,建议安卓版本大于等于12"
fi

# safetynet-fix module is obsolete and it's incompatible with PIF
if [ -d "/data/adb/modules/safetynet-fix" ]; then
    touch "/data/adb/modules/safetynet-fix/remove"
    ui_print "! 已移除冲突模块safetynet-fix"
fi

# playcurl must be removed when flashing PIF
if [ -d "/data/adb/modules/playcurl" ]; then
    touch "/data/adb/modules/playcurl/remove"
    ui_print "! 已移除冲突模块playcurl"
fi

# MagiskHidePropsConf module is obsolete in Android 8+ but it shouldn't give issues
if [ -d "/data/adb/modules/MagiskHidePropsConf" ]; then
    ui_print "! 警告，MagiskHidePropsConf模块可能会导致 PIF出现问题."
fi

# 检查自定义设备指纹
if [ -f "/data/adb/pif.json" ]; then
    mv -f "/data/adb/pif.json" "/data/adb/pif.json.old"
    ui_print "- 备份自定义pif.json"
fi
# 添加哈希值提示
ui_print "原模块作者chiteroman"
ui_print "优化芙兰朵布丁(Flander)"
ui_print "过牛头单8/key检测请参考酷安帖子中哈希值教程"
sleep 1
ui_print "*********************************************"
ui_print "- 求关注酷安：芙兰朵布丁"
ui_print "- 请选择是否跳转我的酷安主页"
ui_print "  音量+ ：跳转"
ui_print "  音量- ：取消"
ui_print "*********************************************"
    while true; do
    key_check=$(/system/bin/getevent -qlc 1)
    key_event=$(echo "$key_check" | awk '{ print $3 }' | grep 'KEY_')
    key_status=$(echo "$key_check" | awk '{ print $4 }')
    if [[ "$key_event" == *"KEY_"* && "$key_status" == "DOWN" ]]; then
      keycheck="$key_event"
      break
    fi
    done
  while true; do
    key_check=$(/system/bin/getevent -qlc 1)
    key_event=$(echo "$key_check" | awk '{ print $3 }' | grep 'KEY_')
    key_status=$(echo "$key_check" | awk '{ print $4 }')
    if [[ "$key_event" == *"KEY_"* && "$key_status" == "UP" ]]; then
      break
    fi
    done
case "$keycheck" in "KEY_VOLUMEUP"*)
    ui_print "- 你选择跳转酷安主页"
    ui_print "- 正在跳转酷安主页..."
    sleep 1
    am start -a android.intent.action.VIEW -d coolmarket://www.coolapk.com/u/18881524
    ;;
   *)
    ui_print "- 你选择不跳转酷安主页,哈希值可在service.sh设置"
    ;;
esac