#!/system/bin/sh

output() {
	[ ! -f "$2" ] && return 1
	chmod +w "$2" 2> /dev/null
	if ! echo "$1" > "$2" 2> /dev/null
	then
		echo "- Error: $2 → $1"
		return 1
	fi
		echo "- 成功: $2 → $1"
}

Permission_setting() {
	rm -rf $1
	touch $1
	chmod 000 $1
}

# 处理器调度调整优化
# 此处参数仅限于追求流畅度用户调整
# 小核集群
# echo "500" > /sys/devices/system/cpu/cpufreq/policy0/schedutil/up_rate_limit_us
# echo "20000" > /sys/devices/system/cpu/cpufreq/policy0/schedutil/down_rate_limit_us
# 大核集群
# echo "500" > /sys/devices/system/cpu/cpufreq/policy4/schedutil/up_rate_limit_us
# echo "20000" > /sys/devices/system/cpu/cpufreq/policy4/schedutil/down_rate_limit_us
# 超大核集群
# echo "500" > /sys/devices/system/cpu/cpufreq/policy7/schedutil/up_rate_limit_us
# echo "20000" > /sys/devices/system/cpu/cpufreq/policy7/schedutil/down_rate_limit_us

# 性能模式
# 开启性能模式 (满血模式)
# setprop sys.sptm.gover true
# 关闭性能模式 (默认模式)
# setprop sys.sptm.gover false

# 杂项
# setprop persist.vendor.ssr.enable_ramdumps 0

# F2FS 垃圾回收 (实验性项目,默认使用#号屏蔽,如果想尝鲜可以把#号删除,但可能会带来性能损失以及续航问题.)
# echo "30000" > /sys/fs/f2fs/dm-4/gc_max_sleep_time
# echo "3000" > /sys/fs/f2fs/dm-4/gc_min_sleep_time
# echo "120000" > /sys/fs/f2fs/dm-4/gc_no_gc_sleep_time


# 禁用调度程序统计信息以减少开销
output "0" /proc/sys/kernel/sched_schedstats


# 禁用用户空间向dmesg写入日志
output "off" /proc/sys/kernel/printk_devkmsg


# 禁用磁盘I/O统计 (UFS)
output "0" /sys/block/sda/queue/iostats
output "0" /sys/block/sdb/queue/iostats
output "0" /sys/block/sdc/queue/iostats
output "0" /sys/block/sdd/queue/iostats
output "0" /sys/block/sde/queue/iostats
output "0" /sys/block/sdf/queue/iostats
# 禁用磁盘I/O统计 (eMMC)
output "0" /sys/block/mmcblk0/queue/iostats


# 禁用binder调试
output "0" /sys/module/binder/parameters/debug_mask
output "0" /sys/module/binder_alloc/parameters/debug_mask


# 禁用内核调试
output "0" /sys/module/msm_show_resume_irq/parameters/debug_mask
output "N" /sys/kernel/debug/debug_enabled


# 禁用f2fs I/O数据收集统计
[ -f "/sys/fs/f2fs/sda34/iostat_enable" ] && dm_sda="sda34" || dm_sda="dm-5"
output "0" /sys/fs/f2fs/${dm_sda}/iostat_enable


# 数据分区I/O控制器优化 (UFS)
output "128" /sys/block/sda/queue/read_ahead_kb
output "128" /sys/block/sde/queue/read_ahead_kb
# 数据分区I/O控制器优化 (eMMC)
output "128" /sys/block/mmcblk0/queue/read_ahead_kb
#
output "36" /sys/block/sda/queue/nr_requests
output "128" /sys/block/dm-5/queue/read_ahead_kb


# ZRAM分区参数调整
output "128" /sys/block/zram0/queue/read_ahead_kb


# F2FS MIN FSYNC
[[ -e /sys/fs/f2fs/dm-5/min_fsync_blocks ]] && output "20" /sys/fs/f2fs/dm-5/min_fsync_blocks
# 官改解密data分区ID调整区
output "20" /sys/fs/f2fs/sda34/min_fsync_blocks


# 调整虚拟空间页面集群(禁用交换设备的预读)
output "0" /proc/sys/vm/page-cluster


# 禁用不必要的转储
output "0" /sys/module/subsystem_restart/parameters/enable_ramdumps
# setprop persist.vendor.ssr.enable_ramdumps 0


# 禁用小米程序调试
setprop sys.miui.ndcd off
stop cnss_diag


# 删除不必要的网络日志
if [ -e "/data/vendor/wlan_logs" ]; then
	Permission_setting "/data/vendor/wlan_logs"
fi


# cfq-iosched调整
output "16" /sys/block/sda/queue/iosched/quantum
output "1" /sys/block/sda/queue/iosched/back_seek_penalty


# OOM杀手转储任务
output "0" /proc/sys/vm/oom_dump_tasks


# 禁用sched_autogroup
output "0" /proc/sys/kernel/sched_autogroup_enabled


# 调整脏页写回策略时间
output "3000" /proc/sys/vm/dirty_expire_centisecs


# 调整虚拟内存统计间隔 (默认为1, 也就是1秒)
output "20" /proc/sys/vm/stat_interval

