#!/bin/sh

# 全局常量
let DEFAULTDELAY=6  # 默认检测间隔
let DEFAULTLARGEDELAY=29  # 默认大检测间隔
let DEFAULTTIMESLIMIT=1200  # 计次上限，6x1200=7200秒，2小时

# 全局变量
let delay=${DEFAULTDELAY}
let times_limit=${DEFAULTTIMESLIMIT}
let i=0  # 总计次

writeback(){
 # 获取旧占用大小
 ORIGINADATA=$(cat /sys/block/zram0/bd_stat)
 OLDSIZE=$(echo ${ORIGINADATA} | awk '{print $1}')
 let OLDSIZE=${OLDSIZE}*4/1024
 
 echo "--------"
 echo "[${i}] 检测开始: " `date "+%Y-%m-%d %H:%M:%S"`
 
 j=0  # 分计次
 while [ true ]; do
  let 'j+=1'

  # 检测：剩余内存低于阈值时，触发huge操作
  CATMEMFREE=`cat /proc/meminfo | grep "MemFree:" | sed -r "s/MemFree: +([0-9]+) kB/\1/g"`
  MEMFREE=$(echo ${CATMEMFREE})
  #echo ${MEMFREE}
  CATMEMCACHED=`cat /proc/meminfo | grep "Cached:" | sed -n "1p" | sed -r "s/Cached: +([0-9]+) kB/\1/g"`
  MEMCACHED=$(echo ${CATMEMCACHED})
  #echo ${MEMCACHED}
  let MEMLEFT=${MEMFREE}+${MEMCACHED}
  let MEMLEFT=${MEMLEFT}/1024
  let MEMBASELINE=2458  # 下限：2.4GB
  #echo ${MEMLEFT},${MEMBASELINE}

  if [ ${MEMLEFT} -lt MEMBASELINE -o ${j} -ge ${times_limit} ]; then
   # 内存剩余触及下限 或 计数超过 N次
   echo "--------"
   echo "--[${j}] 内存剩余触及下限, 或计数超时! 剩余${MEMLEFT}MB, 阈值${MEMBASELINE}MB, 写入${1}! 时间: " `date "+%Y-%m-%d %H:%M:%S"`
   echo ${1} > /sys/block/zram0/writeback
   # 临时增大delay
   let delay=${DEFAULTLARGEDELAY}
   break
  fi
  
  sleep ${delay}
 done

 # 统计信息
 # 获取新占用大小、做计算
 NEWDATA=$(cat /sys/block/zram0/bd_stat)
 NEWSIZE=$(echo ${NEWDATA} | awk '{print $1}')
 let NEWSIZE=${NEWSIZE}*4/1024
 echo "原写回: ${OLDSIZE}MB, 新大小：${NEWSIZE}MB"
 #READ=$(echo ${NEWDATA} | awk '{print $2}')
 #WRITE=$(echo ${NEWDATA} | awk '{print $3}')
 #let DIFFSIZE=${NEWSIZE}-${OLDSIZE}
 #let READ=${READ}*4/1024
 #let WRITE=${WRITE}*4/1024
 #echo "原写回: ${OLDSIZE}MB, 新大小：${NEWSIZE}MB, 相差${DIFFSIZE}MB; 总读取: ${READ}MB, 总写入: ${WRITE}MB"
}


# 这里真正开始
echo "生效: " `date "+%Y-%m-%d %H:%M:%S"`
echo all > /sys/block/zram0/idle

while [ true ]; do
 let 'i+=1'

 writeback "idle"
 echo all > /sys/block/zram0/idle
 
 sleep ${delay}
 let delay=${DEFAULTDELAY}  # 在此始终恢复至默认间隔时间
done

wait
date
