#!/system/bin/sh

# 105000表示为修改GPU／DDR温度墙为最大105℃
SET_TRIP_POINT_TEMP_MAX=105000

while [ "$(getprop sys.boot_completed)" != "1" ]; do
	sleep 1
done
MODDIR=${0%/*}
for THERMAL_ZONE in `ls /sys/class/thermal/thermal_zone*/type`; do
	if cat $THERMAL_ZONE | grep -E "gpu|ddr" >/dev/null; then
		for TRIP_POINT_TEMP in `ls ${THERMAL_ZONE%/*}/trip_point_*_temp`; do
			if [ "$(cat $TRIP_POINT_TEMP)" -lt "$SET_TRIP_POINT_TEMP_MAX" ]; then
				echo "$SET_TRIP_POINT_TEMP_MAX" > $TRIP_POINT_TEMP
			fi
		done
	fi
done
sed -i 's/。 --[^,]*$//' ${MODDIR}/module.prop
echo -n "。 --当前修改GPU温度墙为最大$SET_TRIP_POINT_TEMP_MAX！" >> ${MODDIR}/module.prop && sed -i 's/000/℃/' ${MODDIR}/module.prop