#!/system/bin/sh
MODDIR=${0%/*}

wait_until_login() {
    # in case of /data encryption is disabled
    while [ "$(getprop sys.boot_completed)" != "1" ]; do
        sleep 1
    done
    # no need to start before the user unlocks the screen
    local test_file="/sdcard/Android/.LOGIN_PERMISSION_TEST"
    true > "$test_file"
    while [ ! -f "$test_file" ]; do
        true > "$test_file"
        sleep 1
    done
    rm "$test_file"
}
wait_until_login

# keep config
[ ! -f "/data/feas.txt" ] && cp "$MODDIR/feas.txt" "/data/feas.txt"

# nohup $MODDIR/FEAShelper /data/feas.txt >/dev/null 2>&1 &
$MODDIR/FEASHelper -c "/data/feas.txt"

sleep 2
Original_introduction="在支持的小米FEAS的设备上，自动给配置的应用打开FEAS。"
ps -ef > "$MODDIR/i.txt"
if echo $(cat $MODDIR/i.txt) | grep -q FEASHelper ;then
    sed -i "s/description=[^*]*/description=\[\😋\ FEASHelper服务运行中…… \]$Original_introduction/g" "$MODDIR/module.prop"
else
    sed -i "s/description=[^*]*/description=\[\😰\ FEASHelper服务运行失败…… \]$Original_introduction/g" "$MODDIR/module.prop"
fi
rm "$MODDIR/i.txt"
