module_dir="/data/adb/modules/coloros11-optimization"
local_path="/data/media/0/Android/luckyzyx"
config_path="/data/media/0/Android/luckyzyx/config.conf"
log_path="/data/media/0/Android/luckyzyx/logs.log"

logs(){
	echo "[$(date '+%Y-%m-%d %H:%M:%S')] $1" >> $log_path
	if [ $2 ]; then
		echo - $1
	fi
}

get_choose(){
	local choose
	local branch
	while :; do
		choose="$(getevent -qlc 1 | awk '{ print $3 }')"
		case "${choose}" in
		KEY_VOLUMEUP)  branch="0" ;;
		KEY_VOLUMEDOWN)  branch="1" ;;
		*)  continue ;;
		esac
		echo "${branch}"
		break
	done
	sleep 0.5
}

desc_add(){
	echo -n $1 >> $MODPATH/module.prop
}

seds(){
	sed -n "$1,$2p" $MODPATH/list/module.sh >> $3
}

cp_dir(){
	if [ -d $1 ]; then
		if [ -d $2 ]; then
			cp -r $1 $2
		else
			logs "$2 目录不存在" 1
		fi
	else
		logs "$1 配置文件丢失" 1
	fi
}

sdcard_rw() {
  local file=/data/media/0/sdcard_rw_test.asg
  if [[ -f $file ]]; then
    rm $file
    while [[ -f $file ]]; do
      sleep 3
      rm $file
    done
  else
    touch $file
    until [[ -f $file ]]; do
      sleep 3
      touch $file
    done
    rm $file
  fi
}

check_path(){
	if [ ! -d $local_path ]; then
	mkdir $local_path
	cat $MODPATH/config.conf > $config_path
	fi

	if [ ! -f $config_path ]; then
		cat $MODPATH/config.conf > $config_path
	else
		mv $config_path $local_path/old_config.conf
		cat $MODPATH/config.conf > $config_path
	fi
}

check_logs(){
	if [ -f log_path ]; then
		mv $log_path $local_path/logs.log.bak
		echo "" > $log_path
	else
		echo "" > $log_path
	fi
}

clear_temp(){
	mv $MODPATH/resource.sh $MODPATH/resource.zip
	unzip -o "$MODPATH/resource.zip" -d $MODPATH >&2
	rm -rf $MODPATH/resource.zip
}
