# 可用变量:
# MAGISK_VER (string):当前已安装Magisk的版本的字符串(字符串形式的Magisk版本)
# MAGISK_VER_CODE (int):当前已安装Magisk的版本的代码(整型变量形式的Magisk版本)
# BOOTMODE (bool):如果模块当前安装在Magisk Manager中，则为true。
# MODPATH (path):你的模块应该被安装到的路径
# TMPDIR (path):一个你可以临时存储文件的路径
# ZIPFILE (path):模块的安装包（zip）的路径
# ARCH (string): 设备的体系结构。其值为arm、arm64、x86、x64之一
# IS64BIT (bool):如果$ARCH(上方的ARCH变量)为arm64或x64，则为true。
# API (int):设备的API级别（Android版本）
#
# 可用函数:
# ui_print <msg>
#     打印(print)<msg>到控制台
#     避免使用'echo'，因为它不会显示在定制recovery的控制台中。

# abort <msg>
#     打印错误信息<msg>到控制台并终止安装
#     避免使用'exit'，因为它会跳过终止的清理步骤

# 如果您需要更多的自定义，并且希望自己做所有事情
# 请在custom.sh中标注SKIPUNZIP=1
# 以跳过提取操作并应用默认权限/上下文上下文步骤。
# 请注意，这样做后，您的customize.sh将负责自行安装所有内容。
SKIPUNZIP=1
# 如果您需要调用Magisk内部的busybox,请在custom.sh中标注ASH_STANDALONE=1
ASH_STANDALONE=0

echo "- 解压模块文件"
unzip -o "$ZIPFILE" -x 'META-INF/*' -d $MODPATH >&2

if [ ! -f "$MODPATH/func.sh" ] && [ ! -f "$MODPATH/resource.sh" ]; then
  echo "*********************************************************"
  echo "- 模块已损坏，请重新下载!"
  abort "*********************************************************"
fi
. $MODPATH/func.sh
clear_temp
check_path

model="`getprop ro.product.model`"
brand="`getprop ro.product.brand`"
var_version="`getprop ro.build.version.release`"

id="`grep_prop id $TMPDIR/module.prop`"
name="`grep_prop name $TMPDIR/module.prop`"
author="`grep_prop author $TMPDIR/module.prop`"
version="`grep_prop version $TMPDIR/module.prop`"
description="`grep_prop description $TMPDIR/module.prop`"

echo ""
echo "- 欢迎使用ColorOS11多合一优化模块"
echo "------------------------------------"
echo "- 设备品牌: $brand"
echo "- 设备型号: $model"
echo "- 系统版本: $var_version"
echo "- Magisk版本：$MAGISK_VER"
echo "- 模块版本：$version"
echo "- 作者：$author"
echo "------------------------------------"
echo ""

echo "- 根据音量键选择功能"
echo "-----------------------"
echo "- 音量键＋: 安装 √"
echo "- 音量键－: 跳过 X"
echo "-----------------------"

echo ""
echo "1.改机型-机型列表如下:"
echo "- OPPO Findx3 Pro"
echo "- OnePlus 9 Pro"
echo "- 请继续操作"
echo ""

i=0

if [[ $(get_choose) == 0 ]]; then
	echo "- 选择机型"
	echo "- --> OPPO Findx3 Pro"
	if [[ $(get_choose) == 0 ]]; then
		echo "- 安装"
		let i++
		desc_add "[改机型OPPO Findx3 Pro]"
		seds 8 10 $MODPATH/system.prop
	else
		echo "- 跳过"
		echo ""
		echo "- --> OnePlus9 Pro"
		if [[ $(get_choose) == 0 ]]; then
			echo "- 安装"
			let i++
			desc_add "[改机型OnePlus9 Pro]"
			seds 12 14 $MODPATH/system.prop
		else
			echo "- 跳过"
		fi
	fi
else
	echo "- 跳过"
fi
echo ""

echo "- 2.是否启用全局90Hz刷新率"
if [[ $(get_choose) == 0 ]]; then
	echo "- 安装"
	let i++
	desc_add "[全局90Hz]"
	seds 16 16 $MODPATH/service.sh
else
	echo "- 跳过"
fi
echo ""

echo -e "- 3.是否启用自定义应用分身\n- 配置文件在Android/luckyzyx/目录下"
if [[ $(get_choose) == 0 ]]; then
	echo "- 安装"
	let i++
	desc_add "[自定义应用分身]"
	cp_dir $MODPATH/list/system_ext $MODPATH/system
else
	echo "- 跳过"
fi
echo ""

echo -e "- 4.是否启用ColorOS指纹修复\n- 修复开启Magisk Hide时指纹无法使用的问题\n- 修复解锁后指纹无法使用的问题"
if [[ $(get_choose) == 0 ]]; then
	echo "- 安装"
	let i++
	desc_add "[ColorOS指纹修复]"
	seds 18 18 $MODPATH/system.prop
else
	echo "- 跳过"
fi
echo ""

echo "- 5.是否去除状态栏开发者模式的警告"
if [[ $(get_choose) == 0 ]]; then
	echo "- 安装"
	let i++
	desc_add "[去除开发者模式警告]"
	cp_dir $MODPATH/list/etc $MODPATH/system
else
	echo "- 跳过"
fi
echo ""

echo -e "- 6.是否启用CPU负载均衡优化\n- 通过对sched_relax_domain_level值的修改\n- 扩大cpu负载均衡时查找的范围\n- 防止因为某个范围内的核心因为负载过大而降低性能"
if [[ $(get_choose) == 0 ]]; then
	echo "- 安装"
	let i++
	desc_add "[CPU负载均衡优化]"
	seds 2 6 $MODPATH/service.sh
else
	echo "- 跳过"
fi
echo ""

echo -e "- 7.是否启用WiFi Bonding带宽提速\n- 感知不强"
if [[ $(get_choose) == 0 ]]; then
	echo "- 安装"
	let i++
	desc_add "[WiFi Bonding带宽提速]"
	cp_dir $MODPATH/list/vendor $MODPATH/system
else
	echo "- 跳过"
fi
echo ""

echo "- 8.是否启用安卓TCP参数优化，提高网络稳定性和负载能力"
if [[ $(get_choose) == 0 ]]; then
	echo "- 安装"
	let i++
	desc_add "[安卓TCP参数优化]"
	seds 31 40 $MODPATH/service.sh
else
	echo "- 跳过"
fi
echo ""

echo -e "- 9.是否去除状态栏网络可能会受到监控的警告\n- 例如：HttpCanary CA证书"
if [[ $(get_choose) == 0 ]]; then
	echo "- 安装"
	let i++
	desc_add "[去除CA证书警告]"
	seds 20 29 $MODPATH/post-fs-data.sh
	cp_dir $MODPATH/list/security $MODPATH/system/etc/
else
	echo "- 跳过"
fi
echo ""

echo -e "- 10.是否启用开机自动清理电池优化白名单\n- 配置文件在Android/luckyzyx/目录下"
if [[ $(get_choose) == 0 ]]; then
	echo "- 安装"
	let i++
	desc_add "[开机清理电池优化白名单]"
	seds 56 $ $MODPATH/service.sh
else
	echo "- 跳过"
fi
echo ""

echo -e "- 11.是否禁用温控\n- 玄学警告"
if [[ $(get_choose) == 0 ]]; then
	echo "- 安装"
	let i++
	desc_add "[禁用温控]"
	seds 42 50 $MODPATH/service.sh
else
	echo "- 跳过"
fi
echo ""


[[ $i == 0 ]] && abort "- 模块安装数量为$i，取消安装!"

echo "- 清理多余配置"
rm -rf $MODPATH/list
# rm -rf $MODPATH/func.sh
rm -rf $MODPATH/config.conf
set_perm_recursive $module_dir 0 0 0777 0777
rm -rf $module_dir/system/
rm -rf $module_dir/service.sh
rm -rf $module_dir/post-fs-data.sh
rm -rf $module_dir/system.prop
rm -rf $module_dir/uninstall.sh

echo ""
echo "- ColorOS11优化完毕，您本次启用了$i个功能，感谢您的使用!"
desc_add "共计$i个模块!"
echo ""
echo ""
echo ""
echo ""
echo ""

# 请注意，magisk模块目录中的所有文件/文件夹都有$MODPATH前缀-在所有文件/文件夹中保留此前缀

# 对于目录(包括文件):
# set_perm_recursive  <目录>                <所有者> <用户组> <目录权限> <文件权限> <上下文> (默认值是: u:object_r:system_file:s0)
# set_perm_recursive $MODPATH/system/lib 0 0 0755 0644
# set_perm_recursive $MODPATH/system/vendor/lib/soundfx 0 0 0755 0644

# 对于文件(不包括文件所在目录)
# set_perm  <文件名>                         <所有者> <用户组> <文件权限> <上下文> (默认值是: u:object_r:system_file:s0)
# set_perm $MODPATH/system/lib/libart.so 0 0 0644
# set_perm /data/local/tmp/file.txt 0 0 644

# 默认权限请勿删除
set_perm_recursive $MODPATH 0 0 0755 0644

