# Magisk多合一模块
# 脚本底包: 来自酷安@cjybyjk
# 编写: 酷安@皮卡丶皮卡丘
# 开: true; 关: false
#iptables -F

# 多合一模板版本
VERSION="0.27"

# 功能来源
COOLAPK="- 来自酷安"

# 调试模式标记
DEBUG_FLAG=false

# 自动挂载
SKIPMOUNT=false
# 对应/common/system.prop
PROPFILE=false
# 对应/common/post-fs-data.sh
POSTFSDATA=false
# 对应/common/service.sh
LATESTARTSERVICE=false

# 获取系统信息
var_sdk="`grep_prop ro.build.version.sdk`"
var_name="`grep_prop ro.miui.ui.version.name`"
var_model="`grep_prop ro.product.system.model`"
var_brand="`grep_prop ro.product.system.brand`"
var_device="`grep_prop ro.product.*device`"
var_release="`grep_prop ro.build.version.release`"
var_version="`grep_prop ro.build.version.incremental`"

# 获取模块module.prop信息
print() { sed -n "s|^$1=||p" ${2:-$TMPDIR/module.prop} 2>/dev/null || :; }
name=$(print name)
author=$(print author)
version=$(print version)

if [ -e "$MODUIES/$MODID/module.prop" ]; then
cp -rf $MODUIES/$MODID/module.prop $MODUIES/$MODID/module.prop.bak
VERSION_1=`grep_prop version $MODUIES/$MODID/module.prop`
version_1="(已安装版本：$VERSION_1)"
fi

print_modname() {

# 在这里设置你想要在模块安装过程中显示的信息
	ui_print "----------------------------"
	ui_print "  模块名称：$name"
	ui_print "  模块作者：$author"
	ui_print "  模块版本：$version $version_1"
	ui_print "  多合一模板：$VERSION"
	ui_print "----------------------------"
	ui_print "  设备型号：$var_model ($var_device)"
	ui_print "  系统版本：$var_name $var_version"
	ui_print "  设备版本：$var_release (SDK$var_sdk)"
	ui_print "----------------------------"
	ui_print "  存在Bug记得反馈$author"
}

# 设置统一权限
set_permissions() {
	set_perm_recursive $MODPATH 0 0 0755 0755
}

initmods() {
	mod_name=""
	mod_install_info=""
	mod_select_yes_text=""
	mod_select_yes_desc=""
	mod_select_no_text=""
	mod_select_no_desc=""
	mod_require_device=""
	mod_require_version=""
	INSTALLED_FUNC="`trim $INSTALLED_FUNC`"
	MOD_SKIP_INSTALL=false
	cd $TMPDIR/mods
}

keytest() {
	ui_print "----------------------------"
	ui_print "- 音量键测试 -"
	ui_print "   请按下 [音量+] 键："
	ui_print "   无反应或传统模式无法正确安装时，请触摸一下屏幕后继续。"
	(/system/bin/getevent -lc 1 2>&1 | /system/bin/grep VOLUME | /system/bin/grep " DOWN" > $TMPDIR/events) || return 1
	return 0
}

chooseport() {
#note from chainfire @xda-developers: getevent behaves weird when piped, and busybox grep likes that even less than toolbox/toybox grep
	while (true); do
		/system/bin/getevent -lc 1 2>&1 | /system/bin/grep VOLUME | /system/bin/grep " DOWN" > $TMPDIR/events
		if (`cat $TMPDIR/events 2>/dev/null | /system/bin/grep VOLUME >/dev/null`); then
			break
		fi
	done
	if (`cat $TMPDIR/events 2>/dev/null | /system/bin/grep VOLUMEUP >/dev/null`); then
		return 0
	else
		return 1
	fi
}

chooseportold() {
# Calling it first time detects previous input. Calling it second time will do what we want
	$KEYCHECK
	$KEYCHECK
	SEL=$?
	$DEBUG_FLAG && ui_print "  调试：选择portold：$1,$SEL"
	if [ "$1" == "UP" ]; then
		UP=$SEL
	elif [ "$1" == "DOWN" ]; then
		DOWN=$SEL
	elif [ $SEL -eq $UP ]; then
		return 0
	elif [ $SEL -eq $DOWN ]; then
		return 1
	else
		abort "   未检测到音量键!"
	fi
}

on_install() {

# 解压文件
	unzip -o "$ZIPFILE" 'mods/*' -d "$TMPDIR/" >&2
# 公用函数
	source $TMPDIR/util_funcs.sh

# Keycheck binary by someone755 @Github, idea for code below by Zappo @xda-developers
	KEYCHECK=$TMPDIR/keycheck
	chmod 755 $KEYCHECK
	ZIP=$TMPDIR/zip
	chmod 755 $ZIP

# 测试音量键
	if keytest; then
		VOLKEY_FUNC=chooseport
		ui_print "----------------------------"
	else
		VOLKEY_FUNC=chooseportold
		ui_print "----------------------------"
		ui_print "- 检测到遗留设备！使用旧的 keycheck 方案"
		ui_print "- 进行音量键录入 -"
		ui_print "   录入：请按下 [音量+] 键："
		$VOLKEY_FUNC "UP"
		ui_print "   已录入 [音量+] 键。"
		ui_print "   录入：请按下 [音量-] 键："
		$VOLKEY_FUNC "DOWN"
		ui_print "   已录入 [音量-] 键。"
	ui_print "----------------------------"
	fi

# 获取更新日志
	ui_print "  更新日志："
	ui_print "----------------------------"
	source $TMPDIR/mods/00_log/tail.sh || ui_print "  无法读取更新日志"
	ui_print "----------------------------"

# 已安装模块
	MODS_SELECTED_YES=""
	MODS_SELECTED_NO=""

# 加载可用模块
	initmods
	for MOD in $(ls)
	do
		if [ -f $MOD/mod_info.sh ]; then
			MOD_FILES_DIR="$TMPDIR/mods/$MOD/files"
			source $MOD/mod_info.sh
			$DEBUG_FLAG && ui_print "----------------------------"
			$DEBUG_FLAG && ui_print "  调试：加载 [$MOD]"
			$DEBUG_FLAG && ui_print "  调试：[$MOD]的名称：[$mod_name]"
			$DEBUG_FLAG && ui_print "  调试：[$mod_name]的设备要求：$mod_require_device"
			$DEBUG_FLAG && ui_print "  调试：[$mod_name]的版本要求：$mod_require_version"
			if [ -z $mod_require_device ]; then
				mod_require_device=$var_device
				$DEBUG_FLAG && ui_print "  调试：替换[$mod_name]的设备要求：$mod_require_device"
			fi
			if [ -z $mod_require_version ]; then
				mod_require_version=$var_version
				$DEBUG_FLAG && ui_print "  调试：替换[$mod_name]的版本要求：$mod_require_version"
			fi
			if $MOD_SKIP_INSTALL ; then
				ui_print "  跳过[$mod_name]安装"
				initmods
				continue
			fi
			if [ "`echo $var_device | egrep $mod_require_device`" = "" ]; then
				ui_print "----------------------------"
				ui_print "   [$mod_name]不支持你的设备。"
				ui_print "   [$mod_name]支持你的设备是[$mod_require_device]。"
			elif [ "`echo $var_version | egrep $mod_require_version`" = "" ]; then
				ui_print "----------------------------"
				ui_print "   [$mod_name]不支持你的系统版本。"
				ui_print "   [$mod_name]支持你的系统版本是[$mod_require_version]。"
			elif [ "`echo $var_release | egrep $mod_require_release`" = "" ]; then
				ui_print "----------------------------"
				ui_print "   [$mod_name]不支持你的设备版本。"
				ui_print "   [$mod_name]支持你的设备版本是[$mod_require_release]。"
			else
				ui_print "----------------------------"
				ui_print "  [$mod_name]安装"
				ui_print "  - 介绍：$mod_install_desc"
				ui_print "  - 请按音量键选择$mod_install_info -"
				ui_print "   [音量+]：$mod_select_yes_text"
				ui_print "   [音量-]：$mod_select_no_text"
				if $VOLKEY_FUNC; then
					ui_print "   已选择$mod_select_yes_text。"
					mod_install_yes
					run_result=$?
					if [ $run_result -eq 0 ]; then
						MODS_SELECTED_YES="$MODS_SELECTED_YES ($MOD)"
						INSTALLED_FUNC="$mod_select_yes_desc $INSTALLED_FUNC"
					else
						ui_print "   失败。错误：$run_result"
					fi
				else
					ui_print "   已选择$mod_select_no_text。"
					mod_install_no
					run_result=$?
					if [ $run_result -eq 0 ]; then
						MODS_SELECTED_NO="$MODS_SELECTED_NO ($MOD)"
						INSTALLED_FUNC="$mod_select_no_desc $INSTALLED_FUNC"
					else
						ui_print "   失败。错误：$run_result"
					fi
				fi
			fi
		else
			$DEBUG_FLAG && ui_print "  调试：找不到 $MOD 的mod_info.sh"
		fi
		initmods
	done

	if [ -z "$INSTALLED_FUNC" ]; then
		ui_print "未安装任何功能 即将退出安装..."
		rm -rf $TMPDIR
		exit 1
	fi
	echo "安装时间：[`date "+%F %T"`]	安装的功能: $INSTALLED_FUNC" >> $TMPDIR/module.prop
}