#!/system/bin/sh
# Do NOT assume where your module will be located.
# ALWAYS use $MODDIR if you need to know where this script
# and module is placed.
# This will make sure your module will still work
# if Magisk change its mount point in the future
MODDIR=${0%/*}

# This script will be executed in late_start service mode
# Fast Charger
chmod 0755 /sys/kernel/fast_charge/force_fast_charge
echo '1' > /sys/kernel/fast_charge/force_fast_charge
chmod 0644 /sys/kernel/fast_charge/force_fast_charge

chmod 0755 /sys/class/power_supply/battery/constant_charge_current_max
echo '6000000' > /sys/class/power_supply/battery/constant_charge_current_max
chmod 0644 /sys/class/power_supply/battery/constant_charge_current_max

chmod 0755 /sys/class/power_supply/battery/constant_charge_current
echo '6000000' > /sys/class/power_supply/battery/constant_charge_current
chmod 0644 /sys/class/power_supply/battery/constant_charge_current

chmod 0755 /sys/class/power_supply/battery/input_current_limited
echo '0' > /sys/class/power_supply/battery/input_current_limited
chmod 0644 /sys/class/power_supply/battery/input_current_limited

chmod 0755 /sys/class/power_supply/battery/step_charging_enabled
echo '1' > /sys/class/power_supply/battery/step_charging_enabled
chmod 0644 /sys/class/power_supply/battery/step_charging_enabled

chmod 0755 /sys/class/power_supply/battery/sw_jeita_enabled
echo '0' > /sys/class/power_supply/battery/sw_jeita_enabled
chmod 0644 /sys/class/power_supply/battery/sw_jeita_enabled

chmod 0755 /sys/class/power_supply/battery/battery_charging_enabled
echo '1' > /sys/class/power_supply/battery/battery_charging_enabled
chmod 0644 /sys/class/power_supply/battery/battery_charging_enabled

chmod 0755 /sys/class/power_supply/battery/subsystem/usb/pd_active
echo '0' > /sys/class/power_supply/battery/subsystem/usb/pd_active
chmod 0644 /sys/class/power_supply/battery/subsystem/usb/pd_active

chmod 0755 /sys/class/power_supply/battery/charger_temp
echo '480' > /sys/class/power_supply/battery/charger_temp
chmod 0644 /sys/class/power_supply/battery/charger_temp

chmod 0755 /sys/class/qcom-battery/restrict_chg
echo '0' > /sys/class/qcom-battery/restrict_chg
chmod 0644 /sys/class/qcom-battery/restrict_chg

chmod 0755 /sys/block/sda/quene/iostats
echo '0' > /sys/block/sda/queue/iostats
chmod 0644 /sys/block/sda/quene/iostats

chmod 0755 /proc/sys/kernel/sched_boost
echo '0' > /proc/sys/kernel/sched_boost
chmod 0644 /proc/sys/kernel/sched_boost

echo 'Y' > /sys/module/smb_lib/parameters/skip_thermal

chmod 0755 /sys/module/lmp_levels/parameters/sleep_disabled
echo 'Y' > /sys/module/lpm_levels/parameters/sleep_disabled
chmod 0644 /sys/module/lmp_levels/parameters/sleep_disabled

chmod 0755 /sys/module/sync/parameters/fsync_enabled
echo 'N' > /sys/module/sync/parameters/fsync_enabled
chmod 0644 /sys/module/sync/parameters/fsync_enabled

# Little cluster max freq
chmod 755 /sys/devices/system/cpu/cpu0/cpufreq/scaling_max_freq
echo '1804800' > /sys/devices/system/cpu/cpu0/cpufreq/scaling_max_freq
chmod 664 /sys/devices/system/cpu/cpu0/cpufreq/scaling_max_freq
chmod 755 /sys/devices/system/cpu/cpu1/cpufreq/scaling_max_freq
echo '1804800' > /sys/devices/system/cpu/cpu1/cpufreq/scaling_max_freq
chmod 664 /sys/devices/system/cpu/cpu1/cpufreq/scaling_max_freq
chmod 755 /sys/devices/system/cpu/cpu2/cpufreq/scaling_max_freq
echo '1804800' > /sys/devices/system/cpu/cpu2/cpufreq/scaling_max_freq
chmod 664 /sys/devices/system/cpu/cpu2/cpufreq/scaling_max_freq
chmod 755 /sys/devices/system/cpu/cpu3/cpufreq/scaling_max_freq
echo '1804800' > /sys/devices/system/cpu/cpu3/cpufreq/scaling_max_freq
chmod 664 /sys/devices/system/cpu/cpu3/cpufreq/scaling_max_freq

# Big cluster max freq
chmod 755 /sys/devices/system/cpu/cpu4/cpufreq/scaling_max_freq
echo '2419200' > /sys/devices/system/cpu/cpu4/cpufreq/scaling_max_freq
chmod 664 /sys/devices/system/cpu/cpu4/cpufreq/scaling_max_freq
chmod 755 /sys/devices/system/cpu/cpu5/cpufreq/scaling_max_freq
echo '2419200' > /sys/devices/system/cpu/cpu5/cpufreq/scaling_max_freq
chmod 664 /sys/devices/system/cpu/cpu5/cpufreq/scaling_max_freq
chmod 755 /sys/devices/system/cpu/cpu6/cpufreq/scaling_max_freq
echo '2419200' > /sys/devices/system/cpu/cpu6/cpufreq/scaling_max_freq
chmod 664 /sys/devices/system/cpu/cpu6/cpufreq/scaling_max_freq

# Prime cluster max freq
chmod 755 /sys/devices/system/cpu/cpu7/cpufreq/scaling_max_freq
echo '3187200' > /sys/devices/system/cpu/cpu7/cpufreq/scaling_max_freq
chmod 664 /sys/devices/system/cpu/cpu7/cpufreq/scaling_max_freq

# I/O
echo "cfq" > /sys/block/mmcblk0/queue/scheduler
echo "cfq" > /sys/block/sda/queue/scheduler
echo "cfq" > /sys/block/sdb/queue/scheduler
echo "cfq" > /sys/block/sdc/queue/scheduler
echo "cfq" > /sys/block/sdd/queue/scheduler
echo "cfq" > /sys/block/sde/queue/scheduler
echo "cfq" > /sys/block/sdf/queue/scheduler

# GPU Settings
echo '3' > /sys/module/msm_drm/parameters/boost_gpu
echo '3' > /sys/module/devfreq_boost/parameters/boost_gpu
echo '3' > /sys/module/cpu_input_boost/parameters/boost_gpu
echo '3' > /sys/kernel/gpu/gpu_boost
echo '0' > /sys/class/kgsl/kgsl-3d0/throttling
echo '1' > /sys/class/kgsl/kgsl-3d0/bus_split
echo '0' > /sys/class/kgsl/kgsl-3d0/force_bus_on
echo '0' > /sys/class/kgsl/kgsl-3d0/force_rail_on
echo '0' > /sys/class/kgsl/kgsl-3d0/force_clk_on
echo '3' > /sys/class/kgsl/kgsl-3d0/devfreq/adrenoboost

# ZRAM
echo 2048 > /sys/block/zram0/queue/read_ahead_kb

# Better Idling
echo '0-3' > /dev/cpuset/restricted/cpus

# Power Saving
chmod 755 /sys/module/workqueue/parameters/power_efficient
echo 'N' > /sys/module/workqueue/parameters/power_efficient
chmod 664 /sys/module/workqueue/parameters/power_efficient

# Battery Saving
echo 'freeze mem' > /sys/power/state
echo 's2idle [deep]' > /sys/power/mem_sleep

# This script will be executed in late_start service mode
sleep 30
su -c  cmd settings put global GPUTUNER_SWITCH true

