#!/system/bin/sh
#本代码可直接手动执行，自动杀死旧的进程，因此如果你对shell比较了解的话，可以自行调试本模块
#版本核心调用magick二进制文件，一款功能强大的图片处理命令，本人编译，有需要可以从./busybox/bin下自取magick二进制和./busybox/lib下动态链接库，如果你知道怎么把png动态库编译为静态的话，也可以联系我进行修改，万分感谢
until [[ $(dumpsys window policy | grep "mInputRestricted" | cut -d= -f2) == false ]]
do
	sleep 5
done
MODPATH=${0%/*}
[[ -f ${MODPATH}/pid ]] && kill -9 $(head -n1 ${MODPATH}/pid)
rm -f ${MODPATH}/*.png ${MODPATH}/service.log ${MODPATH}/*.bak ${MODPATH}/disable ${MODPATH}/*.jpg ${MODPATH}/pid
log()
{
	echo "`date +%k:%M:%S` -$@"
	echo "`date +%k:%M:%S` -$@" >> ${MODPATH}/service.log
}
function md5check(){
	md5sum "${MODPATH}/${1}" | grep "${2}" >/dev/null
	if [[ $? -eq 0 ]]; then
		log "文件${1}校验完成"
	else
		log "文件${1}校验不完整，暂不提供修复功能，需重新下载刷入"
		exit 1
	fi
}
md5check busybox/bin/busybox a273337dacf73c5f82c54235737f5526
md5check busybox/bin/curl 750a076523ee2e206453f45805fc8464
md5check busybox/bin/iconv 3b88764da33666806c59dce1f53b4d76
md5check busybox/bin/magick 0c12441703270170c90fb04898069de2
md5check busybox/fonts/Roboto-Regular.ttf 77897b1dd56e8e17fd3f1a1a141006d0
md5check busybox/lib/libbz2.so.1.0 417361b152bcf1c9ff32ef487820eafe
md5check busybox/lib/libfreetype.so 118182618bc21cc62cad39575544cdd8
md5check busybox/lib/libiconv.so 3a202de86574f9c470615b674cf9a852
md5check busybox/lib/libjpeg.so 0e16f9a63bc94da268e547a715b59c23
md5check busybox/lib/liblzma.so.5 d10922f1e9264d46bde0a67e341a44b2
md5check busybox/lib/libpng16.so 32e70323c22c4421b9c350e60176a810
md5check busybox/lib/libtiff.so 781da74255385780256d17a0a31d7a68
md5check busybox/lib/libz.so.1 7b8bf1efc8a9bd50acd875c91177f792
md5check busybox/cacert.pem eba44a3f7c21c902ebfce7dbc279e8fd
md5check busybox/test 8b4ad17e367a42af0527e96da6606e9e

export PATH=${MODPATH}/busybox/bin:${PATH}
shadow=${MODPATH}/shadow
tail -n +$(sed -n "/^#!\/data\/adb\/modules\/shadow_screenshots\/busybox\/bin\/sh$/=" $0) ${MODPATH}/service.sh > ${shadow}
md5check shadow 46295908345cda8318e14a4029efb374
chmod 777 ${shadow}
busybox sh ${shadow} &
exit

#!/data/adb/modules/shadow_screenshots/busybox/bin/sh
rm -f $0
MODPATH=${0%/*}
echo $$ > ${MODPATH}/pid
PROP=${MODPATH}/module.prop
BAK=${MODPATH}/配置备份_勿动.txt
[[ -f ${BAK} ]] && cp -f ${BAK} ${PROP}
sed -i "s/#ffffff/#fffffe/g" ${PROP}
source ${PROP}
export PATH=${MODPATH}/busybox/bin:$PATH
export LD_LIBRARY_PATH=${MODPATH}/busybox/lib:${LD_LIBRARY_PATH}
export CURL_CA_BUNDLE=${MODPATH}/busybox/cacert.pem

list_wait=${MODPATH}/list_wait #等待执行套壳的列表
list_finish=${MODPATH}/list_finish #已经处理过的列表
list_path=${MODPATH}/list_path #监控目录的所有图片列表
[[ -f ${list_wait} ]] && rm -f ${list_wait}
sed -i "s#^description=.*#description=手机截图自动套阴影，模块运行具体配置参数可以自行修改${PROP}文件，点击禁用模块直接自杀给你看！#g" ${PROP}

if [[ ${switch3} == yes ]]; then
	am force-stop com.android.providers.media > /dev/null
fi

log()
{
	if [[ ${switch5} == yes ]]; then
		echo "`date +%k:%M:%S` -$@"
		echo "`date +%k:%M:%S` -$@" >> ${MODPATH}/service.log
	fi
}

xm()
{
	j=1
	while :
	do
		eval t=\${t${j}}
		[ -n "${t}" ] || break
		hm1=${t%-*}
		hm2=${t#*-}
		if [ ${hm1} == ${hm2} ]; then
			log "无效休眠规则 ${t}"
		else
			h1=${hm1%:*}
			m1=${hm1#*:}
			h2=${hm2%:*}
			m2=${hm2#*:}
			s1=$(( ${h1} * 60 + ${m1} ))
			s2=$(( ${h2} * 60 + ${m2} ))
			h3=$(date +%k | sed "s/[^0-9]*//g")
			m3=$(date +%M | sed "s/[^0-9]*//g")
			s3=$(expr ${h3} \* 60 + ${m3} )
			[ ${s2} -gt ${s1} ] || s2=$(( ${s2} + 1440 ))
			[ ${s3} -gt ${s1} ] || s3=$(( ${s3} + 1440 ))
			if [ ${s3} -gt ${s1} ] && [ ${s2} -gt ${s3} ]; then
				s4=$(( ${s2} - ${s3} ))
				log "触发休眠规则 ${t} 本次休眠时间为${s4}分钟，休眠规则可自行修改${PROP}中[t]参数"
				sleep ${s4}m
				log "休眠规则 ${t} 结束,发车"
			else
				log "休眠规则 ${t} 好累啊，怎么还不到点啊"
			fi
		fi
		j=$(( ${j} + 1 ))
	done
}

color()
{
	var="#"
	for k in `seq 1 6`
	do
		var=${var}$(printf %x $(( 15 - $((16#${color:$k:1})) )))
	done
	color=${var}
	log "颜色反转结果${color}"
}

cover()
{
	v_cover=${MODPATH}/png/${WH}/cover/v_${round}.png #竖屏四个大黑圆角
	if [[ ! -f ${v_cover} ]]; then
		log "圆角切块不存在，制作中"
		mkdir -p ${MODPATH}/png/${WH}/cover
		TMP=${MODPATH}/tmp.png
		#生成圆形切片
		convert \( -size ${round}x${round} xc:black -draw "fill white circle ${round},${round} ${round},0" \) -compose xor \( -size ${round}x${round} xc:none -draw "fill white circle ${round},${round} ${round},0" \) -composite ${TMP} 2>/dev/null
		#以圆形切片生成遮罩
		log "切块完成，制作遮罩"
		TEST=${MODPATH}/busybox/test
		convert \( \( \( ${TEST} -resize ${WH}! \) -compose over ${TMP} -composite \) -compose over \( +clone -flip \) -composite \) -compose over \( +clone -flop \) -composite ${v_cover} 2>/dev/null
		rm -f ${TMP}
		log "遮罩制作完成"
	fi
	h_cover=${MODPATH}/png/${WH}/cover/h_${round}.png #横屏四个大黑圆角
	if [[ ! -f ${h_cover} ]]; then
		convert -rotate 90 ${v_cover} ${h_cover} 2>/dev/null
	fi
	if [[ ${gravity} == h ]]; then
		cover=${h_cover}
	else
		cover=${v_cover}
	fi
}

shadow()
{
	dimen=${dimen%\%} #删除占比百分号
	W=$(( ${WH%x*} * ${dimen} / 100 )) #求出原图应该设置的宽度
	H=$(( ${WH#*x} * ${dimen} / 100 )) #求出原图应该设置的高度
	cover #制作圆角遮罩
	#带圆角的纯色图,用来做原图边缘填充
	#竖屏
	color_cover_w_h=${MODPATH}/png/${WH}/round_color/${color}_${round}_${W}_${H}.png
	if [[ ! -f ${color_cover_w_h} ]]; then
		if [[ ! -d ${MODPATH}/png/${WH}/round_color ]]; then
			mkdir -p ${MODPATH}/png/${WH}/round_color
		fi
		color_png=${MODPATH}/png/${WH}/color/${color}.png
		if [[ ! -f ${color_png} ]]; then
			if [[ ! -d ${MODPATH}/png/${WH}/color ]]; then
				mkdir -p ${MODPATH}/png/${WH}/color
			fi
			log "生成纯色图片"
			convert -size ${WH} xc:"${color}" ${color_png} 2>/dev/null
		fi
		log "切出圆角纯色图片"
		convert ${color_png} -alpha set -compose dstout ${cover} -gravity center -resize ${W}x${H} -composite ${color_cover_w_h} 2>/dev/null
	fi
	#横屏
	color_cover_h_w=${MODPATH}/png/${WH}/round_color/${color}_${round}_${H}_${W}.png
	if [[ ! -f ${color_cover_h_w} ]]; then
		convert -rotate 90 ${color_cover_w_h} ${color_cover_h_w} 2>/dev/null
	fi
	if [[ ${gravity} == h ]]; then
		shadow=${color_cover_h_w}
	else
		shadow=${color_cover_w_h}
	fi
}

watermark()
{
	if [[ ${refresh} == yes ]] || [ ! -f ${MODPATH}/水印.png ]; then
		[[ ${refresh} == yes ]] && source ${PROP}
		if [ -n "${watermark}" ]; then
			log "水印制作"
			watermark_tmp=${MODPATH}/watermark_tmp
			sum=${watermark_tmp}/sum
			mkdir -p ${sum}
			#逐行读取水印内容
			m=1
			echo "${watermark}" | sed "/^$/d" | while read line
			do
				mkdir -p ${watermark_tmp}/${m}
				#逐个读取水印内容
				n=1
				for l in ${line}
				do
					if [ -n "$(echo ${l} | sed -n "/^P[0-9]*$/p")" ]; then
						#判断是否为QQ头像
						qq=${l:1}
						curl -so ${watermark_tmp}/${m}/${n}.png "http://q1.qlogo.cn/g?b=qq&nk=${qq}&s=5"
						zhongxin=$(( ${wm_dimen2} / 2 ))
						banjing=$(( ${wm_dimen2} / 2 -2 ))
						if [ ! -f ${MODPATH}/png/yuan/${banjing}.png} ]; then
							if [ ! -d ${MODPATH}/png/yuan ]; then
								mkdir -p ${MODPATH}/png/yuan
							fi
							convert -size ${wm_dimen2}x${wm_dimen2} xc:none -draw "translate ${zhongxin},${zhongxin} circle 0,0 ${banjing},0" ${MODPATH}/png/yuan/${banjing}.png 2>/dev/null
						fi
						convert -background none \( -resize ${wm_dimen2}x${wm_dimen2} ${watermark_tmp}/${m}/${n}.png \) -alpha set -compose dstin ${MODPATH}/png/yuan/${banjing}.png -gravity center -composite ${watermark_tmp}/${m}/${n}.png 2>/dev/null
					elif [ -n "$(echo ${l} | sed -n "/^T[0-9]*$/p")" ]; then
						#判断是否为QQ昵称
						qq=${l:1}
						NAME="$(curl -s -H 'accept-language: zh-CN,en-US;q=0.9' -kL "https://r.qzone.qq.com/fcg-bin/cgi_get_portrait.fcg?uins=${qq}" | awk -F '"' '{print $6}' | iconv -c -f gb2312 -t utf-8)"
						if [[ -n "${NAME}" ]]; then
							convert -background none -fill "${color2}" -stroke "${color3}" -font ${font} -pointsize ${wm_dimen} label:"$NAME" -gravity center -annotate +0+0 "$NAME" ${watermark_tmp}/${m}/${n}.png 2>/dev/null
						else
							log "网络链接失败或昵称中包含<繁体|生僻>"
						fi
					elif [ -f "${l}" ]; then
						#判断是否为一个图片文件
						convert -resize ${wm_dimen2}x${wm_dimen2} ${l} ${watermark_tmp}/${m}/${n}.png 2>/dev/null
					elif [ -n "$(echo ${l} | sed -n "/^%.*%$/p")" ]; then
						#判断是否为变量 以下case内可以自己增添自己的变量
						eval customer="\$$(echo ${l} | sed "s/%//g")"
						if [ -n "${customer}" ]; then
							convert -background none -fill "${color2}" -stroke "${color3}" -font ${font} -pointsize ${wm_dimen} label:"${customer}" -gravity center -annotate +0+0 "${customer}" ${watermark_tmp}/${m}/${n}.png 2>/dev/null
						fi
					elif [ -n "$(echo "${l}" | egrep "\[[0-9]+\]")" ]; then
						#判断是否输入空格
						md5=$(date | md5sum)
						space=${md5:0:$(echo "${l}" | sed "s/[^0-9]//g")}
						convert -background none -fill "none" -font ${font} -pointsize ${wm_dimen} label:"${space}" -gravity center -annotate +0+0 "${space}" ${watermark_tmp}/${m}/${n}.png 2>/dev/null
					else
						#其他情况按照文字处理
						TEXT="$(echo "${l}" | sed "s/+_+/\n/g")"
						convert -background none -fill "${color2}" -stroke "${color3}" -font ${font} -pointsize ${wm_dimen} label:"${TEXT}" -gravity center -annotate +0+0 "${TEXT}" ${watermark_tmp}/${m}/${n}.png 2>/dev/null
					fi
					n=$(( $n + 1 ))
				done
				#横向合成该行内容
				if [ `ls ${watermark_tmp}/${m} | wc -l` -gt 1 ]; then
					convert -background none `ls ${watermark_tmp}/${m} | sed "s@^@${watermark_tmp}/${m}/@g"` -gravity center +append ${sum}/${m}.png 2>/dev/null
				else
					cp -f `ls ${watermark_tmp}/${m} | sed "s@^@${watermark_tmp}/${m}/@g"` ${sum}/${m}.png
				fi
				m=$(( $m + 1 ))
			done
			#纵向合成所有内容
			if [ `ls ${sum} | wc -l` -gt 1 ]; then
				convert -background none `ls ${sum} | sed "s@^@${sum}/@g"` -gravity ${plan} -append ${MODPATH}/水印.png 2>/dev/null
			else
				cp -f `ls ${sum} | sed "s@^@${sum}/@g"` ${MODPATH}/水印.png
			fi
			rm -rf ${watermark_tmp}
		fi
	fi
}

test_module()
{
	if [[ -n "${MD5_OLD}" ]]; then
		MD5_NEW=$(md5sum ${PROP} | cut -d " " -f 1)
		if [[ ${MD5_OLD} != ${MD5_NEW} ]]; then
			[ $(wc -l ${PROP} | cut -d " " -f 1) -gt 100 ] || exit
			log "配置测试"
			set -e
			source ${PROP} && cp -f ${PROP} ${BAK}
			set +e
			sh ${MODPATH}/service.sh
		fi
	else
		MD5_OLD=$(md5sum ${PROP} | cut -d " " -f 1)
	fi
	if [ -f ${MODPATH}/disable ]; then
		sed -i "s#^description=.*#description=啊！我死了！叫不醒的那种！重新启用模块然后重启手机或者也可以root权限手动执行/data/adb/modules/shadow_screenshots/service.sh才能叫醒我#g" ${PROP}
		rm -f ${MODPATH}/pid
		exit 0
	fi
}

zen_mode()
{
	while [[ $(settings get global zen_mode) -eq 1 ]]
	do
		test_module
		log "检测到勿扰模式，挂起进程${sleeptime}秒"
		sleep ${sleeptime}
	done
}

make_finish()
{
	if [ -f ${MODPATH}/水印.png ]; then
		convert "${PNG_FINISH}" -compose over "${MODPATH}/水印.png" -gravity ${location} -geometry +${range_h}+${range_v} -composite "${PNG_FINISH}" 2>/dev/null
	fi
	if [[ ${switch1} == yes ]] && [[ ${switch6} == yes ]]; then
		log "备份原图"
		[[ -d "${screenshots_bak}" ]] || mkdir -p "${screenshots_bak}"
		[[ -f "${screenshots_bak}/.nomedia" ]] || touch "${screenshots_bak}/.nomedia"
		cp -f "${OUTPNG}" "${screenshots_bak}"
	fi
	cp -f "${PNG_FINISH}" "${OUTPNG}"
	rm -f "${PNG_TMP}" "${PNG_FINISH}" "${INPUTPNG}"
	if [[ ${switch4} == yes ]]; then
		log "刷新相册"
		timeout 2 am broadcast -a android.intent.action.MEDIA_SCANNER_SCAN_FILE \
		-d "file://${OUTPNG}" > /dev/null 2>&1
		[[ $? -eq 0 ]] || log "媒体存储设备卡死"
	fi
}

make_shadow()
{
	PNG_TMP="${MODPATH}/${i%.*}.png"
	log "生成圆角图片"
	if [[ ${gravity} == h ]]; then
		NEW_WH="${H}x${W}"
		DEFAULT_WH="${WH#*x}x${WH%x*}"
		
	else
		NEW_WH="${W}x${H}"
		DEFAULT_WH="${WH}"
	fi
	convert "${INPUTPNG}" -alpha set -compose dstout ${cover} -gravity center -resize ${NEW_WH} -composite "${PNG_TMP}" 2>/dev/null
	log "合成图片"
	#原图上放置圆角纯色图执行高斯模糊再放置缩小后的圆角原图
	if [[ ${switch8} == yes ]]; then
		fuzzy="-resize ${zoom} -resize ${DEFAULT_WH}!"
	else
		fuzzy="${bg}"
	fi
	#使用原图做背景
	if [[ ${switch10} == yes ]]; then
		BG="${INPUTPNG}"
	else
		if [[ -f "${shadow_bg}" ]]; then
			
			if [[ ${gravity} == v ]]; then
				BG="${MODPATH}/shadow_bg_v.png"
			else
				BG="${MODPATH}/shadow_bg_h.png"
			fi
			if [[ ! -f ${BG} ]]; then
				convert "${shadow_bg}" -resize ${DEFAULT_WH}^ ${BG} 2>/dev/null
			fi
		elif [[ ${#shadow_bg} == 7 ]]; then
			BG=${MODPATH}/png/${DEFAULT_WH}/color/${shadow_bg}.png
			if [[ ! -f ${BG} ]]; then
				if [[ ! -d ${MODPATH}/png/${DEFAULT_WH}/color ]]; then
					mkdir -p ${MODPATH}/png/${DEFAULT_WH}/color
				fi
				log "生成纯色图片"
				convert -size ${DEFAULT_WH} xc:"${shadow_bg}" ${BG} 2>/dev/null
			fi
		else
			log "shadow_bg参数有误"
			exit 1
		fi
	fi
	convert "${BG}" -compose over ${shadow} -gravity center -composite ${fuzzy} -compose over "${PNG_TMP}" -gravity center -composite "${PNG_FINISH}" 2>/dev/null
}

make_shell()
{
	SHELL_PNG="${MODPATH}/shell/${shell_name}.png"
	SHELL_CFG="${MODPATH}/shell/${shell_name}.cfg"
	if [[ ! -f ${SHELL_PNG} ]] || [[ ! -f ${SHELL_CFG} ]]; then
		log "带壳图片或者配置不存在，退出"
		exit 1
	fi
	source ${SHELL_CFG}
	coordinate="0,0,${left_top_x},${left_top_y} 0,%h,${left_bottom_x},${left_bottom_y} %w,0,${right_top_x},${right_top_y} %w,%h,${right_bottom_x},${right_bottom_y}"
	if [[ ${gravity} == h ]]; then
		if [[ ${shell_turn} == left ]]; then
			TURN="-rotate 90"
		else
			TURN="-rotate 270"
		fi
	else
		unset TURN
	fi
	convert "${SHELL_PNG}" \( "${INPUTPNG}" ${TURN} -alpha set -virtual-pixel transparent +distort Perspective "${coordinate}" \) -background none -compose dstover -layers merge +repage "${PNG_FINISH}" 2>/dev/null
	#使用原图做背景
	if [[ ${switch10} == yes ]]; then
		PNG_TMP="${MODPATH}/${i%.*}.png"
		BG_WH="${template_width}x${template_height}"
		if [[ ${switch8} == yes ]]; then
			convert "${INPUTPNG}" -resize ${zoom} -resize ${BG_WH}^ -gravity center -crop ${BG_WH}+0+0 "${PNG_TMP}" 2>/dev/null
		else
			convert $bg "${INPUTPNG}" -resize ${BG_WH}^ -gravity center -crop ${BG_WH}+0+0 "${PNG_TMP}" 2>/dev/null
		fi
		convert "${PNG_TMP}" -compose over "${PNG_FINISH}" -gravity center -composite "${PNG_FINISH}" 2>/dev/null
	fi
}


while :
do
	log "########################################"
	log "主循环开始"
	#配置测试
	test_module
	alias curl="timeout ${timeout} curl"
	if [[ $(dumpsys window policy | grep "mInputRestricted" | cut -d= -f2) == false ]]; then
		sleeptime=${time1}
	else
		sleeptime=${time2}
	fi
	#挂起模块
	[[ ${switch7} == yes ]] && zen_mode
	xm #判断是否休眠
	[ -n "${format2}" ] || format2="未启用排除模式"
	ls ${screenshots} | egrep "${format1}" | egrep -v "^$|:" | egrep -v "${format2}" > ${list_path}
	[[ $? -eq 0 ]] || log "error 监听目录不正确或无截图"
	[[ ! -f ${list_finish} ]] && cp -f ${list_path} ${list_finish} && log "列表丢失，重新生成"
	cat ${list_path} ${list_finish} | sort | uniq -u | while read line
	do
		if [[ -n "$(sed -n "/^${line}$/p" ${list_path})" ]]; then
			if [[ -n "$(sed -n "/^${line}$/p" ${list_finish})" ]]; then
				log "疑似套娃，略过"
			else
				echo ${line} >> ${list_wait}
			fi
		fi
	done
	if [[ -f ${list_wait} ]]; then
		if [[ `cat ${list_wait} | egrep "${format1}" | egrep -v "${format2}" | wc -l` -ne 0 ]]; then
			log "检测到图片开始配置"
			cat ${list_wait} | egrep "${format1}" | egrep -v "${format2}" | while read i
			do
				INPUT="$(find ${screenshots} -name "${i}" -type f | uniq)" #待制作图片绝对路径
				log "新图片${INPUT}"
				#判断是否为区域截图
				message="$(identify "${INPUT}" 2>/dev/null)"
				if [ ! "$(echo "${message}" | egrep "${WH}|${WH#*x}x${WH%x*}")" ]; then
					log "不符合要求，PASS"
				else
					INPUTPNG="$MODPATH/input.${i##*.}"
					cp -f "${INPUT}" ${INPUTPNG}
					if [ ! "$(echo "${message}" | grep "${WH}")" ]; then
						gravity=h
					else
						gravity=v
					fi
					#深色模式下阴影自动反色
					if [[ ${switch2} == yes ]]; then
						#判断是否为深色模式
						if [[ $(settings get system smart_dark_enable) -eq 1 ]] || \
						[[ $(settings get system dark_mode_enable) -eq 1 ]]; then
							color #反转颜色
						fi
					fi
					shadow #制作圆角纯色图片
					#是否覆盖原图
					if [[ ${switch1} == yes ]]; then
						switch4="no"
						OUTPNG="${INPUT}"
					else
						if [[ ! -d ${screenshots_shadow} ]]; then
							mkdir -p ${screenshots_shadow}
						else
							if [[ echo "${screenshots}" | grep "${screenshots_shadow}" ]]; then
								log "检测到未开启覆盖原图且生成图片保存位置与检测目录可能一致"
								screenshots_shadow="/storage/emulated/0/DCIM/Screenshots_shadow"
								if [[ ! -d ${screenshots_shadow} ]]; then
									mkdir -p ${screenshots_shadow}
									log "为防止触发bug无限套壳，已强制将阴影截图保存目录设置为${screenshots_shadow}"
								fi
							fi
						fi
						OUTPNG="${screenshots_shadow}/${i%.*}_shadow.${format3}"
					fi
					[[ ${switch9} == yes ]] && watermark #检查水印
					log "开始制作"
					PNG_FINISH="${MODPATH}/shadow_${i%.*}.${format3}"
					if [[ ${mode} == shadow ]]; then
						make_shadow
					elif [[ ${mode} == shell ]]; then
						make_shell
					else
						log "未指定模式，退出"
						exit 1
					fi
					make_finish
				fi
				echo "${i}" >> ${list_finish}
			done
		fi
		rm -f ${list_wait}
	fi
	[[ -f ${list_path} ]] && [ $(wc -l ${list_path} | cut -d " " -f 1) -gt 0 ] && cp -f ${list_path} ${list_finish}
	log "循环结束，即将休眠${sleeptime}秒"
	log "########################################"
	log ""
	sleep ${sleeptime}
done
