#!/system/bin/sh
check_choise()
{
	sleep 0.5
	if [[ -n `getevent -lqc 1 | grep KEY_VOLUMEUP` ]]
	then
		return 1
	elif [[ -n `getevent -lqc 1 | grep KEY_VOLUMEDOWN` ]]
	then
		return 0
	else
		echo "-点锤子屏幕，爬一边去"
		check_choise
	fi
}

#安装命令
[[ ${ARCH} != arm64 ]] && abort "-非arm64设备，爬"
ui_print "-安装busybox"
unzip -o "${ZIPFILE}" "busybox/*" -d "${MODPATH}" >&2
mv -f "${MODPATH}/busybox/shell" "${MODPATH}"
tools_path="${MODPATH}/busybox/bin"
busybox="${tools_path}/busybox"
chmod 777 ${busybox}
for i in `${busybox} --list`
do
	ln -s ${MODPATH/_update/}/busybox/bin/busybox "${tools_path}/${i}"
done
ln -s ${MODPATH/_update/}/busybox/bin/magick ${tools_path}/convert
ln -s ${MODPATH/_update/}/busybox/bin/magick ${tools_path}/identify
if [[ $? -eq 0 ]]; then
	ui_print "-busybox安装成功"
else
	abort "-busybox安装失败,退出安装"
fi

#复制缓存
if [[ -d ${MODPATH/_update/}/png ]]; then
	cp -rf ${MODPATH/_update/}/png ${MODPATH}
else
	mkdir -p ${MODPATH}/png
fi
if [[ -d ${MODPATH/_update/}/shell ]]; then
	cp -rf ${MODPATH/_update/}/shell ${MODPATH}
fi

#生成配置
PROP="${MODPATH}/module.prop"
if [[ -f ${PROP/_update/} ]]; then
	ui_print "-检测到旧配置文件，准备读取，若模块停止安装建议卸载重启后重刷哦"
	set -e
	source ${PROP/_update/}
	set +e
else
	ui_print "-未找到旧配置文件，重新生成新的配置，安装后可以修改${PROP/_update/}"
fi

#分辨率
[[ -n "${WH}" ]] || WH=`wm size | sed -n '$p' | sed 's/.* //g'`
ui_print "-分辨率:${WH}"
echo '
####################

#以下为模块运行内容 命令运行过程中修改即时生效免重启
#已自动屏蔽区域截图与长截屏
#部分选项修改之后会生成缓存，第一次带壳可能会多耗时十秒左右，耐心等待

#默认分辨率 安装模块的时候自动识别填写 一般无需修改 该分辨率若与截图分辨率不一致会导致无法处理图片
WH="'${WH}'"
' >> ${PROP}

#截图处理模式
[[ -n "${mode}" ]] || mode="shadow"
ui_print "-截图处理模式:${mode}"
echo '
#截图处理模式 阴影 shadow 或者带壳 shell
mode="'${mode}'"
' >> ${PROP}

#壳名称
[[ -n "${shell_name}" ]] || shell_name="shell_by_程鲜生"
ui_print "-壳名称:${shell_name}"
echo '
#壳名称，省略后缀
shell_name="'${shell_name}'"
' >> ${PROP}

#旋转方向
[[ -n "${shell_turn}" ]] || shell_turn="right"
ui_print "-横屏带壳旋转方向:${shell_turn}"
echo '
#带壳截图遇到横屏时的旋转方向 左:left 右:right
shell_turn="'${shell_turn}'"
' >> ${PROP}

#使用原图做背景
[[ -n "${switch10}" ]] || switch10="no"
ui_print "-带壳或阴影原图使用做背景:${switch10}"
echo '
#带壳或阴影使用原图做背景 yes or no
#注意:带壳仅支持类似仓库中[魅族18透明版]样式的半透明壳子 其他壳子关闭本项加快处理速度 一点点 大概
switch10="'${switch10}'"
' >> ${PROP}

#免打扰
echo '
#免打扰 (设置后模块在该时间段内暂停运行)
#格式要求 从t1开始 t序号="开始时:分-结束时:分"
#举个例子晚上9点半睡觉，早上7点起床那就另起一行写 t1="21:30-7:00"
#息屏后sleep时间过长会造成唤醒晚点
#多个时间段另起一行递增，例: 
	#t1="21:30-7:00"
	#t2="12:00-1:30"
	#t3=...
#如果不需要也可以删除t1=""
#下面这种是一个错误示范，不会被执行，最低休眠一分钟
	#t1="0:00-0:00"
#休眠标识行，请勿删除本行' >> ${PROP}
i=1
while :
do
	eval t=\${t${i}}
	if [[ -n "${t}" ]]; then
		ui_print "-休眠规则:t${i}=${t}"
		echo 't'${i}'="'${t}'"' >> ${PROP}
	else
		break
	fi
	i=$(( ${i} + 1))
done

#亮屏运行间隔
[[ -n "${time1}" ]] || time1="1"
ui_print "-亮屏运行间隔:${time1}"
echo '
#亮屏运行时间间隔 单位:秒 (与模块运行速度无关)
time1="'${time1}'"
' >> ${PROP}

#息屏运行间隔
[[ -n "${time2}" ]] || time2="60"
ui_print "-息屏运行间隔:${time2}"
echo '
#息屏运行时间间隔 单位:秒 (息屏点亮屏幕后也要等到时间过完才能重新启用)
time2="'${time2}'"
' >> ${PROP}

#覆盖原图
[[ -n "${switch1}" ]] || switch1="yes"
ui_print "-覆盖原图:${switch1}"
echo '
#是否覆盖原图yes or no (自定义目录第三方软件比如QQ微信有可能刷新不及时不显示)
switch1="'${switch1}'"
' >> ${PROP}

#反转颜色
[[ -n "${switch2}" ]] || switch2="yes"
ui_print "-深色模式反转颜色:${switch2}"
echo '
#深色模式自动反转原图边缘填充颜色 yes or no
switch2="'${switch2}'"
' >> ${PROP}

#杀死媒体存储
[[ -n "${switch3}" ]] || switch3="yes"
ui_print "-开机后杀死媒体存储:${switch3}"
echo '
#开机后杀掉媒体存储设备进程，不影响后续自启，这玩意不杀开机会满载CPU导致模块无法刷新相册
switch3="'${switch3}'"
' >> ${PROP}

#刷新相册
[[ -n "${switch4}" ]] || switch4="yes"
ui_print "-处理完后刷新相册:${switch4}"
echo '
#是否套完阴影后刷新相册(模块有卡死的可能，如果卡死，可手动root执行service.sh解决)
#为防止卡死，覆盖原图开启时本开关yes无效，将会强制为no
switch4="'${switch4}'"
' >> ${PROP}

#log记录
[[ -n "${switch5}" ]] || switch5="yes"
ui_print "-log记录:${switch5}"
echo '
#开启log记录(如果模块运行有问题可以改为yes然后mt直接以root执行模块观察输出或查看模块文件夹下service.log文件)
switch5="'${switch5}'"
' >> ${PROP}

#备份原图
[[ -n "${switch6}" ]] || switch6="yes"
ui_print "-备份原图:${switch6}"
echo '
#备份原图 开启覆盖原图后可将原图备份至指定目录 默认屏蔽相册显示 若需显示直接设置不覆盖原图即可
switch6="'${switch6}'"
' >> ${PROP}

#勿扰挂起
[[ -n "${switch7}" ]] || switch7="no"
ui_print "-勿扰时挂起模块:${switch7}"
echo '
#检测到开启勿扰模式时挂起模块暂停运行，关闭勿扰后重新执行
switch7="'${switch7}'"
' >> ${PROP}

#备份原图路径
[[ -n "${screenshots_bak}" ]] || screenshots_bak="/storage/emulated/0/DCIM/Screenshots_Bak"
ui_print "-原图备份目录:${screenshots_bak}"
echo '
#原图备份目录
screenshots_bak="'${screenshots_bak}'"
' >> ${PROP}

#截图目录
[[ -n "${screenshots}" ]] || screenshots=$(find /storage/emulated/0/DCIM /storage/emulated/0/Pictures -iname "Screenshots" -type d | tr "\n" " ")
ui_print "-截图目录:${screenshots}"
echo '
#系统截图目录 部分机型可能有多个目录，空格隔开
screenshots="'${screenshots}'"
' >> ${PROP}

#监测关键字
[[ -n "${format1}" ]] || format1="png|jpg|jpeg|PNG|JPG|JPEG"
ui_print "-监控关键字:${format1}"
echo '
#监控图片名字中包含的字符 用|隔开 比如只处理腾讯的截图 可以改为 tencent
format1="'${format1}'"
' >> ${PROP}

#排除关键字
[[ -n "${format2}" ]] || format2=""
ui_print "-排除关键字:${format2}"
echo '
#排除监控图片名字中包含的字符 用|隔开 优先级比 [format1] 更高 如果不需要就留空
#相册修改后会再次套图可以再下方填写修改后的关键字，例:MIUI用户填写IMG
format2="'${format2}'"
' >> ${PROP}

#阴影截图保存目录
[[ -n "${screenshots_shadow}" ]] || screenshots_shadow="/storage/emulated/0/DCIM/Screenshots_shadow"
ui_print "-阴影截图保存目录:${screenshots_shadow}"
echo '
#阴影截图保存目录 (禁止出现空格)
screenshots_shadow="'${screenshots_shadow}'"
' >> ${PROP}

#生成图片格式
[[ -n "${format3}" ]] || format3="png"
ui_print "-生成图片格式:${format3}"
echo '
#生成图片格式 png格式会特别清晰 不过图片也会比较大 即使覆盖原图时为其他后缀也不影响 实际还是当前设置格式
format3="'${format3}'"
' >> ${PROP}

#圆角半径
[[ -n "${round}" ]] || round="100"
ui_print "-圆角半径:${round}"
echo '
#圆角半径
round="'${round}'"
' >> ${PROP}

#原图占比
[[ -n "${dimen}" ]] || dimen="80%"
ui_print "-原图占比:${dimen}"
echo '
#原图在生成后的图片中占比
dimen="'${dimen}'"
' >> ${PROP}

#阴影颜色
[[ -n "${color}" ]] || color="#000000"
ui_print "-阴影颜色:${color}"
echo '
#原图周围的阴影颜色(#000000为黑色 #ffffff为白色 注意6位，别设置错了，更多颜色自行百度rgb)
color="'${color}'"
' >> ${PROP}

#阴影截图背景
[[ -n "${shadow_bg}" ]] || shadow_bg="#ffffff"
ui_print "-阴影截图背景:${shadow_bg}"
echo '
#阴影截图背景 支持图片路径和6位颜色rgb
#使用需关闭使用原图做背景
shadow_bg="'${shadow_bg}'"
' >> ${PROP}

#使用新模糊方案
[[ -n "${switch8}" ]] || switch8="yes"
ui_print "-使用新的背景模糊方案:${switch8}"
echo '
#使用新模糊方案，利用图片的缩放使图片模糊 生成特别快 模糊程度较低时会出现锯齿
switch8="'${switch8}'"
' >> ${PROP}

#高斯模糊
[[ -n "${bg}" ]] || bg="-blur 0x10"
ui_print "-高斯模糊:${bg}"
echo '
#背景高斯模糊 格式"-blue 0x<num>" 注意引号 好看就完了(越大速度越慢，50的值耗时至少3秒)(小写xyz的x不是乘号)
bg="'${bg}'"
' >> ${PROP}

#新模糊方案缩放程度
[[ -n "${zoom}" ]] || zoom="100"
ui_print "-新模糊方案模糊缩放:${zoom}"
echo '
#新模糊方案缩放程度，例:100为原图缩放为宽高100x100(保持纵横比)然后再放大回原分辨率 也就是说数值越小模糊程度越高
zoom="'${zoom}'"
' >> ${PROP}

#水印开关
[[ -n "${switch9}" ]] || switch9="yes"
ui_print "-水印开关:${switch9}"
echo '
#水印开关
switch9="'${switch9}'"
' >> ${PROP}

#水印内容
[[ -n "${watermark}" ]] || watermark="$(echo -e 'P499883779\nScreen [1] by [1] T499883779')"
ui_print "-水印:${watermark}"
echo '
#水印 目前有3种玩法 水印与水印之间空一格 写在同一行的水印生成也在同一行

	#1 可以直接输入P或者T加QQ号码生成头像或者文字 例如 P499883779 T499883779
	#2 可以直接输入图片绝对路径
	#3 可以输入自定义中英文字 但需要你选择的字体支持 换行输入以下三个字符 +_+ 尽量不要直接换行，直接换行就会按照新的水印制作，最后合成一个
	#4 支持自定义变量 但需要独特的写法我举一个简单的🌰 水印在本模块的shell变量为 [$watermark] 水印所使用的变量为避免为空，把$watermark换为%watermark%即可 变量与其他内容包括其他变量之间需留空 本文件出现的所有变量都可以这么使用
		#若对shell比较了解，可以直接在下方自定义自己的变量 变量后面建议空一格
		#以下为几个简单的水印独有变量

#我在下方写了一个time变量可以获取当前时间，水印中只需要写: %time%
time="$(date +%k:%M)"
#我在下方写了一个date变量可以获取当前日期，水印中只需要写: %date%
date="$(date +%F)"
#下方提供了一个一言接口具体参数用法可以查看 [https://developer.hitokoto.cn/sentence/#请求参数] 如有需要删除下方开头的#即可%yiyan%调用
#yiyan="$(curl -sL https://v1.hitokoto.cn/?encode=text)"

#水印中若文本中需要用空格，用 [num] 代替，前后留一个空格 num为1-32 意思是1-32个空格
#水印是由多个子水印合成的 任何试图在水印中直接添加空格和回车的行为都会被认为是另外一个子水印
#水印标识行 请勿删除本行
watermark="' >> ${PROP}
echo "${watermark}" | sed "s/^$//g" >> ${PROP}
echo '"' >> ${PROP}

#联网超时
[[ -n "${timeout}" ]] || timeout="3"
ui_print "-联网超时:${timeout}秒"
echo '
#联网超时 <num>
#水印中包含头像昵称的获取或者一言接口的 网络不通畅的情况下指定时间未获取到直接跳过
#若未开启水印刷新，被跳过后水印会显示不正常，重启下模块或者删掉水印.png即可
timeout="'${timeout}'"
' >> ${PROP}

#水印刷新
[[ -n "${refresh}" ]] || refresh="no"
ui_print "-水印刷新开关:${refresh}"
echo '
#水印刷新开关 yes or no
#开启后每次循环都会重新生成新的水印，此时水印会自动刷新 包括变量的使用
#关闭状态水印只有重启才会自动刷新，若要手动刷新删除模块目录下 [水印.png] 即可
#开启刷新生成水印耗时不到一秒，每次生成阴影截图前都会重复刷新水印
refresh="'${refresh}'"
' >> ${PROP}

#水印对齐
[[ -n "${plan}" ]] || plan="center"
ui_print "-水印对齐:${plan}"
echo '
#若上面水印除了空行超过一行的话可设置这些行 左侧对齐:west 居中:center 右侧对齐:east
plan="'${plan}'"
' >> ${PROP}

#水印字体
[[ -n "${font}" ]] || font="${MODPATH}/busybox/fonts/Roboto-Regular.ttf"
font="${font/_update/}"
ui_print "-水印字体:${font}"
echo '
#字体 可以设置自己喜欢的字体 输入绝对路径 留空将使用默认字体 ${MODPATH}为模块目录 大括号可省略 可以直接指定系统字体的哦 在/system/fonts下
font="'${font}'"
' >> ${PROP}

#水印颜色
[[ -n "${color2}" ]] || color2="#000000"
ui_print "-水印文字颜色:${color2}"
echo '
#文字水印颜色
color2="'${color2}'"
' >> ${PROP}

#阴影颜色
[[ -n "${color3}" ]] || color3="#ffffff"
ui_print "-水印阴影颜色:${color3}"
echo '
#文字边缘颜色
color3="'${color3}'"
' >> ${PROP}

#水印宽度
[[ -n "${wm_dimen}" ]] || wm_dimen="50"
[[ -n "${wm_dimen2}" ]] || wm_dimen2="100"
ui_print "-文字水印大小:${wm_dimen}"
ui_print "-图片水印大小:${wm_dimen2}"
echo '
#单个水印最大宽度或者最大高度 以最长的一边为准，比如图片200x400的会被缩小至100x200
#第一项为所有文字的大小，第二项为所有图片的
wm_dimen="'${wm_dimen}'"
wm_dimen2="'${wm_dimen2}'"
' >> ${PROP}

#水印位置
[[ -n "${location}" ]] || location="south"
ui_print "-水印位置:${location}"
echo '
#水印位置 你懂我意思吧 居中并不是绝对居中，需要调下面的边缘距离
#northwest        north        northeast
#west             center        east
#southwest       south         southeast
location="'${location}'"
' >> ${PROP}

#水印距离
[[ -n "${range_h}" ]] || range_h="0"
[[ -n "${range_v}" ]] || range_v="50"
ui_print "-水平边距:${range_h}"
ui_print "-垂直边距:${range_v}"
echo '
#水印距离边缘位置 贴边就写"0" 第一个为水平边距，第二个为垂直边距 若上面位置使用有居中，则为正中间的距离
range_h="'${range_h}'"
range_v="'${range_v}'"
' >> ${PROP}

#验证配置完整性
ui_print "-验证配置完整性，出现错误将会直接退出安装"
set -e
source ${PROP}
set +e

#生成列表
if [[ -f ${MODPATH/_update/}/list_finish ]]; then
	cp -f ${MODPATH/_update/}/list_finish ${MODPATH}/list_finish
else
	ls ${screenshots} | egrep "${format1}" > ${MODPATH}/list_finish
fi

#配置完成
ui_print "-以上选项可修改模块module.prop内容重新刷入重启"
ui_print "-以上选项可以直接修改${PROP/_update/}内容免重启即时生效"
ui_print "-图形化管理可以在阿巴酱群里获取app"
ui_print "-设置权限中，稍等"
set_perm_recursive "${MODPATH}" 0 0 0777 0777

#生成文档
echo "模块使用需知:
正确的模块目录树状图为
	busybox
		bin
			…
		fonts
			Roboto-Regular.ttf
		lib
			libbz2.so.1.0
			libfreetype.so
			libiconv.so
			libjpeg.so
			liblzma.so.5
			libpng16.so
			libtiff.so
			libz.so.1
		test
	shell
		shell_by_程鲜生.cfg
		shell_by_程鲜生.png
	module.prop
	service.sh
这些文件是不能被删除的

模块运行之后会多出来以下内容
	png
		…
	list_finish
	list_path
	list_wait
	pid
	service.log
	shadow_bg_h.png
	shadow_bg_v.png
	配置备份_勿动.txt
	水印.png

这些文件除了list_finish都可以删 但我不建议这么做 会重新生成 生成之前套壳的速度会变慢
list_finish很重要，如果不慎丢失会造成截图目录所有被正则允许的图片再次重复套壳，如果不慎删除了这个文件，可以立刻清理掉所有的截图防止模块占用大量资源
一般情况下list_path的大小加上list_wait的大小应该与list_path大小相等
list_wait是正在处理的图片列表，如果没有正在处理的话该文件会自动删除
模块正在处理图片的时候会生成几个png图片，处理完成后自动删除，不用担心
修改水印后需删除水印.png使其重新生成
如果模块没有运行起来第一部应该先修改module.prop中的log开关为yes，然后以root权限手动执行service.sh文件观察屏幕输出信息，有能力可以自行解决，没能力可以截图并提供模块目录下生成的service.log文件发给我

联系方式:
	酷安:巴啦啦魔仙女王
	QQ:499883779
	QQ群:没群，模块首发阿巴酱的群:1026874954
" > ${MODPATH}/模块运行须知.txt
