SKIPUNZIP=0
check_magisk_version() {
	ui_print "- Magisk version: $MAGISK_VER_CODE"
	ui_print "- Module version: $(grep_prop version "${TMPDIR}/module.prop")"
	if [ "$MAGISK_VER_CODE" -lt 20400 ]; then
		ui_print "***************************************************"
		ui_print "! 请安装 Magisk v20.4+ (20400+)"
		abort    "***************************************************"
	fi
}
remove_thermals() {
	ui_print "***************************************************"
	for THERMAL in $(ls /system/vendor/etc/thermal-*.conf /odm/etc/thermal-*.conf /system/vendor/etc/perf/*thermal*.* /system/vendor/etc/perf/perf*.xml /system/vendor/etc/thermal/thermal*.conf /odm/etc/ThermalServiceConfig/*.xml /odm/etc/temperature_profile/*.xml); do
		[[ ! -d $MODPATH${THERMAL%/*} ]] && mkdir -p $MODPATH${THERMAL%/*}
		touch $MODPATH$THERMAL
		ui_print "- Config file:$THERMAL"
		rm -rf $MODPATH${THERMAL%/*}/thermal*region*.conf $MODPATH${THERMAL%/*}/thermal*fan*.conf
	done
	if [ "$(getprop ro.product.brand)" == "Xiaomi" ] && [ -n "$(getprop ro.miui.ui.version.code)" ]; then
		for THERMAL_MAP in $(ls /system/vendor/etc/thermal-*map*.conf); do
			cp -f $MODPATH/thermal-map.conf $MODPATH$THERMAL_MAP
		done
		for THERMAL_NORMAL in $(ls /system/vendor/etc/thermal-*normal*.conf /odm/etc/thermal-*normal*.conf); do
			cp -f $MODPATH/thermal-normal.conf $MODPATH$THERMAL_NORMAL
		done
		[[ -f /data/current ]] && rm -rf /data/current
		if [ -d /data/vendor/thermal ]; then
			chattr -i /data/vendor/thermal /data/vendor/thermal/config /data/vendor/thermal/config/*
			rm -rf /data/vendor/thermal/config/*
			cp -f $MODPATH/thermal-*.conf /data/vendor/thermal/config
			chown -h system.system /data/vendor/thermal/config/*
			chmod a+r /data/vendor/thermal/config/*
			chattr +i /data/vendor/thermal/config /data/vendor/thermal/config/*
		fi
	fi
}
check_magisk_version
remove_thermals
set_perm_recursive "$MODPATH" 0 0 0755 0644
ui_print "***************************************************"
ui_print "通过修改温控配置的方式温和移除温控限制(含云控)，而非破坏温控，"
ui_print "以避免因温控损坏造成异常发热报错、甚至无法开机等问题。"
ui_print "同时移除温控对设备的所有限制，实现亮屏满血快充与处理器满血运行。"
ui_print "并解除游戏锁帧率、发热强制降亮度。"
ui_print "***************************************************"
ui_print "不要与其它温控类模块一起使用！！！"
ui_print "***************************************************"
chmod a+x ${MODPATH}/*.sh
