#!/system/bin/sh
MODDIR=${0%/*}
set_sys_def_scaling_governor() {
	local i=60
	while [ $i -gt 0 ]; do
		if [ "$(cat /sys/devices/system/cpu/cpufreq/policy0/scaling_governor)" ==  "performance" ]; then
			sleep 1
			i=$(($i-1))
		else
			SYS_DEF_SCALING_GOVERNOR=$(cat /sys/devices/system/cpu/cpufreq/policy0/scaling_governor)
			i=0
		fi
	done
	if [ -z "$SYS_DEF_SCALING_GOVERNOR" ]; then
		if [[ "$(cat /sys/devices/system/cpu/cpufreq/policy0/scaling_available_governors)" == *"walt"* ]]; then
			SYS_DEF_SCALING_GOVERNOR="walt"
		elif [[ "$(cat /sys/devices/system/cpu/cpufreq/policy0/scaling_available_governors)" == *"schedutil"* ]]; then
			SYS_DEF_SCALING_GOVERNOR="schedutil"
		elif [[ "$(cat /sys/devices/system/cpu/cpufreq/policy0/scaling_available_governors)" == *"ondemand"* ]]; then
			SYS_DEF_SCALING_GOVERNOR="ondemand"
		else
			exit 1
		fi
	fi
}
reset_qcom_lpm() {
	local TARGET_PATH=$1
	local TARGET_VALUE=$2
	local WRITE_PERMISSION=$3
	if [ "$(cat $TARGET_PATH)" != "$TARGET_VALUE" ]; then
		chmod a+w $TARGET_PATH
		echo "$TARGET_VALUE" > $TARGET_PATH
		if [ "$WRITE_PERMISSION" == "N" ]; then
			chmod a-w $TARGET_PATH
		fi
	fi
}
performance_mode() {
	for CPU_ONLINE in $(ls /sys/devices/system/cpu/cpu*/online 2>/dev/null); do
		if [ "$(cat $CPU_ONLINE)" == "0" ]; then
			echo "1" > $CPU_ONLINE
		fi
	done
	for SCALING_GOVERNOR_PATH in $(ls /sys/devices/system/cpu/cpufreq/policy*/scaling_governor 2>/dev/null); do
		if [[ "$(cat ${SCALING_GOVERNOR_PATH%/*}/scaling_available_governors)" == *"performance"* ]]; then
			echo "performance" > $SCALING_GOVERNOR_PATH
		fi
	done
	if [ -f /sys/devices/system/cpu/qcom_lpm/parameters/sleep_disabled ]; then
		reset_qcom_lpm  "/sys/devices/system/cpu/qcom_lpm/parameters/sleep_disabled" "1" "N"
	elif [ -f /sys/module/lpm_levels/parameters/sleep_disabled ]; then
		reset_qcom_lpm  "/sys/module/lpm_levels/parameters/sleep_disabled" "Y" "N"
	fi
	for CPUFREQ_POLICY_PATH in $(ls -d /sys/devices/system/cpu/cpufreq/policy* 2>/dev/null); do
		if [ -f ${CPUFREQ_POLICY_PATH}/cpuinfo_max_freq ] && [ -f ${CPUFREQ_POLICY_PATH}/scaling_min_freq ]; then
			echo "$(cat ${CPUFREQ_POLICY_PATH}/cpuinfo_max_freq)" > ${CPUFREQ_POLICY_PATH}/scaling_min_freq
		fi
	done
}
balanced_mode() {
	for CPU_ONLINE in $(ls /sys/devices/system/cpu/cpu*/online 2>/dev/null); do
		if [ "$(cat $CPU_ONLINE)" == "0" ]; then
			echo "1" > $CPU_ONLINE
		fi
	done
	for SCALING_GOVERNOR_PATH in $(ls /sys/devices/system/cpu/cpufreq/policy*/scaling_governor 2>/dev/null); do
		if [[ "$(cat ${SCALING_GOVERNOR_PATH%/*}/scaling_available_governors)" == *"$SYS_DEF_SCALING_GOVERNOR"* ]]; then
			echo "$SYS_DEF_SCALING_GOVERNOR" > $SCALING_GOVERNOR_PATH
		fi
	done
	if [ -f /sys/devices/system/cpu/qcom_lpm/parameters/sleep_disabled ]; then
		reset_qcom_lpm  "/sys/devices/system/cpu/qcom_lpm/parameters/sleep_disabled" "0" "Y"
	elif [ -f /sys/module/lpm_levels/parameters/sleep_disabled ]; then
		reset_qcom_lpm  "/sys/module/lpm_levels/parameters/sleep_disabled" "N" "Y"
	fi
	for CPUFREQ_POLICY_PATH in $(ls -d /sys/devices/system/cpu/cpufreq/policy* 2>/dev/null); do
		if [ -f ${CPUFREQ_POLICY_PATH}/cpuinfo_min_freq ] && [ -f ${CPUFREQ_POLICY_PATH}/scaling_min_freq ]; then
			echo "$(cat ${CPUFREQ_POLICY_PATH}/cpuinfo_min_freq)" > ${CPUFREQ_POLICY_PATH}/scaling_min_freq
		fi
	done
}
set_sys_def_scaling_governor
while true; do
	dumpsys battery reset
	sleep 1
	[ "$(settings get system speed_mode)" == 0 ] && settings put system speed_mode 1
	if [[ "$(dumpsys battery)" == *"status: 2"* ]] || [[ "$(dumpsys battery)" == *"status: 5"* ]]; then
		if [ "$(getprop sutoliu.powered_on_performance_enhancements)" ==  "Y" ] && [ ! -f ${MODDIR}/disable ]; then
			performance_mode
		fi
		local i=1
		while [ "$i" -gt "0" ]; do
			
			if [[ "$(dumpsys battery)" == *"status: 2"* ]] || [[ "$(dumpsys battery)" == *"status: 5"* ]]; then
				i=1
				sleep 1
			else
				i=0
			fi
		done
	else
		if [ "$(getprop sutoliu.powered_on_performance_enhancements)" ==  "Y" ] && [ ! -f ${MODDIR}/disable ]; then
			balanced_mode
		fi
		local i=1
		while [ "$i" -gt "0" ]; do
			if [[ "$(dumpsys battery)" == *"status: 2"* ]] || [[ "$(dumpsys battery)" == *"status: 5"* ]]; then
				i=0
			else
				i=1
				sleep 6
			fi
		done
	fi
done
