#!/system/bin/sh
SET_TRIP_POINT_TEMP_MAX=110000
MODDIR=${0%/*}
wait_sys_boot_completed() {
	while [ "$(getprop sys.boot_completed)" != "1" ]; do
		sleep 1
	done
}
perfboost() {
	for CPU_ONLINE in $(ls /sys/devices/system/cpu/cpu*/online 2>/dev/null); do
		if [ "$(cat $CPU_ONLINE)" == "0" ]; then
			echo "1" > $CPU_ONLINE
		fi
	done
	for CPUFREQ_POLICY_PATH in $(ls -d /sys/devices/system/cpu/cpufreq/policy* 2>/dev/null); do
		if [ -f ${CPUFREQ_POLICY_PATH}/cpuinfo_max_freq ] && [ -f ${CPUFREQ_POLICY_PATH}/scaling_max_freq ]; then
			echo "$(cat ${CPUFREQ_POLICY_PATH}/cpuinfo_max_freq)" > ${CPUFREQ_POLICY_PATH}/scaling_max_freq
		fi
	done
	for THERMAL_ZONE in $(ls /sys/class/thermal/thermal_zone*/type); do
		if cat $THERMAL_ZONE | grep -E "cpu|gpu|ddr" >/dev/null; then
			for TRIP_POINT_TEMP in $(ls ${THERMAL_ZONE%/*}/trip_point_*_temp); do
				if [ "$(cat $TRIP_POINT_TEMP)" -lt "$SET_TRIP_POINT_TEMP_MAX" ]; then
					echo "$SET_TRIP_POINT_TEMP_MAX" > $TRIP_POINT_TEMP
				fi
			done
		fi
	done
}
wait_sys_boot_completed
perfboost
nohup ${MODDIR}/ultra_performance.sh >/dev/null 2>&1 &
if [ "$(getprop ro.product.brand)" == "Xiaomi" ] && [ -n "$(getprop ro.miui.ui.version.code)" ]; then
	settings put system POWER_SAVE_PRE_HIDE_MODE performance
	settings put Secure speed_mode_enable 1
	settings put system speed_mode 1
fi
if [ "$(cat /proc/game_opt/disable_cpufreq_limit)" == "0" ]; then
	echo "1" > /proc/game_opt/disable_cpufreq_limit
fi
